/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.base.draw;

import com.objectshare.base.draw.OSIBufferedDisplaySystem;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class OSIScrolledDisplaySystem
extends OSIBufferedDisplaySystem {
    public static int defaultBufferWidth = 1500;
    public static int defaultBufferHeight = 1000;
    protected transient int offsetX;
    protected transient int offsetY;

    public OSIScrolledDisplaySystem() {
        this(defaultBufferWidth, defaultBufferHeight);
    }

    public OSIScrolledDisplaySystem(int n, int n2) {
        this.setBufferSize(n, n2);
    }

    public Dimension getBufferSize() {
        return new Dimension(this.bufferWidth, this.bufferHeight);
    }

    public void setBufferSize(Dimension dimension) {
        this.setBufferSize(dimension.width, dimension.height);
    }

    public synchronized void setBufferSize(int n, int n2) {
        if (this.buffer == null) {
            this.bufferWidth = n;
            this.bufferHeight = n2;
            return;
        }
        this.reshapeBuffer(n, n2);
    }

    public Rectangle getBufferBounds() {
        Rectangle rectangle = this.getContentBounds();
        return new Rectangle(rectangle.x - this.offsetX, rectangle.y - this.offsetY, this.bufferWidth, this.bufferHeight);
    }

    public void damageAll() {
        this.damagedRegion.add(this.getBufferBounds());
    }

    public void damageRegion(Rectangle rectangle) {
        this.damagedRegion.add(this.getBufferBounds().intersection(rectangle));
    }

    protected void reshapeBuffer(int n, int n2) {
        Image image = this.buffer;
        super.reshapeBuffer(n, n2);
        if (this.buffer != image) {
            this.offsetX = 0;
            this.offsetY = 0;
            this.damageAll();
        }
    }

    protected void reshapeBuffer() {
        Rectangle rectangle = this.getContentBounds();
        this.reshapeBuffer(this.bufferWidth >= rectangle.width ? this.bufferWidth : rectangle.width, this.bufferHeight >= rectangle.height ? this.bufferHeight : rectangle.height);
    }

    public void repairDamage() {
        this.damagedRegion.repair();
        Graphics graphics = this.getCanvas().getGraphics();
        if (graphics != null) {
            this.display(graphics);
        }
    }

    public void repairDamage(Rectangle rectangle) {
        if (this.buffer == null) {
            return;
        }
        Rectangle rectangle2 = this.getBufferBounds();
        Graphics graphics = this.buffer.getGraphics();
        graphics.translate(-rectangle2.x, -rectangle2.y);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.basicDisplay(graphics);
        graphics.dispose();
    }

    public void paint(Graphics graphics) {
        this.reshapeBuffer();
        this.damagedRegion.repair();
        this.display(graphics);
        this.displayBorder(graphics);
    }

    public void display(Graphics graphics) {
        if (this.buffer == null) {
            return;
        }
        Rectangle rectangle = this.getContentBounds();
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.drawImage(this.buffer, -this.offsetX, -this.offsetY, this.getCanvas());
        graphics2.dispose();
    }

    public synchronized void scroll(int n, int n2) {
        if (this.buffer == null || n == 0 && n2 == 0) {
            return;
        }
        this.offsetX -= n;
        this.offsetY -= n2;
        this.damagedRegion.translate(n, n2);
        Rectangle rectangle = this.getBufferBounds();
        Rectangle rectangle2 = this.getContentBounds();
        int n3 = 0;
        int n4 = 0;
        int n5 = (rectangle.width - rectangle2.width) * 2 / 3;
        int n6 = (rectangle.height - rectangle2.height) * 2 / 3;
        if (rectangle.x > rectangle2.x) {
            n3 = rectangle.x - rectangle2.x + n5;
        }
        if (rectangle.x + rectangle.width < rectangle2.x + rectangle2.width) {
            n3 = rectangle.x + rectangle.width - rectangle2.x - rectangle2.width - n5;
        }
        if (rectangle.y > rectangle2.y) {
            n4 = rectangle.y - rectangle2.y + n6;
        }
        if (rectangle.y + rectangle.height < rectangle2.y + rectangle2.height) {
            n4 = rectangle.y + rectangle.height - rectangle2.y - rectangle2.height - n6;
        }
        if (n3 == 0 && n4 == 0) {
            return;
        }
        Graphics graphics = this.buffer.getGraphics();
        graphics.copyArea(0, 0, this.bufferWidth, this.bufferHeight, n3, n4);
        graphics.dispose();
        this.offsetX += n3;
        this.offsetY += n4;
        rectangle = this.getBufferBounds();
        if (n3 < 0) {
            this.damagedRegion.add(new Rectangle(rectangle.x + this.bufferWidth + n3, rectangle.y, -n3, this.bufferHeight));
        }
        if (n3 > 0) {
            this.damagedRegion.add(new Rectangle(rectangle.x, rectangle.y, n3, this.bufferHeight));
        }
        if (n4 < 0) {
            this.damagedRegion.add(new Rectangle(rectangle.x, rectangle.y + this.bufferHeight + n4, this.bufferWidth, -n4));
        }
        if (n4 > 0) {
            this.damagedRegion.add(new Rectangle(rectangle.x, rectangle.y, this.bufferWidth, n4));
        }
        this.damagedRegion.intersect(rectangle);
    }
}

