/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.data;

import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntDictEvent;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKModelColsEvent;

public class JKModelColsChangedEvent
extends JKModelColsEvent {
    int firstColumn;
    Object[] oldColumns;
    Object[] newColumns;
    Object[] columnsAdded;
    Object[] columnsRemoved;

    public JKModelColsChangedEvent(JKModel jKModel, String string, int n, Object[] objectArray) {
        super(jKModel, string);
        if (objectArray == null) {
            throw new IllegalArgumentException("null columns changed");
        }
        this.firstColumn = n;
        this.oldColumns = objectArray;
    }

    public int getFirst() {
        return this.firstColumn;
    }

    public int getSize() {
        return this.oldColumns.length;
    }

    public OSIEnumeration getNew() {
        if (this.newColumns == null) {
            this.newColumns = this.getModel().getColumnArray(this.firstColumn, this.oldColumns.length);
        }
        return OSIEnumeration.newFor((Object[])this.newColumns);
    }

    public OSIEnumeration getOld() {
        return OSIEnumeration.newFor((Object[])this.oldColumns);
    }

    public OSIEnumeration getAdded() {
        if (this.columnsAdded == null) {
            this.columnsAdded = OSIIntDictEvent.subtract((OSIEnumeration)this.getNew(), (OSIEnumeration)this.getOld());
        }
        return OSIEnumeration.newFor((Object[])this.columnsAdded);
    }

    public OSIEnumeration getRemoved() {
        if (this.columnsRemoved == null) {
            this.columnsRemoved = OSIIntDictEvent.subtract((OSIEnumeration)this.getOld(), (OSIEnumeration)this.getNew());
        }
        return OSIEnumeration.newFor((Object[])this.columnsRemoved);
    }

    public JKTableArea getArea() {
        return JKTableArea.newForColumns(this.firstColumn, this.oldColumns.length);
    }
}

