/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.draw;

import com.objectshare.grid.draw.JKImage;
import com.objectshare.grid.view.JKDrawViewEvent;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;

public class JKDrawnImage
extends JKImage
implements ImageObserver {
    static JKDrawnImage firstDrawnImage;
    static JKDrawnImage lastDrawnImage;
    static Toolkit toolkit;
    public URL imageURL;
    transient JKDrawnImage nextDrawnImage;
    transient int status;

    public static synchronized void waitForAll() {
        JKDrawnImage.waitForAll(0L);
    }

    public static synchronized void waitForAll(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        JKDrawnImage jKDrawnImage = firstDrawnImage;
        while (jKDrawnImage != null) {
            l2 = System.currentTimeMillis();
            jKDrawnImage.waitForLoad(l <= 0L ? 0L : l3 - l2);
            jKDrawnImage = jKDrawnImage.nextDrawnImage;
        }
    }

    static synchronized void appendDrawnImage(JKDrawnImage jKDrawnImage) {
        if (lastDrawnImage != null) {
            JKDrawnImage.lastDrawnImage.nextDrawnImage = jKDrawnImage;
        } else {
            firstDrawnImage = jKDrawnImage;
        }
        lastDrawnImage = jKDrawnImage;
    }

    public JKDrawnImage(URL uRL) {
        this.loadImage(uRL);
    }

    public JKDrawnImage(URL uRL, String string) {
        try {
            this.loadImage(new URL(uRL, string));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
            return;
        }
    }

    protected void loadImage(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("image URL cannot be null");
        }
        this.imageURL = uRL;
        this.image = toolkit.getImage(this.imageURL);
        toolkit.prepareImage(this.image, -1, -1, this);
        JKDrawnImage.appendDrawnImage(this);
    }

    public void waitForLoad() {
        this.waitForLoad(0L);
    }

    public synchronized void waitForLoad(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        while (this.isLoading()) {
            l2 = System.currentTimeMillis();
            if (l > 0L && l2 >= l3) {
                return;
            }
            try {
                this.wait(l <= 0L ? 0L : l3 - l2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean isLoading() {
        return (this.getStatus() & 0xF0) == 0;
    }

    public int getStatus() {
        return this.status;
    }

    public Dimension jkExtent(JKDrawViewEvent jKDrawViewEvent) {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public void jkDraw(JKDrawViewEvent jKDrawViewEvent, Rectangle rectangle) {
        JKImage.drawImage(this.image, rectangle, this, jKDrawViewEvent.graphics, jKDrawViewEvent.getBackColor(), jKDrawViewEvent.getHorizontalJustification(), jKDrawViewEvent.getVerticalJustification(), this.stretch != 0 ? this.stretch : jKDrawViewEvent.getScale());
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this.status |= n;
        if ((n & 0x40) != 0) {
            this.notifyAll();
            System.out.println("error loading image: " + this.imageURL);
            return false;
        }
        if ((n & 0x80) != 0) {
            this.notifyAll();
            System.out.println("aborted loading image: " + this.imageURL);
            return false;
        }
        if ((n & 0x30) != 0) {
            this.notifyAll();
            this.setChanged();
            this.notifyObservers();
        }
        return (n & 0x20) == 0;
    }

    public JKDrawnImage(URL uRL, int n) {
        super(null, n);
        this.imageURL = uRL;
    }

    public JKDrawnImage(URL uRL, String string, int n) {
        super(null, n);
        try {
            this.imageURL = new URL(uRL, string);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.imageURL = null;
            System.out.println(malformedURLException);
            return;
        }
    }

    public JKDrawnImage(Image image) {
        super(image);
    }

    public JKDrawnImage(Image image, int n) {
        super(image, n);
    }

    static {
        toolkit = Toolkit.getDefaultToolkit();
    }
}

