/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.edit;

import com.objectshare.grid.draw.JKDrawnObject;
import com.objectshare.grid.draw.JKDrawnString;
import com.objectshare.grid.draw.JKHierDrawnObject;
import com.objectshare.grid.edit.JKEditAction;
import com.objectshare.grid.edit.JKTableEdit;
import java.awt.Component;
import java.util.EventObject;

public class JKEditEvent
extends EventObject {
    JKEditAction action;

    public JKEditEvent(JKEditAction jKEditAction) {
        this((JKTableEdit)jKEditAction.owner, jKEditAction);
    }

    public JKEditEvent(JKTableEdit jKTableEdit, JKEditAction jKEditAction) {
        super(jKTableEdit);
        if (jKEditAction == null) {
            throw new IllegalArgumentException("null action");
        }
        this.action = jKEditAction;
    }

    public JKTableEdit getTableEdit() {
        return this.action.getTableEdit();
    }

    public int getColumnNumber() {
        return this.action.dataX;
    }

    public int getRowNumber() {
        return this.action.dataY;
    }

    public Object getRowAdapter() {
        return this.action.owner.getModel().getRowAdapter(this.getRowNumber());
    }

    public Object getOldValue() {
        return this.action.originalValue;
    }

    public JKDrawnObject getOldDrawnValue() {
        JKDrawnObject jKDrawnObject = JKDrawnString.newFor(this.action.owner, this.getOldValue());
        if (this.getColumnNumber() == 1 && this.getRowNumber() > 0) {
            jKDrawnObject = JKHierDrawnObject.newFor(this.getRowAdapter(), jKDrawnObject);
        }
        return jKDrawnObject;
    }

    public Object getNewValue() {
        return this.action.currentValue;
    }

    public void setNewValue(Object object) {
        this.action.currentValue = object;
    }

    public JKDrawnObject getNewDrawnValue() {
        JKDrawnObject jKDrawnObject = JKDrawnString.newFor(this.action.owner, this.getNewValue());
        if (this.getColumnNumber() == 1 && this.getRowNumber() > 0) {
            jKDrawnObject = JKHierDrawnObject.newFor(this.getRowAdapter(), jKDrawnObject);
        }
        return jKDrawnObject;
    }

    public boolean hasChanged() {
        Object object = this.getNewValue();
        if (object == null) {
            return this.getOldValue() != null;
        }
        return !object.equals(this.getOldValue());
    }

    public Object getEditor() {
        return this.action.editor;
    }

    public Component getCachedEditor(String string) {
        return this.action.getEditor(string);
    }

    public boolean validateEditor() {
        return this.action.validate();
    }

    public void addItemListener() {
        this.action.addItemListener();
    }

    public void removeItemListener() {
        this.action.removeItemListener();
    }

    public void addMouseListener() {
        this.action.addMouseListener();
    }

    public void removeMouseListener() {
        this.action.removeMouseListener();
    }

    public void addMouseMotionListener() {
        this.action.addMouseMotionListener();
    }

    public void removeMouseMotionListener() {
        this.action.removeMouseMotionListener();
    }

    public void addKeyListener() {
        this.action.addKeyListener();
    }

    public void removeKeyListener() {
        this.action.removeKeyListener();
    }

    public void addFocusListener() {
        this.action.addFocusListener();
    }

    public void removeFocusListener() {
        this.action.removeFocusListener();
    }

    public JKTableEdit getTable() {
        return (JKTableEdit)this.getSource();
    }

    public int getColumn() {
        return this.action.dataX;
    }

    public int getRow() {
        return this.action.dataY;
    }

    public JKEditAction getEditAction() {
        return this.action;
    }
}

