/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class JKFramer {
    public static final int TWIP = 1;
    public static final int INCH = 2;
    public static final int PIXEL = 3;
    public static final int CENTIMETER = 4;
    public static int DefaultScaleUnit;
    public static int PixelsPerInch;
    public static int PixelsPerMeter;
    public float left;
    public float top;
    public float right;
    public float bottom;
    public int mask;
    public int scaleUnit;

    public JKFramer() {
        this.scaleUnit = 1;
        this.mask = 136;
    }

    public JKFramer(int n, float f, float f2, float f3, float f4, int n2) {
        this.scaleUnit = n;
        this.left = f;
        this.top = f2;
        this.right = f3;
        this.bottom = f4;
        this.mask = n2;
    }

    public static int pixelsPerInch() {
        if (PixelsPerInch == 0) {
            PixelsPerInch = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        return PixelsPerInch;
    }

    public static int pixelsPerMeter() {
        if (PixelsPerMeter == 0) {
            PixelsPerMeter = (int)((double)JKFramer.pixelsPerInch() * 39.3700787);
        }
        return PixelsPerMeter;
    }

    protected float pixelToScaleUnit(int n, int n2) {
        if (n2 == 1) {
            return n * 1440 / JKFramer.pixelsPerInch();
        }
        if (n2 == 2) {
            return n / JKFramer.pixelsPerInch();
        }
        if (n2 == 4) {
            return n * 100 / JKFramer.pixelsPerMeter();
        }
        return n;
    }

    protected int scaleUnitToPixel(float f, int n) {
        if (this.scaleUnit == 1) {
            return (int)(f * (float)JKFramer.pixelsPerInch() / 1400.0f);
        }
        if (this.scaleUnit == 2) {
            return (int)(f * (float)JKFramer.pixelsPerInch());
        }
        if (this.scaleUnit == 4) {
            return (int)(f * (float)JKFramer.pixelsPerMeter() / 100.0f);
        }
        return (int)f;
    }

    protected boolean isBottomInset() {
        return (this.mask & 2) > 0;
    }

    protected boolean isBottomStretched() {
        return (this.mask & 1) > 0;
    }

    protected boolean isHorizontallyCentered() {
        return !this.isLeftInset() && !this.isRightInset();
    }

    protected boolean isLeftInset() {
        return (this.mask & 0x80) > 0;
    }

    protected boolean isLeftStretched() {
        return (this.mask & 0x40) > 0;
    }

    protected boolean isRightInset() {
        return (this.mask & 0x20) > 0;
    }

    protected boolean isRightStretched() {
        return (this.mask & 0x10) > 0;
    }

    protected boolean isTopInset() {
        return (this.mask & 8) > 0;
    }

    protected boolean isTopStretched() {
        return (this.mask & 4) > 0;
    }

    protected boolean isVerticallyCentered() {
        return !this.isTopInset() && !this.isBottomInset();
    }

    protected JKFramer unrelativeTo(Rectangle rectangle) {
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        float f = this.pixelToScaleUnit(dimension.width, this.scaleUnit);
        float f2 = this.pixelToScaleUnit(dimension.height, this.scaleUnit);
        float f3 = this.left;
        float f4 = this.top;
        float f5 = this.right;
        float f6 = this.bottom;
        if (this.isLeftStretched()) {
            f3 = this.left * f;
        }
        if (this.isBottomStretched()) {
            f6 = this.bottom * f2;
        }
        if (this.isRightStretched()) {
            f5 = this.right * f;
        }
        if (this.isTopStretched()) {
            f4 = this.top * f2;
        }
        JKFramer jKFramer = new JKFramer(this.scaleUnit, f3, f4, f5, f6, this.mask);
        return jKFramer;
    }

    public Rectangle scaleFrom(Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        JKFramer jKFramer = this.unrelativeTo(rectangle);
        int n5 = this.scaleUnitToPixel(jKFramer.left, this.scaleUnit);
        int n6 = this.scaleUnitToPixel(jKFramer.top, this.scaleUnit);
        int n7 = this.scaleUnitToPixel(jKFramer.right, this.scaleUnit);
        int n8 = this.scaleUnitToPixel(jKFramer.bottom, this.scaleUnit);
        if (this.isLeftInset()) {
            n4 = rectangle.x + n5;
            n3 = this.isRightInset() ? Math.max(rectangle.x + rectangle.width - n7, n4 + 1) : n4 + n7;
        } else if (this.isRightInset()) {
            n3 = rectangle.x + rectangle.width - n7;
            n4 = n3 - n5;
        } else {
            n4 = rectangle.x + n5 - n7 / 2;
            n3 = n4 + n7;
        }
        if (this.isTopInset()) {
            n2 = rectangle.y + n6;
            n = this.isBottomInset() ? Math.max(rectangle.y + rectangle.height - n8, n2 + 1) : n2 + n8;
        } else if (this.isBottomInset()) {
            n = rectangle.y + rectangle.height - n8;
            n2 = n - n6;
        } else {
            n2 = rectangle.y + n6 - n8 / 2;
            n = n2 + n8;
        }
        return new Rectangle(n4, n2, n3 - n4, n - n2);
    }
}

