/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example.explorer;

import com.objectshare.grid.data.JKRowAdapter;
import com.objectshare.grid.data.JKTableModel;
import com.objectshare.grid.edit.JKChoiceEditingPolicy;
import com.objectshare.grid.edit.JKTableEdit;
import com.objectshare.grid.example.JKExampleApplet;
import com.objectshare.grid.example.JKExampleFrame;
import com.objectshare.grid.example.explorer.ArchivedColumnDef;
import com.objectshare.grid.example.explorer.ExplorerDirectory;
import com.objectshare.grid.example.explorer.ExplorerFile;
import com.objectshare.grid.example.explorer.FileNameColumnDef;
import com.objectshare.grid.example.explorer.FileSizeColumnDef;
import com.objectshare.grid.example.explorer.FileTypeColumnDef;
import com.objectshare.grid.example.explorer.ModifiedColumnDef;
import com.objectshare.grid.list.JKNoSelectionException;
import com.objectshare.grid.list.JKSelectionEvent;
import com.objectshare.grid.list.JKSelectionListener;
import com.objectshare.grid.tool.JKCellEditTool;
import com.objectshare.grid.tool.JKExtendedRowSelectTool;
import com.objectshare.grid.tool.JKHierarchicalTool;
import com.objectshare.grid.tool.JKReorderColTool;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.util.NoSuchElementException;

public class Explorer
extends JKExampleApplet
implements JKSelectionListener {
    public JKTableEdit table;
    public Checkbox rowHeadersCB = new Checkbox("Row Headers");
    public Checkbox columnHeadersCB = new Checkbox("Column Headers");
    public Checkbox rowGridLinesCB = new Checkbox("Row Grid Lines");
    public Checkbox columnGridLinesCB = new Checkbox("Column Grid Lines");
    public Label rowsLockedLabel = new Label("Rows Locked:");
    public Label columnsLockedLabel = new Label("Columns Locked:");
    public Choice rowsLockedChoice = new Choice();
    public Choice columnsLockedChoice = new Choice();
    public Button addButton = new Button("Add Child");
    public Button removeButton = new Button("Remove");
    public Button testButton = new Button("Test");
    public static String[] fileTypes = new String[]{"CLASS File", "File", "File Folder", "Hypertext Doc", "JAVA File", "PROPERTIES File"};
    protected Panel controls = new Panel();
    protected Panel buttons = new Panel();
    public static boolean addTestButton;

    public static void main(String[] stringArray) {
        Explorer explorer = new Explorer();
        new JKExampleFrame(explorer, "Explorer", 500, 266);
    }

    public void init() {
        super.init();
        ((Container)((Object)this)).setLayout(new BorderLayout(0, 0));
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.initTable();
        this.initControls();
    }

    public void initTable() {
        JKTableModel jKTableModel = new JKTableModel();
        jKTableModel.addRows(this.newExplorerFiles());
        JKRowAdapter.addRowAdapterAssociation("com.objectshare.grid.example.explorer.ExplorerFile", "com.objectshare.grid.data.JKRowAdapter");
        JKRowAdapter.addRowAdapterAssociation("com.objectshare.grid.example.explorer.ExplorerDirectory", "com.objectshare.grid.example.explorer.ExplorerDirectoryJKRA");
        jKTableModel.addColumn(new FileNameColumnDef("Name"));
        jKTableModel.addColumn(new FileSizeColumnDef("Size"));
        jKTableModel.addColumn(new FileTypeColumnDef("Type"));
        jKTableModel.addColumn(new ModifiedColumnDef("Modified"));
        jKTableModel.addColumn(new ArchivedColumnDef("Archive"));
        FileNameColumnDef.setFileImage(this.getFileImage());
        FileNameColumnDef.setDirectoryImage(this.getDirectoryImage());
        this.table = new JKTableEdit(jKTableModel);
        this.table.addDrawnValueAssociation("java.lang.Integer", "com.objectshare.grid.example.explorer.ExplorerDrawnFileSize");
        this.table.setColumnReadOnly(2);
        this.table.setColumnEditingPolicy(3, new JKChoiceEditingPolicy(fileTypes));
        this.table.setRowHeaderTool(new JKExtendedRowSelectTool());
        this.table.setColumnHeaderTool(new JKReorderColTool());
        this.table.setCellAreaTool(new JKHierarchicalTool(new JKCellEditTool(new JKExtendedRowSelectTool())));
        this.table.setBackground(Color.white);
        this.table.setRowHeaders(false);
        this.rowHeadersCB.setState(false);
        this.table.setColumnHeaders(true);
        this.columnHeadersCB.setState(true);
        this.table.setCellBorderRight(false);
        this.table.setCellBorderBottom(false);
        ((Container)((Object)this)).add("Center", (Component)((Object)this.table));
        this.table.addJKSelectionListener(this);
    }

    public void initControls() {
        this.initLockedChoice(this.rowsLockedChoice);
        this.initLockedChoice(this.columnsLockedChoice);
        this.rowsLockedChoice.select(this.rowsLockedChoice.getItem(0));
        this.columnsLockedChoice.select(this.columnsLockedChoice.getItem(0));
        ((Container)((Object)this)).add("South", this.controls);
        this.controls.setLayout(new GridBagLayout());
        int n = 10;
        int n2 = 0;
        this.addControl(n, 0, 10, 5, 1, 1, 17, this.rowHeadersCB);
        this.addControl(n2, 0, 10, 5, 1, 2, 17, this.columnHeadersCB);
        this.addControl(n, 0, 5, 5, 2, 1, 17, this.rowGridLinesCB);
        this.addControl(n2, 0, 5, 5, 2, 2, 17, this.columnGridLinesCB);
        this.addControl(n, 0, 5, 5, 3, 1, 13, this.rowsLockedLabel);
        this.addControl(n2, 0, 5, 5, 3, 2, 13, this.columnsLockedLabel);
        this.addControl(n, 0, 5, 5, 4, 1, 17, this.rowsLockedChoice);
        this.addControl(n2, 0, 5, 5, 4, 2, 17, this.columnsLockedChoice);
        this.addControl(n2, 0, 5, 5, 1, 3, 4, 1, 17, this.buttons);
        this.buttons.add(this.addButton);
        this.buttons.add(this.removeButton);
        this.addButton.disable();
        this.removeButton.disable();
        if (addTestButton) {
            this.buttons.add(this.testButton);
        }
    }

    public void addControl(int n, int n2, int n3, int n4, int n5, int n6, int n7, Component component) {
        this.addControl(n, n2, n3, n4, n5, n6, 1, 1, n7, component);
    }

    public void addControl(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n5;
        gridBagConstraints.gridy = n6;
        gridBagConstraints.gridwidth = n7;
        gridBagConstraints.gridheight = n8;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = n9;
        gridBagConstraints.weightx = 25.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(n, n3, n2, n4);
        ((GridBagLayout)this.controls.getLayout()).setConstraints(component, gridBagConstraints);
        this.controls.add(component);
    }

    public void initLockedChoice(Choice choice) {
        choice.addItem("0");
        choice.addItem("1");
        choice.addItem("2");
        choice.addItem("3");
    }

    public void jkSelecting(JKSelectionEvent jKSelectionEvent) {
    }

    public void jkSelected(JKSelectionEvent jKSelectionEvent) {
        if (jKSelectionEvent.getNewSelectedRowIndices().toArray().length == 1) {
            this.removeButton.enable();
            if (jKSelectionEvent.getNewSelectedRowObjectOrNull() instanceof ExplorerDirectory) {
                this.addButton.enable();
                return;
            }
            this.addButton.disable();
            return;
        }
        this.removeButton.disable();
        this.addButton.disable();
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.rowGridLinesCB || event.target == this.columnGridLinesCB) {
            this.table.setCellBorders(this.columnGridLinesCB.getState(), this.rowGridLinesCB.getState());
            return true;
        }
        if (event.target == this.columnHeadersCB || event.target == this.rowHeadersCB) {
            this.table.showHeaders(this.columnHeadersCB.getState(), this.rowHeadersCB.getState());
            return true;
        }
        if (event.target == this.rowsLockedChoice) {
            this.table.closeEditor();
            this.table.lockRowsToTop(new Integer(this.rowsLockedChoice.getSelectedItem()));
            return true;
        }
        if (event.target == this.columnsLockedChoice) {
            this.table.closeEditor();
            this.table.lockColumnsToLeft(new Integer(this.columnsLockedChoice.getSelectedItem()));
            return true;
        }
        if (event.target == this.addButton) {
            this.addNewFile();
            return true;
        }
        if (event.target == this.removeButton) {
            this.removeFileOrDirectory();
            return true;
        }
        if (event.target == this.testButton) {
            this.testSomething();
            return true;
        }
        return super.action(event, object);
    }

    public void addNewFile() {
        try {
            Object object = this.table.getSelectedRowObject();
            if (object instanceof ExplorerDirectory) {
                ExplorerFile explorerFile = ((ExplorerDirectory)object).addFile();
                this.table.getModel().expandRow(object);
                int n = this.table.getModel().getRowNumber(explorerFile);
                this.table.scrollToRow(n);
                return;
            }
            System.out.println("Cannot add child to file");
            return;
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            System.out.println("no row selected");
            return;
        }
    }

    public void removeFileOrDirectory() {
        try {
            Object object = this.table.getSelectedRowObject();
            JKTableModel jKTableModel = (JKTableModel)this.table.getModel();
            try {
                Object object2 = jKTableModel.getParentRow(object);
                if (object2 instanceof ExplorerDirectory) {
                    ((ExplorerDirectory)object2).removeFile(object);
                } else {
                    jKTableModel.removeRow(object);
                }
                this.addButton.disable();
                this.removeButton.disable();
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                System.out.println("row not found in model");
                return;
            }
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            System.out.println("no row selected");
            return;
        }
    }

    public void testSomething() {
        try {
            this.table.getSelectedRowObject();
            this.table.setRowForeColor(this.table.getSelectedRowIndex(), Color.red);
            return;
        }
        catch (JKNoSelectionException jKNoSelectionException) {
            System.out.println("no row selected");
            return;
        }
    }

    public Image getDirectoryImage() {
        int n = 0;
        int n2 = 0;
        Image image = ((Component)((Object)this)).createImage(17, 15);
        if (image == null) {
            return null;
        }
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n, n2 + 2, n, n2 + 11);
        graphics.drawLine(n, n2 + 11, n + 15, n2 + 11);
        graphics.drawLine(n + 15, n2 + 11, n + 15, n2 + 2);
        graphics.drawLine(n + 15, n2 + 2, n + 8, n2 + 2);
        graphics.drawLine(n + 7, n2 + 1, n + 7, n2 + 1);
        graphics.drawLine(n + 6, n2, n + 2, n2);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics.setColor(new Color(138, 138, 205));
        graphics.fillRect(n + 2, n2 + 4, 13, 7);
        graphics.fillRect(n + 1, n2 + 2, 7, 1);
        graphics.fillRect(n + 2, n2 + 1, 5, 1);
        graphics.setColor(Color.black);
        graphics.drawLine(n + 1, n2 + 12, n + 16, n2 + 12);
        graphics.drawLine(n + 16, n2 + 12, n + 16, n2 + 3);
        graphics.dispose();
        return image;
    }

    public Image getFileImage() {
        int n = 0;
        int n2 = 0;
        Image image = ((Component)((Object)this)).createImage(12, 15);
        if (image == null) {
            return null;
        }
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n, n2, n, n2 + 12);
        graphics.drawLine(n, n2, n + 7, n2);
        graphics.drawLine(n + 8, n2 + 1, n + 8, n2 + 1);
        graphics.drawLine(n + 9, n2 + 2, n + 9, n2 + 2);
        graphics.setColor(Color.gray);
        graphics.drawLine(n + 7, n2 + 1, n + 7, n2 + 2);
        graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 12);
        graphics.drawLine(n + 9, n2 + 12, n + 1, n2 + 12);
        graphics.setColor(Color.black);
        graphics.drawLine(n, n2 + 13, n + 10, n2 + 13);
        graphics.drawLine(n + 10, n2 + 13, n + 10, n2 + 3);
        graphics.drawLine(n + 10, n2 + 3, n + 7, n2 + 3);
        graphics.dispose();
        return image;
    }

    public ExplorerFile newExplorerFile(String string, int n, String string2, String string3) {
        return this.newExplorerFile(string, n, string2, string3, Boolean.FALSE);
    }

    public ExplorerFile newExplorerFile(String string, int n, String string2, String string3, Boolean bl) {
        return new ExplorerFile(string, n, string2, string3, bl);
    }

    public ExplorerDirectory newExplorerDirectory(String string, int n, String string2, String string3, ExplorerFile[] explorerFileArray) {
        return this.newExplorerDirectory(string, n, string2, string3, Boolean.FALSE, explorerFileArray);
    }

    public ExplorerDirectory newExplorerDirectory(String string, int n, String string2, String string3, Boolean bl, ExplorerFile[] explorerFileArray) {
        return new ExplorerDirectory(string, n, string2, string3, bl, explorerFileArray);
    }

    public ExplorerFile[] newExplorerFiles() {
        ExplorerFile[] explorerFileArray = new ExplorerFile[]{this.newExplorerFile("TTY.java", 43, "JAVA File", "05/03/96 05:03:30 AM")};
        ExplorerFile[] explorerFileArray2 = new ExplorerFile[]{this.newExplorerDirectory("ttydebug", 0, "File Folder", "07/30/96 02:36:48 PM", explorerFileArray)};
        ExplorerFile[] explorerFileArray3 = new ExplorerFile[]{this.newExplorerDirectory("tools", 0, "File Folder", "07/30/96 02:36:48 PM", explorerFileArray2)};
        ExplorerFile[] explorerFileArray4 = new ExplorerFile[]{this.newExplorerFile("BitSet.java", 5, "JAVA File", "05/03/96 03:30:44 AM"), this.newExplorerFile("Date.java", 18, "JAVA File", "05/03/96 03:30:44 AM"), this.newExplorerFile("Dictionary.java", 3, "JAVA File", "05/03/96 03:30:44 AM"), this.newExplorerFile("EmptyStackException.java", 2, "JAVA File", "05/03/96 03:30:42 AM")};
        ExplorerFile[] explorerFileArray5 = new ExplorerFile[]{this.newExplorerFile("ContentHandler.java", 2, "JAVA File", "05/03/96 03:31:06 AM"), this.newExplorerFile("ContentHandlerFactory.java", 2, "JAVA File", "05/03/96 03:31:08 AM"), this.newExplorerFile("DatagramPacket.java", 3, "JAVA File", "05/03/96 03:31:08 AM"), this.newExplorerFile("DatagramSocket.java", 5, "JAVA File", "05/03/96 03:31:08 AM")};
        ExplorerFile[] explorerFileArray6 = new ExplorerFile[]{this.newExplorerDirectory("net", 0, "File Folder", "07/30/96 02:36:46 PM", explorerFileArray5), this.newExplorerDirectory("util", 0, "File Folder", "07/30/96 02:36:46 PM", explorerFileArray4)};
        ExplorerFile[] explorerFileArray7 = new ExplorerFile[]{this.newExplorerDirectory("java", 0, "File Folder", "07/30/96 02:36:40 PM", explorerFileArray6), this.newExplorerDirectory("sun", 0, "File Folder", "07/30/96 02:36:48 PM", explorerFileArray3)};
        ExplorerFile[] explorerFileArray8 = new ExplorerFile[]{this.newExplorerFile("ZipConstants.class", 2, "CLASS File", "03/08/96 02:01:40 AM"), this.newExplorerFile("ZipEntry.class", 2, "CLASS File", "03/08/96 02:00:54 AM"), this.newExplorerFile("ZipFile.class", 5, "CLASS File", "03/08/96 02:01:54 AM"), this.newExplorerFile("ZipFormatException.class", 1, "CLASS File", "03/08/96 02:01:16 AM")};
        ExplorerFile[] explorerFileArray9 = new ExplorerFile[]{this.newExplorerFile("TTY.class", 28, "CLASS File", "03/08/96 02:04:58 AM")};
        ExplorerFile[] explorerFileArray10 = new ExplorerFile[]{this.newExplorerDirectory("ttydebug", 0, "File Folder", "07/30/96 02:36:16 PM", explorerFileArray9), this.newExplorerDirectory("zip", 0, "File Folder", "07/30/96 02:36:10 PM", explorerFileArray8)};
        ExplorerFile[] explorerFileArray11 = new ExplorerFile[]{this.newExplorerFile("Handler.class", 1, "CLASS File", "01/12/96 09:49:10 AM"), this.newExplorerFile("VerbatimConnection.class", 3, "CLASS File", "01/12/96 09:49:10 AM")};
        ExplorerFile[] explorerFileArray12 = new ExplorerFile[]{this.newExplorerFile("Handler.class", 1, "CLASS File", "03/08/96 02:13:08 AM"), this.newExplorerFile("HttpPostBufferStream.class", 2, "CLASS File", "03/08/96 02:13:12 AM"), this.newExplorerFile("HttpURLConnection.class", 6, "CLASS File", "03/08/96 02:13:12 AM")};
        ExplorerFile[] explorerFileArray13 = new ExplorerFile[]{this.newExplorerDirectory("http", 0, "File Folder", "07/30/96 02:36:16 PM", explorerFileArray12), this.newExplorerDirectory("verbatim", 0, "File Folder", "07/30/96 02:36:16 PM", explorerFileArray11)};
        ExplorerFile[] explorerFileArray14 = new ExplorerFile[]{this.newExplorerFile("AuthenticationInfo.class", 3, "CLASS File", "03/08/96 02:13:16 AM"), this.newExplorerFile("HttpClient.class", 8, "CLASS File", "03/08/96 02:13:14 AM"), this.newExplorerFile("UnauthorizedHttpRequestException.class", 1, "CLASS File", "03/08/96 02:13:12 AM")};
        ExplorerFile[] explorerFileArray15 = new ExplorerFile[]{this.newExplorerDirectory("http", 0, "File Folder", "07/30/96 02:36:16 PM", explorerFileArray14), this.newExplorerDirectory("protocol", 0, "File Folder", "07/30/96 02:36:16 PM", explorerFileArray13), this.newExplorerFile("FormatException.class", 1, "CLASS File", "03/08/96 02:12:40 AM"), this.newExplorerFile("MessageHeader.class", 4, "CLASS File", "03/08/96 02:12:42 AM"), this.newExplorerFile("MeteredStream.class", 3, "CLASS File", "03/08/96 02:12:46 AM"), this.newExplorerFile("MimeEntry.class", 3, "CLASS File", "03/08/96 02:12:48 AM")};
        ExplorerFile[] explorerFileArray16 = new ExplorerFile[]{this.newExplorerFile("SmtpClient.class", 3, "CLASS File", "03/08/96 02:12:32 AM"), this.newExplorerFile("SmtpPrintStream.class", 2, "CLASS File", "03/08/96 02:12:32 AM"), this.newExplorerFile("SmtpProtocolException.class", 1, "CLASS File", "03/08/96 02:12:32 AM")};
        ExplorerFile[] explorerFileArray17 = new ExplorerFile[]{this.newExplorerDirectory("smtp", 0, "File Folder", "07/30/96 02:36:16 PM", explorerFileArray16), this.newExplorerDirectory("www", 0, "File Folder", "07/30/96 02:36:16 PM", explorerFileArray15), this.newExplorerFile("MulticastSocket.class", 2, "CLASS File", "03/08/96 01:58:30 AM"), this.newExplorerFile("NetworkClient.class", 2, "CLASS File", "03/08/96 02:12:02 AM"), this.newExplorerFile("NetworkServer.class", 4, "CLASS File", "03/08/96 02:12:06 AM"), this.newExplorerFile("ProgressData.class", 2, "CLASS File", "03/08/96 02:12:08 AM")};
        ExplorerFile[] explorerFileArray18 = new ExplorerFile[]{this.newExplorerDirectory("net", 0, "File Folder", "07/30/96 02:36:16 PM", explorerFileArray17), this.newExplorerDirectory("tools", 0, "File Folder", "07/30/96 02:36:10 PM", explorerFileArray10)};
        ExplorerFile[] explorerFileArray19 = new ExplorerFile[]{this.newExplorerFile("BitSet.class", 3, "CLASS File", "03/08/96 01:43:32 AM"), this.newExplorerFile("Date.class", 7, "CLASS File", "03/08/96 01:43:00 AM"), this.newExplorerFile("Dictionary.class", 1, "CLASS File", "03/08/96 01:42:52 AM"), this.newExplorerFile("EmptyStackException.class", 1, "CLASS File", "03/08/96 01:43:34 AM")};
        ExplorerFile[] explorerFileArray20 = new ExplorerFile[]{this.newExplorerFile("ContentHandler.class", 1, "CLASS File", "03/08/96 01:57:34 AM"), this.newExplorerFile("ContentHandlerFactory.class", 1, "CLASS File", "03/08/96 01:57:36 AM"), this.newExplorerFile("DatagramPacket.class", 1, "CLASS File", "03/08/96 01:58:24 AM"), this.newExplorerFile("DatagramSocket.class", 2, "CLASS File", "03/08/96 01:58:26 AM")};
        ExplorerFile[] explorerFileArray21 = new ExplorerFile[]{this.newExplorerDirectory("net", 0, "File Folder", "07/30/96 02:36:26 PM", explorerFileArray20), this.newExplorerDirectory("util", 0, "File Folder", "07/30/96 02:36:22 PM", explorerFileArray19)};
        ExplorerFile[] explorerFileArray22 = new ExplorerFile[]{this.newExplorerDirectory("java", 0, "File Folder", "07/30/96 02:36:20 PM", explorerFileArray21), this.newExplorerDirectory("sun", 0, "File Folder", "07/30/96 02:36:10 PM", explorerFileArray18), this.newExplorerFile("appletviewer.properties", 2, "PROPERTIES File", "05/03/96 04:45:06 AM"), this.newExplorerFile("classes.zip", 1483, "WinZip File", "05/31/96 01:20:00 AM"), this.newExplorerFile("javac.properties", 12, "PROPERTIES File", "05/03/96 03:35:22 AM"), this.newExplorerFile("javai.lib", 31, "LIB File", "05/28/96 12:18:42 AM")};
        ExplorerFile[] explorerFileArray23 = new ExplorerFile[]{this.newExplorerDirectory("Lib", 0, "File Folder", "07/30/96 02:36:10 PM", explorerFileArray22), this.newExplorerDirectory("Src", 0, "File Folder", "07/30/96 02:36:40 PM", Boolean.TRUE, explorerFileArray7), this.newExplorerFile("copyright", 3, "File", "05/03/96 05:03:54 AM"), this.newExplorerFile("index.html", 2, "Hypertext Doc", "05/03/96 05:03:54 AM", Boolean.TRUE), this.newExplorerFile("readme", 9, "File", "05/03/96 05:03:54 AM")};
        return explorerFileArray23;
    }
}

