/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example.howto.listEvent;

import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.grid.area.JKColumnArea;
import com.objectshare.grid.area.JKCompositeArea;
import com.objectshare.grid.area.JKRectangularArea;
import com.objectshare.grid.area.JKRowArea;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.example.JKExampleFrame;
import com.objectshare.grid.example.howto.JKTableListHowTo;
import com.objectshare.grid.list.JKSelectionEvent;
import com.objectshare.grid.list.JKSelectionListener;
import java.awt.Checkbox;

public class ListEvents
extends JKTableListHowTo
implements JKSelectionListener {
    protected Checkbox neverSelectCB;
    protected Checkbox alwaysSelectCB;

    public static void main(String[] stringArray) {
        ListEvents listEvents = new ListEvents();
        new JKExampleFrame(listEvents, "List Events", 560, 350);
    }

    protected void initTable() {
        super.initTable();
        this.initTableData(this.table);
        this.table.addJKSelectionListener(this);
    }

    protected void initControlPanel() {
        this.initEventMonitorControlPanel();
    }

    protected void initControls() {
        this.neverSelectCB = new Checkbox("Never select row 4");
        this.controls.add(this.neverSelectCB);
        this.alwaysSelectCB = new Checkbox("Always select column 2");
        this.controls.add(this.alwaysSelectCB);
        super.initControls();
    }

    public void jkSelecting(JKSelectionEvent jKSelectionEvent) {
        this.printEvent("    Selecting \n        old=" + this.selectionDescription(jKSelectionEvent.getOldSelection()) + "\n        new=" + this.selectionDescription(jKSelectionEvent.getNewSelection()));
        if (this.neverSelectCB.getState()) {
            jKSelectionEvent.setNewSelection(jKSelectionEvent.getNewSelection().subtract(JKTableArea.newForRow(4)));
        }
        if (this.alwaysSelectCB.getState()) {
            jKSelectionEvent.setNewSelection(jKSelectionEvent.getNewSelection().add(JKTableArea.newForColumn(2)));
        }
    }

    public void jkSelected(JKSelectionEvent jKSelectionEvent) {
        this.printEvent("Selected \n        old=" + this.selectionDescription(jKSelectionEvent.getOldSelection()) + "\n        new=" + this.selectionDescription(jKSelectionEvent.getNewSelection()));
    }

    public String selectionDescription(JKTableArea jKTableArea) {
        if (jKTableArea == JKTableArea.full) {
            return "full";
        }
        if (jKTableArea == JKTableArea.empty) {
            return "empty";
        }
        if (jKTableArea instanceof JKCompositeArea) {
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer(100);
            OSIEnumeration oSIEnumeration = jKTableArea.elements();
            while (oSIEnumeration.hasMoreElements()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.selectionDescription((JKTableArea)oSIEnumeration.nextElement()));
            }
            return stringBuffer.toString();
        }
        if (jKTableArea instanceof JKRowArea) {
            JKRowArea jKRowArea = (JKRowArea)jKTableArea;
            if (jKRowArea.height == 1) {
                return "row " + jKRowArea.y;
            }
            return "rows " + jKRowArea.y + "-" + (jKRowArea.y + jKRowArea.height - 1);
        }
        if (jKTableArea instanceof JKColumnArea) {
            JKColumnArea jKColumnArea = (JKColumnArea)jKTableArea;
            if (jKColumnArea.width == 1) {
                return "column " + jKColumnArea.x;
            }
            return "columns " + jKColumnArea.x + "-" + (jKColumnArea.x + jKColumnArea.width - 1);
        }
        if (jKTableArea instanceof JKRectangularArea) {
            JKRectangularArea jKRectangularArea = (JKRectangularArea)jKTableArea;
            if (jKRectangularArea.width == 1 && jKRectangularArea.height == 1) {
                return "cell " + jKRectangularArea.x + "," + jKRectangularArea.y;
            }
            return "cells " + jKRectangularArea.x + "," + jKRectangularArea.y + "-" + (jKRectangularArea.x + jKRectangularArea.width - 1) + "," + (jKRectangularArea.y + jKRectangularArea.height - 1);
        }
        return "unknown";
    }
}

