/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example.howto.multiThread;

import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.example.explorer.ExplorerDirectory;
import com.objectshare.grid.example.explorer.ExplorerFile;
import java.util.Random;

class BackgroundThread
extends Thread {
    protected JKModel model;
    protected long sleepTime;
    protected boolean go;
    protected Random randomGenerator;

    public BackgroundThread(JKModel jKModel, long l) {
        this.model = jKModel;
        this.sleepTime = l;
    }

    public void run() {
        this.go = true;
        this.randomGenerator = new Random();
        while (this.go) {
            try {
                int n = (int)(this.randomGenerator.nextFloat() * (float)this.model.getNumberOfRows() + 1.0f);
                this.modifyRowObject((ExplorerFile)this.model.getRow(n), this.randomGenerator.nextFloat());
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void requestStop() {
        this.go = false;
    }

    protected void modifyRowObject(ExplorerFile explorerFile, float f) {
        if (explorerFile == null) {
            return;
        }
        switch ((int)(f * 7.0f + 1.0f)) {
            case 1: {
                explorerFile.setFileName(BackgroundThread.reverseString(explorerFile.getFileName()));
                return;
            }
            case 2: {
                explorerFile.setFileSize(explorerFile.getFileSize() + 1);
                return;
            }
            case 3: {
                explorerFile.setFileType(BackgroundThread.reverseString(explorerFile.getFileType()));
                return;
            }
            case 4: {
                explorerFile.setModified(BackgroundThread.reverseString(explorerFile.getModified()));
                return;
            }
            case 5: {
                explorerFile.setArchived(new Boolean(explorerFile.getArchived() == false));
                return;
            }
            case 6: {
                if (!(explorerFile instanceof ExplorerDirectory)) break;
                this.addChildTo((ExplorerDirectory)explorerFile, f * 7.0f - 5.0f);
                return;
            }
            case 7: {
                if (!(explorerFile instanceof ExplorerDirectory)) break;
                this.removeChildFrom((ExplorerDirectory)explorerFile, f * 7.0f - 6.0f);
                return;
            }
        }
    }

    public void addChildTo(ExplorerDirectory explorerDirectory, float f) {
        if ((double)f < 0.5) {
            this.insertChildAt(explorerDirectory, f * 2.0f, ExplorerDirectory.getNewFile());
            return;
        }
        this.insertChildAt(explorerDirectory, f * 2.0f - 1.0f, ExplorerDirectory.getNewDirectory());
    }

    public void insertChildAt(ExplorerDirectory explorerDirectory, float f, ExplorerFile explorerFile) {
        ExplorerDirectory explorerDirectory2 = explorerDirectory;
        synchronized (explorerDirectory2) {
            explorerDirectory.insertFile((int)(f * (float)(explorerDirectory.getChildren().length + 1)), explorerFile);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeChildFrom(ExplorerDirectory explorerDirectory, float f) {
        ExplorerDirectory explorerDirectory2 = explorerDirectory;
        synchronized (explorerDirectory2) {
            if (explorerDirectory.getChildren().length == 0) {
                return;
            }
            int n = (int)(f * (float)explorerDirectory.getChildren().length);
            ExplorerFile explorerFile = explorerDirectory.getChildren()[n];
            if (explorerFile instanceof ExplorerDirectory) {
                ExplorerDirectory explorerDirectory3;
                ExplorerDirectory explorerDirectory4 = explorerDirectory3 = (ExplorerDirectory)explorerFile;
                synchronized (explorerDirectory4) {
                    if (explorerDirectory3.getChildren().length > 0) {
                        this.removeChildFrom(explorerDirectory3, f * (float)explorerDirectory.getChildren().length - (float)n);
                        return;
                    }
                }
            }
            explorerDirectory.removeFile(explorerFile);
            return;
        }
    }

    public static String reverseString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length() - 1;
        while (n >= 0) {
            stringBuffer.append(string.charAt(n));
            --n;
        }
        return stringBuffer.toString();
    }
}

