/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.view;

import com.objectshare.base.util.OSIIntEnumeration;
import com.objectshare.base.util.OSIIntToIntHashtable;
import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKModelChangedEvent;
import com.objectshare.grid.data.JKModelColsAddedEvent;
import com.objectshare.grid.data.JKModelColsChangedEvent;
import com.objectshare.grid.data.JKModelColsRemovedEvent;
import com.objectshare.grid.data.JKModelColsReorderEvent;
import com.objectshare.grid.data.JKModelRowsAddedEvent;
import com.objectshare.grid.data.JKModelRowsChangedEvent;
import com.objectshare.grid.data.JKModelRowsRemovedEvent;
import com.objectshare.grid.data.JKModelRowsReorderEvent;
import com.objectshare.grid.view.JKTableView;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class JKDimensionPolicy
implements Serializable {
    protected JKTableView owner;
    protected JKModel model;
    protected OSIIntToIntHashtable heights;
    protected OSIIntToIntHashtable heightFlags;
    protected Hashtable widthMap;
    protected Hashtable widthFlagMap;
    protected static final int AUTOSIZABLE = 1;
    protected static final int USERSIZABLE = 2;
    public static int defaultRowHeight = 16;
    public static int defaultColumnWidth = 25;

    JKDimensionPolicy() {
    }

    public JKDimensionPolicy(JKTableView jKTableView) {
        this.owner = jKTableView;
        this.updateModel(this.owner.getModel());
    }

    public void updateModel(JKModel jKModel) {
        this.model = jKModel;
        this.heights = this.newHeights();
        this.heightFlags = this.newHeightFlags();
        this.widthMap = new Hashtable();
        this.widthFlagMap = new Hashtable();
        if (this.model != null) {
            Enumeration enumeration = this.model.getRowTypes();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.widthMap.put(string, this.newWidths());
                this.widthFlagMap.put(string, this.newWidthFlags());
            }
            return;
        }
        String string = "java.lang.Object";
        this.widthMap.put(string, this.newWidths());
        this.widthFlagMap.put(string, this.newWidthFlags());
    }

    public JKDimensionPolicy copyForAutoSize() {
        JKDimensionPolicy jKDimensionPolicy = new JKDimensionPolicy();
        jKDimensionPolicy.model = this.model;
        jKDimensionPolicy.heights = JKDimensionPolicy.copyForAutoSize(this.heights, this.heightFlags, 1);
        jKDimensionPolicy.heightFlags = this.heightFlags;
        jKDimensionPolicy.widthMap = new Hashtable();
        jKDimensionPolicy.widthFlagMap = new Hashtable();
        Enumeration enumeration = this.widthMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            OSIIntToIntHashtable oSIIntToIntHashtable = (OSIIntToIntHashtable)this.widthMap.get(string);
            OSIIntToIntHashtable oSIIntToIntHashtable2 = (OSIIntToIntHashtable)this.widthFlagMap.get(string);
            jKDimensionPolicy.widthMap.put(string, JKDimensionPolicy.copyForAutoSize(oSIIntToIntHashtable, oSIIntToIntHashtable2, 1));
            jKDimensionPolicy.widthFlagMap.put(string, oSIIntToIntHashtable2);
        }
        return jKDimensionPolicy;
    }

    static OSIIntToIntHashtable copyForAutoSize(OSIIntToIntHashtable oSIIntToIntHashtable, OSIIntToIntHashtable oSIIntToIntHashtable2, int n) {
        OSIIntToIntHashtable oSIIntToIntHashtable3;
        if ((oSIIntToIntHashtable2.defaultValue & 1) == 1) {
            oSIIntToIntHashtable3 = new OSIIntToIntHashtable();
            oSIIntToIntHashtable3.defaultValue = n;
            OSIIntEnumeration oSIIntEnumeration = oSIIntToIntHashtable.keys();
            while (oSIIntEnumeration.hasMoreElements()) {
                int n2 = oSIIntEnumeration.nextElement();
                if ((oSIIntToIntHashtable2.get(n2) & 1) == 1) continue;
                oSIIntToIntHashtable3.put(n2, oSIIntToIntHashtable.get(n2));
            }
        } else {
            oSIIntToIntHashtable3 = (OSIIntToIntHashtable)oSIIntToIntHashtable.clone();
            OSIIntEnumeration oSIIntEnumeration = oSIIntToIntHashtable2.keys();
            while (oSIIntEnumeration.hasMoreElements()) {
                int n3 = oSIIntEnumeration.nextElement();
                if ((oSIIntToIntHashtable2.get(n3) & 1) != 1) continue;
                oSIIntToIntHashtable3.put(n3, n);
            }
        }
        return oSIIntToIntHashtable3;
    }

    public void copyFromAutoSize(JKDimensionPolicy jKDimensionPolicy) {
        if (jKDimensionPolicy.model != this.model) {
            throw new IllegalArgumentException();
        }
        OSIIntToIntHashtable oSIIntToIntHashtable = this.heights;
        this.heights = jKDimensionPolicy.heights;
        if (this.owner != null) {
            this.owner.rowHeightsChanged(oSIIntToIntHashtable, this.heights);
        }
        Enumeration enumeration = this.widthMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            OSIIntToIntHashtable oSIIntToIntHashtable2 = (OSIIntToIntHashtable)this.widthMap.get(string);
            OSIIntToIntHashtable oSIIntToIntHashtable3 = (OSIIntToIntHashtable)jKDimensionPolicy.widthMap.get(string);
            this.widthMap.put(string, oSIIntToIntHashtable3);
            if (this.owner == null) continue;
            this.owner.columnWidthsChanged(string, oSIIntToIntHashtable2, oSIIntToIntHashtable3);
        }
    }

    public int getRowNumber(int n) {
        int n2 = this.heights.count(0, n);
        while (this.heights.get(n2) < 1) {
            ++n2;
        }
        return n2;
    }

    public int getVirtualY(int n) {
        switch (n) {
            case -1: {
                return -this.heights.get(-1);
            }
            case 0: {
                return 0;
            }
            case 1: {
                return this.heights.get(0);
            }
        }
        if (n > 0) {
            return this.heights.sum(0, n);
        }
        return -this.heights.sum(n, -n);
    }

    public int getHeight(int n) {
        return this.heights.get(n);
    }

    public int getTotalHeight(int n, int n2) {
        return this.heights.sum(n, n2);
    }

    public OSIIntEnumeration getHeights(int n, int n2) {
        return this.heights.getAll(n, n2);
    }

    public int[] getHeightArray(int n, int n2) {
        return this.heights.getArray(n, n2);
    }

    public boolean areRowsAutoSizableByDefault() {
        return (this.heightFlags.defaultValue & 1) == 1;
    }

    public boolean areRowsUserSizableByDefault() {
        return (this.heightFlags.defaultValue & 2) == 2;
    }

    public boolean isRowAutoSizable(int n) {
        return (this.heightFlags.get(n) & 1) == 1;
    }

    public boolean isRowUserSizable(int n) {
        return (this.heightFlags.get(n) & 2) == 2;
    }

    public int setHeight(int n, int n2) {
        int n3;
        int n4 = n2 > 0 ? n2 : 0;
        if (n4 != (n3 = this.heights.put(n, n4)) && this.owner != null) {
            this.owner.rowHeightChanged(n, n3, n4);
        }
        return n3;
    }

    public void setHeights(int n, int[] nArray) {
        if (nArray == null) {
            return;
        }
        OSIIntToIntHashtable oSIIntToIntHashtable = (OSIIntToIntHashtable)this.heights.clone();
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3;
            int n4 = nArray[n2];
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 != (n3 = this.heights.put(n + n2, n4))) {
                bl = true;
            }
            ++n2;
        }
        if (bl && this.owner != null) {
            this.owner.rowHeightsChanged(oSIIntToIntHashtable, this.heights);
        }
    }

    public int getDefaultHeight() {
        return this.heights.defaultValue;
    }

    public int setDefaultHeight(int n) {
        int n2;
        int n3 = n > 0 ? n : 0;
        if (n3 != (n2 = this.heights.defaultValue) && this.owner != null) {
            OSIIntToIntHashtable oSIIntToIntHashtable = (OSIIntToIntHashtable)this.heights.clone();
            this.heights.defaultValue = n3;
            if (this.owner != null) {
                this.owner.rowHeightsChanged(oSIIntToIntHashtable, this.heights);
            }
        } else {
            this.heights.defaultValue = n3;
        }
        return n2;
    }

    public void setHeightToDefault(int n) {
        int n2 = this.heights.get(n);
        this.heights.setToDefault(n);
        int n3 = this.heights.get(n);
        if (n3 != n2 && this.owner != null) {
            this.owner.rowHeightChanged(n, n2, n3);
        }
    }

    public int defaultHeight() {
        return this.heights.defaultValue;
    }

    public void setRowAutoSizable(int n, boolean bl) {
        int n2 = this.heightFlags.get(n);
        n2 = bl ? (n2 |= 1) : (n2 -= n2 & 1);
        if (n2 != this.heightFlags.defaultValue) {
            this.heightFlags.put(n, n2);
        } else {
            this.heightFlags.setToDefault(n);
        }
        this.heightFlags.trim();
    }

    public void setRowUserSizable(int n, boolean bl) {
        int n2 = this.heightFlags.get(n);
        n2 = bl ? (n2 |= 2) : (n2 -= n2 & 2);
        if (n2 != this.heightFlags.defaultValue) {
            this.heightFlags.put(n, n2);
        } else {
            this.heightFlags.setToDefault(n);
        }
        this.heightFlags.trim();
    }

    public void setAllRowsAutoSizable(boolean bl) {
        this.heightFlags.defaultValue = bl ? (this.heightFlags.defaultValue |= 1) : (this.heightFlags.defaultValue -= this.heightFlags.defaultValue & 1);
        this.heightFlags.setToDefault();
        this.heightFlags.trim();
    }

    public void setAllRowsUserSizable(boolean bl) {
        this.heightFlags.defaultValue = bl ? (this.heightFlags.defaultValue |= 2) : (this.heightFlags.defaultValue -= this.heightFlags.defaultValue & 2);
        this.heightFlags.setToDefault();
        this.heightFlags.trim();
    }

    public void setAllUserSizableRowsAutoSizable() {
        if ((this.heightFlags.defaultValue & 2) == 2) {
            this.heightFlags.defaultValue |= 1;
        }
        OSIIntEnumeration oSIIntEnumeration = this.heightFlags.keys();
        while (oSIIntEnumeration.hasMoreElements()) {
            int n = oSIIntEnumeration.nextElement();
            int n2 = this.heightFlags.get(n);
            if ((n2 & 2) != 2 || (n2 & 1) == 1) continue;
            this.heightFlags.put(n, n2 | 1);
        }
        this.heightFlags.setToDefault();
        this.heightFlags.trim();
    }

    public int getColumnNumber(int n) {
        return this.getColumnNumber("java.lang.Object", n);
    }

    public int getColumnNumber(String string, int n) {
        OSIIntToIntHashtable oSIIntToIntHashtable = this.existingWidths(string);
        int n2 = oSIIntToIntHashtable.count(0, n);
        while (oSIIntToIntHashtable.get(n2) < 1) {
            ++n2;
        }
        return n2;
    }

    public int getColumnNumber(int n, int n2) {
        OSIIntToIntHashtable oSIIntToIntHashtable = this.existingWidths(n);
        int n3 = oSIIntToIntHashtable.count(0, n2);
        while (oSIIntToIntHashtable.get(n3) < 1) {
            ++n3;
        }
        return n3;
    }

    public int getVirtualX(int n) {
        return this.getVirtualX("java.lang.Object", n);
    }

    public int getVirtualX(String string, int n) {
        switch (n) {
            case -1: {
                return -this.existingWidths(string).get(-1);
            }
            case 0: {
                return 0;
            }
            case 1: {
                return this.existingWidths(string).get(0);
            }
        }
        if (n > 0) {
            return this.existingWidths(string).sum(0, n);
        }
        return -this.existingWidths(string).sum(n, -n);
    }

    public int getVirtualX(int n, int n2) {
        switch (n2) {
            case -1: {
                return -this.existingWidths(n).get(-1);
            }
            case 0: {
                return 0;
            }
            case 1: {
                return this.existingWidths(n).get(0);
            }
        }
        if (n2 > 0) {
            return this.existingWidths(n).sum(0, n2);
        }
        return -this.existingWidths(n).sum(n2, -n2);
    }

    public int getWidth(int n) {
        return this.getWidth("java.lang.Object", n);
    }

    public int getWidth(String string, int n) {
        return this.existingWidths(string).get(n);
    }

    public int getWidth(int n, int n2) {
        return this.existingWidths(n).get(n2);
    }

    public int getTotalWidth(int n, int n2) {
        return this.getTotalWidth("java.lang.Object", n, n2);
    }

    public int getTotalWidth(String string, int n, int n2) {
        return this.existingWidths(string).sum(n, n2);
    }

    public int getTotalWidth(int n, int n2, int n3) {
        return this.existingWidths(n).sum(n2, n3);
    }

    public OSIIntEnumeration getWidths(int n, int n2) {
        return this.getWidths("java.lang.Object", n, n2);
    }

    public OSIIntEnumeration getWidths(String string, int n, int n2) {
        return this.existingWidths(string).getAll(n, n2);
    }

    public OSIIntEnumeration getWidths(int n, int n2, int n3) {
        return this.existingWidths(n).getAll(n2, n3);
    }

    public int[] getWidthArray(int n, int n2) {
        return this.getWidthArray("java.lang.Object", n, n2);
    }

    public int[] getWidthArray(String string, int n, int n2) {
        return this.existingWidths(string).getArray(n, n2);
    }

    public int[] getWidthArray(int n, int n2, int n3) {
        return this.existingWidths(n).getArray(n2, n3);
    }

    public boolean areColumnsAutoSizableByDefault() {
        return this.areColumnsAutoSizableByDefault("java.lang.Object");
    }

    public boolean areColumnsUserSizableByDefault() {
        return this.areColumnsUserSizableByDefault("java.lang.Object");
    }

    public boolean areColumnsAutoSizableByDefault(String string) {
        return (this.existingWidthFlags((String)string).defaultValue & 1) == 1;
    }

    public boolean areColumnsUserSizableByDefault(String string) {
        return (this.existingWidthFlags((String)string).defaultValue & 2) == 2;
    }

    public boolean areColumnsAutoSizableByDefault(int n) {
        return (this.existingWidthFlags((int)n).defaultValue & 1) == 1;
    }

    public boolean areColumnsUserSizableByDefault(int n) {
        return (this.existingWidthFlags((int)n).defaultValue & 2) == 2;
    }

    public boolean isColumnAutoSizable(int n) {
        return this.isColumnAutoSizable("java.lang.Object", n);
    }

    public boolean isColumnUserSizable(int n) {
        return this.isColumnUserSizable("java.lang.Object", n);
    }

    public boolean isColumnAutoSizable(String string, int n) {
        return (this.existingWidthFlags(string).get(n) & 1) == 1;
    }

    public boolean isColumnUserSizable(String string, int n) {
        return (this.existingWidthFlags(string).get(n) & 2) == 2;
    }

    public boolean isColumnAutoSizable(int n, int n2) {
        return (this.existingWidthFlags(n).get(n2) & 1) == 1;
    }

    public boolean isColumnUserSizable(int n, int n2) {
        return (this.existingWidthFlags(n).get(n2) & 2) == 2;
    }

    public int setWidth(int n, int n2) {
        return this.setWidth("java.lang.Object", n, n2);
    }

    public int setWidth(String string, int n, int n2) {
        int n3;
        int n4 = n2 > 0 ? n2 : 0;
        if (n4 != (n3 = this.getWidths(string).put(n, n4)) && this.owner != null) {
            this.owner.columnWidthChanged(string, n, n3, n4);
        }
        return n3;
    }

    public int setWidth(int n, int n2, int n3) {
        return this.setWidth(this.model.getRowType(n), n2, n3);
    }

    public void setWidths(int n, int[] nArray) {
        this.setWidths("java.lang.Object", n, nArray);
    }

    public void setWidths(String string, int n, int[] nArray) {
        if (nArray == null) {
            return;
        }
        OSIIntToIntHashtable oSIIntToIntHashtable = this.getWidths(string);
        OSIIntToIntHashtable oSIIntToIntHashtable2 = (OSIIntToIntHashtable)oSIIntToIntHashtable.clone();
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3;
            int n4 = nArray[n2];
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 != (n3 = oSIIntToIntHashtable.put(n + n2, n4))) {
                bl = true;
            }
            ++n2;
        }
        if (bl && this.owner != null) {
            this.owner.columnWidthsChanged(string, oSIIntToIntHashtable2, oSIIntToIntHashtable);
        }
    }

    public void setWidths(int n, int n2, int[] nArray) {
        this.setWidths(this.model.getRowType(n), n2, nArray);
    }

    public boolean isFixedWidth(int n) {
        return this.isFixedWidth("java.lang.Object", n);
    }

    public boolean isFixedWidth(String string, int n) {
        return !this.isColumnAutoSizable(string, n) && !this.isColumnUserSizable(string, n);
    }

    public boolean isFixedWidth(int n, int n2) {
        return !this.isColumnAutoSizable(n, n2) && !this.isColumnUserSizable(n, n2);
    }

    public boolean setFixedWidth(int n, boolean bl) {
        return this.setFixedWidth("java.lang.Object", n, bl);
    }

    public boolean setFixedWidth(String string, int n, boolean bl) {
        boolean bl2 = this.isFixedWidth(string, n);
        this.setColumnAutoSizable(string, n, !bl);
        this.setColumnUserSizable(string, n, !bl);
        return bl2;
    }

    public boolean setFixedWidth(int n, int n2, boolean bl) {
        boolean bl2 = this.isFixedWidth(n, n2);
        this.setColumnAutoSizable(n, n2, !bl);
        this.setColumnUserSizable(n, n2, !bl);
        return bl2;
    }

    public int getDefaultWidth() {
        return this.getDefaultWidth("java.lang.Object");
    }

    public int getDefaultWidth(String string) {
        return this.existingWidths((String)string).defaultValue;
    }

    public int getDefaultWidth(int n) {
        return this.existingWidths((int)n).defaultValue;
    }

    public int setDefaultWidth(int n) {
        return this.setDefaultWidth("java.lang.Object", n);
    }

    public int setDefaultWidth(String string, int n) {
        int n2;
        OSIIntToIntHashtable oSIIntToIntHashtable = this.getWidths(string);
        int n3 = n > 0 ? n : 0;
        if (n3 != (n2 = oSIIntToIntHashtable.defaultValue) && this.owner != null) {
            OSIIntToIntHashtable oSIIntToIntHashtable2 = (OSIIntToIntHashtable)oSIIntToIntHashtable.clone();
            oSIIntToIntHashtable.defaultValue = n3;
            if (this.owner != null) {
                this.owner.columnWidthsChanged(string, oSIIntToIntHashtable2, oSIIntToIntHashtable);
            }
        } else {
            oSIIntToIntHashtable.defaultValue = n3;
        }
        return n2;
    }

    public int setDefaultWidth(int n, int n2) {
        return this.setDefaultWidth(this.model.getRowType(n), n2);
    }

    public void setWidthToDefault(int n) {
        this.setWidthToDefault("java.lang.Object", n);
    }

    public void setWidthToDefault(String string, int n) {
        OSIIntToIntHashtable oSIIntToIntHashtable = this.getWidths(string);
        int n2 = oSIIntToIntHashtable.get(n);
        oSIIntToIntHashtable.setToDefault(n);
        int n3 = oSIIntToIntHashtable.get(n);
        if (n3 != n2 && this.owner != null) {
            this.owner.columnWidthChanged(string, n, n2, n3);
        }
    }

    public void setWidthToDefault(int n, int n2) {
        this.setWidthToDefault(this.model.getRowType(n), n2);
    }

    public int defaultWidth() {
        return this.getDefaultWidth();
    }

    public void setColumnAutoSizable(int n, boolean bl) {
        this.setColumnAutoSizable("java.lang.Object", n, bl);
    }

    public void setColumnUserSizable(int n, boolean bl) {
        this.setColumnUserSizable("java.lang.Object", n, bl);
    }

    public void setColumnAutoSizable(String string, int n, boolean bl) {
        OSIIntToIntHashtable oSIIntToIntHashtable = this.getWidthFlags(string);
        int n2 = oSIIntToIntHashtable.get(n);
        n2 = bl ? (n2 |= 1) : (n2 -= n2 & 1);
        if (n2 != oSIIntToIntHashtable.defaultValue) {
            oSIIntToIntHashtable.put(n, n2);
        } else {
            oSIIntToIntHashtable.setToDefault(n);
        }
        oSIIntToIntHashtable.trim();
    }

    public void setColumnUserSizable(String string, int n, boolean bl) {
        OSIIntToIntHashtable oSIIntToIntHashtable = this.getWidthFlags(string);
        int n2 = oSIIntToIntHashtable.get(n);
        n2 = bl ? (n2 |= 2) : (n2 -= n2 & 2);
        if (n2 != oSIIntToIntHashtable.defaultValue) {
            oSIIntToIntHashtable.put(n, n2);
        } else {
            oSIIntToIntHashtable.setToDefault(n);
        }
        oSIIntToIntHashtable.trim();
    }

    public void setColumnAutoSizable(int n, int n2, boolean bl) {
        this.setColumnAutoSizable(this.model != null ? this.model.getRowType(n) : "java.lang.Object", n2, bl);
    }

    public void setColumnUserSizable(int n, int n2, boolean bl) {
        this.setColumnUserSizable(this.model != null ? this.model.getRowType(n) : "java.lang.Object", n2, bl);
    }

    public void setAllColumnsAutoSizable(int n, boolean bl) {
        this.setAllColumnsAutoSizable("java.lang.Object", n, bl);
    }

    public void setAllColumnsUserSizable(int n, boolean bl) {
        this.setAllColumnsUserSizable("java.lang.Object", n, bl);
    }

    public void setAllColumnsAutoSizable(String string, int n, boolean bl) {
        OSIIntToIntHashtable oSIIntToIntHashtable = this.getWidthFlags(string);
        oSIIntToIntHashtable.defaultValue = bl ? (oSIIntToIntHashtable.defaultValue |= 1) : (oSIIntToIntHashtable.defaultValue -= oSIIntToIntHashtable.defaultValue & 1);
        oSIIntToIntHashtable.setToDefault();
        oSIIntToIntHashtable.trim();
    }

    public void setAllColumnsUserSizable(String string, int n, boolean bl) {
        OSIIntToIntHashtable oSIIntToIntHashtable = this.getWidthFlags(string);
        oSIIntToIntHashtable.defaultValue = bl ? (oSIIntToIntHashtable.defaultValue |= 2) : (oSIIntToIntHashtable.defaultValue -= oSIIntToIntHashtable.defaultValue & 2);
        oSIIntToIntHashtable.setToDefault();
        oSIIntToIntHashtable.trim();
    }

    public void setAllColumnsAutoSizable(int n, int n2, boolean bl) {
        this.setAllColumnsAutoSizable(this.model != null ? this.model.getRowType(n) : "java.lang.Object", n2, bl);
    }

    public void setAllColumnsUserSizable(int n, int n2, boolean bl) {
        this.setAllColumnsUserSizable(this.model != null ? this.model.getRowType(n) : "java.lang.Object", n2, bl);
    }

    public void setAllUserSizableColumnsAutoSizable() {
        Enumeration enumeration = this.widthMap.keys();
        while (enumeration.hasMoreElements()) {
            this.setAllUserSizableColumnsAutoSizable((String)enumeration.nextElement());
        }
    }

    public void setAllUserSizableColumnsAutoSizable(String string) {
        OSIIntToIntHashtable oSIIntToIntHashtable = (OSIIntToIntHashtable)this.widthFlagMap.get(string);
        if ((oSIIntToIntHashtable.defaultValue & 2) == 2) {
            oSIIntToIntHashtable.defaultValue |= 1;
        }
        OSIIntEnumeration oSIIntEnumeration = oSIIntToIntHashtable.keys();
        while (oSIIntEnumeration.hasMoreElements()) {
            int n = oSIIntEnumeration.nextElement();
            int n2 = oSIIntToIntHashtable.get(n);
            if ((n2 & 2) != 2 || (n2 & 1) == 1) continue;
            oSIIntToIntHashtable.put(n, n2 | 1);
        }
        oSIIntToIntHashtable.setToDefault();
        oSIIntToIntHashtable.trim();
    }

    public void setAllUserSizableColumnsAutoSizable(int n) {
        this.setAllUserSizableColumnsAutoSizable(this.model != null ? this.model.getRowType(n) : "java.lang.Object");
    }

    public synchronized void modelChanged(JKModelChangedEvent jKModelChangedEvent) {
    }

    public synchronized void modelRowsChanged(JKModelRowsChangedEvent jKModelRowsChangedEvent) {
    }

    public synchronized void modelRowsAdded(JKModelRowsAddedEvent jKModelRowsAddedEvent) {
        this.heights.insertAll(jKModelRowsAddedEvent.getFirst(), jKModelRowsAddedEvent.getSize());
    }

    public synchronized void modelRowsRemoved(JKModelRowsRemovedEvent jKModelRowsRemovedEvent) {
        this.heights.removeAll(jKModelRowsRemovedEvent.getFirst(), jKModelRowsRemovedEvent.getSize());
    }

    public synchronized void modelRowsReordered(JKModelRowsReorderEvent jKModelRowsReorderEvent) {
        this.heights.reorderAll(jKModelRowsReorderEvent.getFirst(), jKModelRowsReorderEvent.getReorderMap());
    }

    public synchronized void modelColumnsChanged(JKModelColsChangedEvent jKModelColsChangedEvent) {
    }

    public synchronized void modelColumnsAdded(JKModelColsAddedEvent jKModelColsAddedEvent) {
        this.getWidths(jKModelColsAddedEvent.getRowType()).insertAll(jKModelColsAddedEvent.getFirst(), jKModelColsAddedEvent.getSize());
        this.getWidthFlags(jKModelColsAddedEvent.getRowType()).insertAll(jKModelColsAddedEvent.getFirst(), jKModelColsAddedEvent.getSize());
    }

    public synchronized void modelColumnsRemoved(JKModelColsRemovedEvent jKModelColsRemovedEvent) {
        this.existingWidths(jKModelColsRemovedEvent.getRowType()).removeAll(jKModelColsRemovedEvent.getFirst(), jKModelColsRemovedEvent.getSize());
        this.existingWidthFlags(jKModelColsRemovedEvent.getRowType()).removeAll(jKModelColsRemovedEvent.getFirst(), jKModelColsRemovedEvent.getSize());
    }

    public synchronized void modelColumnsReordered(JKModelColsReorderEvent jKModelColsReorderEvent) {
        this.existingWidths(jKModelColsReorderEvent.getRowType()).reorderAll(jKModelColsReorderEvent.getFirst(), jKModelColsReorderEvent.getReorderMap());
        this.existingWidthFlags(jKModelColsReorderEvent.getRowType()).reorderAll(jKModelColsReorderEvent.getFirst(), jKModelColsReorderEvent.getReorderMap());
    }

    protected OSIIntToIntHashtable newHeights() {
        OSIIntToIntHashtable oSIIntToIntHashtable = new OSIIntToIntHashtable();
        oSIIntToIntHashtable.defaultValue = defaultRowHeight;
        return oSIIntToIntHashtable;
    }

    protected OSIIntToIntHashtable newHeightFlags() {
        OSIIntToIntHashtable oSIIntToIntHashtable = new OSIIntToIntHashtable();
        oSIIntToIntHashtable.defaultValue = 3;
        return oSIIntToIntHashtable;
    }

    protected OSIIntToIntHashtable newWidths() {
        OSIIntToIntHashtable oSIIntToIntHashtable = new OSIIntToIntHashtable();
        oSIIntToIntHashtable.defaultValue = defaultColumnWidth;
        return oSIIntToIntHashtable;
    }

    protected OSIIntToIntHashtable newWidthFlags() {
        OSIIntToIntHashtable oSIIntToIntHashtable = new OSIIntToIntHashtable();
        oSIIntToIntHashtable.defaultValue = 3;
        return oSIIntToIntHashtable;
    }

    protected OSIIntToIntHashtable existingWidths(String string) {
        OSIIntToIntHashtable oSIIntToIntHashtable = (OSIIntToIntHashtable)this.widthMap.get(string);
        if (oSIIntToIntHashtable != null) {
            return oSIIntToIntHashtable;
        }
        return this.newWidths();
    }

    protected OSIIntToIntHashtable existingWidthFlags(String string) {
        OSIIntToIntHashtable oSIIntToIntHashtable = (OSIIntToIntHashtable)this.widthFlagMap.get(string);
        if (oSIIntToIntHashtable != null) {
            return oSIIntToIntHashtable;
        }
        return this.newWidthFlags();
    }

    protected OSIIntToIntHashtable existingWidths(int n) {
        return this.existingWidths(this.model != null ? this.model.getRowType(n) : "java.lang.Object");
    }

    protected OSIIntToIntHashtable existingWidthFlags(int n) {
        return this.existingWidthFlags(this.model != null ? this.model.getRowType(n) : "java.lang.Object");
    }

    protected OSIIntToIntHashtable getWidths(String string) {
        OSIIntToIntHashtable oSIIntToIntHashtable = (OSIIntToIntHashtable)this.widthMap.get(string);
        if (oSIIntToIntHashtable != null) {
            return oSIIntToIntHashtable;
        }
        oSIIntToIntHashtable = this.newWidths();
        this.widthMap.put(string, oSIIntToIntHashtable);
        return oSIIntToIntHashtable;
    }

    protected OSIIntToIntHashtable getWidthFlags(String string) {
        OSIIntToIntHashtable oSIIntToIntHashtable = (OSIIntToIntHashtable)this.widthFlagMap.get(string);
        if (oSIIntToIntHashtable != null) {
            return oSIIntToIntHashtable;
        }
        oSIIntToIntHashtable = this.newWidthFlags();
        this.widthFlagMap.put(string, oSIIntToIntHashtable);
        return oSIIntToIntHashtable;
    }
}

