/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.view;

import com.objectshare.grid.draw.JKDrawingContext;
import com.objectshare.grid.draw.JKDrawnObject;
import com.objectshare.grid.draw.JKDrawnString;
import com.objectshare.grid.draw.JKHierDrawnObject;
import com.objectshare.grid.view.JKTableView;
import com.objectshare.grid.view.JKTableViewAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.util.StringTokenizer;

public class JKDrawViewEvent
extends JKDrawingContext {
    public JKTableView owner;
    public JKTableViewAdapter adapter;
    public Graphics graphics;
    public Rectangle cellBox;
    public int dataX;
    public int dataY;
    public JKDrawnObject cellData;
    protected static Image offscreenImage;
    protected static int offscreenImageWidth;
    protected static int offscreenImageHeight;
    protected static Graphics offscreenGraphics;

    public JKDrawViewEvent(JKTableView jKTableView, Graphics graphics, int n, int n2) {
        super(jKTableView.getDisplayPolicy().existingCellDrawingContext(n, n2));
        this.graphics = graphics;
        this.dataY = n;
        this.dataX = n2;
        this.owner = jKTableView;
        this.source = jKTableView;
    }

    public JKDrawViewEvent(JKDrawingContext jKDrawingContext, JKTableViewAdapter jKTableViewAdapter, Graphics graphics) {
        this(jKDrawingContext, jKTableViewAdapter.owner, graphics);
        this.adapter = jKTableViewAdapter;
    }

    public JKDrawViewEvent(JKDrawingContext jKDrawingContext, JKTableView jKTableView, Graphics graphics) {
        super(jKDrawingContext != null ? jKDrawingContext : new JKDrawingContext());
        this.owner = jKTableView;
        this.graphics = graphics;
        this.source = this.owner;
    }

    public boolean isSelected() {
        return this.isSelected(this.dataX, this.dataY);
    }

    public boolean isSelected(int n, int n2) {
        return false;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public Rectangle getBounds() {
        return this.cellBox;
    }

    public int getColumn() {
        return this.dataX;
    }

    public int getColumnNumber() {
        return this.dataX;
    }

    public int getRow() {
        return this.dataY;
    }

    public int getRowNumber() {
        return this.dataY;
    }

    public JKDrawnObject getCellData() {
        return this.cellData;
    }

    public void setCellData(JKDrawnObject jKDrawnObject) {
        this.cellData = jKDrawnObject;
    }

    public void predraw() {
        this.cellData = JKDrawnString.newFor(this.owner, this.owner.getModel().get(this.dataY, this.dataX));
        if (this.dataX == 1 && this.dataY > 0) {
            this.cellData = JKHierDrawnObject.newFor(this.owner.getModel().getRowAdapter(this.dataY), this.cellData);
        }
        this.cellData.jkPreDraw(this);
    }

    public void draw() {
        this.predraw();
        Rectangle rectangle = this.getContentRect(this.cellBox);
        if (this.isSelected()) {
            this.getSelectionDrawingPolicy().drawCell(this, rectangle);
        } else {
            this.getDrawingPolicy().drawCell(this, rectangle);
        }
        this.drawBorder(this.graphics, this.cellBox, this.getBorderColor());
        this.reset();
    }

    public Rectangle getContentRect(Rectangle rectangle) {
        this.borderInsets();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = n + rectangle.width - 1;
        int n4 = n2 + rectangle.height - 1;
        return new Rectangle(n, n2, n3 - n + 1, n4 - n2 + 1);
    }

    public void drawBorder(Graphics graphics, Rectangle rectangle, Color color) {
        Insets insets = this.borderInsets();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = n + rectangle.width - 1;
        int n4 = n2 + rectangle.height - 1;
        graphics.setColor(color);
        if (insets.left > 0) {
            graphics.drawLine(n, n2, n, n4);
            n += insets.left;
        }
        if (insets.top > 0) {
            graphics.drawLine(n, n2, n3, n2);
            n2 += insets.top;
        }
        if (insets.right > 0) {
            graphics.drawLine(n3, n2, n3, n4);
            n3 -= insets.right;
        }
        if (insets.bottom > 0) {
            graphics.drawLine(n, n4, n3, n4);
            n4 -= insets.bottom;
        }
    }

    public Rectangle backgroundFrame() {
        return this.backgroundFrame(this.cellBox);
    }

    public Rectangle backgroundFrame(Rectangle rectangle) {
        Insets insets = this.borderInsets();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = n + rectangle.width - 1;
        int n4 = n2 + rectangle.height - 1;
        if (insets.left > 0) {
            n += insets.left;
        }
        if (insets.top > 0) {
            n2 += insets.top;
        }
        if (insets.right > 0) {
            n3 -= insets.right;
        }
        if (insets.bottom > 0) {
            n4 -= insets.bottom;
        }
        return new Rectangle(n, n2, n3 - n + 1, n4 - n2 + 1);
    }

    public void drawString(String string, Rectangle rectangle) {
        JKDrawViewEvent.drawString(string, rectangle, this.graphics, null, this.font(), this.foreColor(), null, this.horizontalJustification(), this.verticalJustification());
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized void drawString(String var0, Rectangle var1_1, Graphics var2_2, Component var3_3, Font var4_4, Color var5_5, Color var6_6, int var7_7, int var8_8) {
        if (var6_6 != null && var3_3 != null) {
            JKDrawViewEvent.initOffscreen(var3_3, var1_1.width, var1_1.height);
            var9_9 = JKDrawViewEvent.offscreenGraphics;
            var9_9.setColor(var6_6);
            var9_9.fillRect(0, 0, var1_1.width, var1_1.height);
        } else {
            var9_9 = var2_2.create(var1_1.x, var1_1.y, var1_1.width, var1_1.height);
            if (var6_6 != null) {
                var9_9.setColor(var6_6);
                var9_9.fillRect(0, 0, var1_1.width, var1_1.height);
            }
        }
        var9_9.setFont(var4_4);
        var9_9.setColor(var5_5);
        var10_10 = var9_9.getFontMetrics(var4_4);
        var11_11 = 0;
        var12_12 = var10_10.getAscent() + var10_10.getLeading();
        var13_13 = var10_10.getHeight();
        var14_14 = new StringTokenizer(var0, "\n");
        var15_15 = var14_14.countTokens();
        var15_15 = var15_15 > 1 ? var15_15 * var13_13 : var13_13;
        switch (var8_8) {
            case 3: {
                var12_12 += var1_1.height - var15_15;
                ** GOTO lbl40
            }
            case 2: {
                var12_12 += (var1_1.height - var15_15) / 2;
                ** GOTO lbl40
            }
            default: {
                if (var14_14.hasMoreTokens()) ** continue;
            }
        }
        while (true) lbl-1000:
        // 2 sources

        {
            var16_16 = var14_14.nextToken();
            switch (var7_7) {
                case 3: {
                    var11_11 = var1_1.width - var10_10.stringWidth((String)var16_16);
                    break;
                }
                case 2: {
                    var11_11 = (var1_1.width - var10_10.stringWidth((String)var16_16)) / 2;
                    break;
                }
            }
            var9_9.drawString((String)var16_16, var11_11, var12_12);
            var12_12 += var13_13;
lbl40:
            // 3 sources

            if (var14_14.hasMoreTokens()) ** GOTO lbl-1000
            break;
        }
        if (var9_9 == JKDrawViewEvent.offscreenGraphics) {
            var16_16 = var3_3.createImage(new FilteredImageSource(JKDrawViewEvent.offscreenImage.getSource(), new CropImageFilter(0, 0, var1_1.width, var1_1.height)));
            JKDrawViewEvent.waitForImage(var3_3, (Image)var16_16);
            var2_2.drawImage((Image)var16_16, var1_1.x, var1_1.y, var3_3);
            var16_16.flush();
            return;
        }
        var9_9.dispose();
    }

    public Dimension extent() {
        this.cellData = JKDrawnString.newFor(this.owner, this.owner.data.get(this.dataY, this.dataX));
        if (this.dataX == 1 && this.dataY > 0) {
            this.cellData = JKHierDrawnObject.newFor(this.owner.getModel().getRowAdapter(this.dataY), this.cellData);
        }
        Dimension dimension = this.getDrawingPolicy().preferredSize(this);
        Insets insets = this.borderInsets();
        return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
    }

    public Dimension preferredSize() {
        return this.preferredSize(this.owner.data.get(this.dataY, this.dataX));
    }

    public Dimension preferredSize(Object object) {
        this.cellData = JKDrawnString.newFor(this.owner, object);
        if (this.dataX == 1 && this.dataY > 0) {
            this.cellData = JKHierDrawnObject.newFor(this.owner.data.getRowAdapter(this.dataY), this.cellData);
        }
        Dimension dimension = this.getDrawingPolicy().preferredSize(this);
        Insets insets = this.borderInsets();
        dimension = new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        this.cellBox = new Rectangle(dimension);
        this.owner.triggerCellExtent(this);
        if (this.cellBox != null) {
            dimension = new Dimension(this.cellBox.width, this.cellBox.height);
        }
        return dimension;
    }

    public Dimension stringExtent(String string) {
        return JKDrawViewEvent.stringExtent(this.graphics, string, this.font());
    }

    public static Dimension stringExtent(Graphics graphics, String string, Font font) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = 0;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            n3 = Math.max(n3, fontMetrics.stringWidth(stringTokenizer.nextToken()));
            n2 += n;
        }
        return new Dimension(n3, n2);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.dataX + "," + this.dataY + "]";
    }

    protected static void initOffscreen(Component component, int n, int n2) {
        if (offscreenImage == null || n > offscreenImageWidth || n2 > offscreenImageHeight) {
            if (offscreenImage != null) {
                offscreenImage.flush();
            }
            offscreenImageWidth = n > offscreenImageWidth ? n : offscreenImageWidth;
            offscreenImageHeight = n2 > offscreenImageHeight ? n2 : offscreenImageHeight;
            offscreenImage = component.createImage(offscreenImageWidth, offscreenImageHeight);
            JKDrawViewEvent.waitForImage(component, offscreenImage);
            offscreenGraphics = offscreenImage.getGraphics();
        }
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public boolean setDefaultForeColor(Color color) {
        this.setForeColor(color);
        return true;
    }

    public boolean setDefaultBackColor(Color color) {
        this.setBackColor(color);
        return true;
    }

    public boolean setDefaultBorderColor(Color color) {
        this.setBorderColor(color);
        return true;
    }

    public boolean setDefaultFont(Font font) {
        this.setFont(font);
        return true;
    }

    public boolean setDefaultHorizontalJustification(int n) {
        this.setHorizontalJustification(n);
        return true;
    }

    public boolean setDefaultVerticalJustification(int n) {
        this.setVerticalJustification(n);
        return true;
    }

    public boolean setDefaultBorderInset(Insets insets) {
        this.setBorderInsets(insets);
        return true;
    }

    public boolean setDefaultContentInset(Insets insets) {
        this.setContentInsets(insets);
        return true;
    }
}

