/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.view;

import com.objectshare.base.draw.OSIBorderPolicy;
import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntToIntHashtable;
import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKModelChangedEvent;
import com.objectshare.grid.data.JKModelColsAddedEvent;
import com.objectshare.grid.data.JKModelColsChangedEvent;
import com.objectshare.grid.data.JKModelColsRemovedEvent;
import com.objectshare.grid.data.JKModelColsReorderEvent;
import com.objectshare.grid.data.JKModelRowsAddedEvent;
import com.objectshare.grid.data.JKModelRowsChangedEvent;
import com.objectshare.grid.data.JKModelRowsRemovedEvent;
import com.objectshare.grid.data.JKModelRowsReorderEvent;
import com.objectshare.grid.view.JKDimensionPolicy;
import com.objectshare.grid.view.JKTableView;
import com.objectshare.grid.view.JKTableViewAdapter;
import com.objectshare.grid.view.OSIScrollbar;
import com.objectshare.java.osi.OSIEventTable;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;

public class JKTableCoordinator
implements AdjustmentListener,
Serializable {
    public JKTableView owner;
    public JKTableViewAdapter[][] adapters;
    public OSIScrollbar[] horzScrollbars;
    public OSIScrollbar[] vertScrollbars;
    protected OSIBorderPolicy border = OSIBorderPolicy.LEFT_TOP;

    public JKTableCoordinator(JKTableView jKTableView) {
        this.owner = jKTableView;
        this.updateModel(this.owner.getModel());
    }

    public void updateModel(JKModel jKModel) {
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n = jKDimensionPolicy.getWidth(0);
        int n2 = jKDimensionPolicy.getHeight(0);
        int n3 = jKModel != null ? jKDimensionPolicy.getTotalWidth(1, jKModel.getNumberOfColumns()) : 0;
        int n4 = jKModel != null ? jKDimensionPolicy.getTotalHeight(1, jKModel.getNumberOfRows()) : 0;
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        Rectangle rectangle2 = new Rectangle(n, 0, n3, n2);
        Rectangle rectangle3 = new Rectangle(0, n2, n, n4);
        Rectangle rectangle4 = new Rectangle(n, n2, n3, n4);
        if (this.adapters == null) {
            this.adapters = new JKTableViewAdapter[2][2];
            this.adapters[0][0] = this.owner.newAdapter(0, 0, rectangle, rectangle);
            this.adapters[0][0].setBorderPolicy(OSIBorderPolicy.NONE);
            this.adapters[1][0] = this.owner.newAdapter(1, 0, rectangle2, rectangle2);
            this.adapters[1][0].setBorderPolicy(OSIBorderPolicy.RIGHT);
            this.adapters[0][1] = this.owner.newAdapter(0, 1, rectangle3, rectangle3);
            this.adapters[0][1].setBorderPolicy(OSIBorderPolicy.BOTTOM);
            this.adapters[1][1] = this.owner.newAdapter(1, 1, rectangle4, rectangle4);
            this.adapters[1][1].setBorderPolicy(OSIBorderPolicy.RIGHT_BOTTOM);
        } else {
            this.setNumberOfAdapterRows(2);
            this.setNumberOfAdapterColumns(2);
            this.adapters[0][0].setVirtualBounds(rectangle);
            this.adapters[0][0].setScreenBounds(rectangle);
            this.adapters[1][0].setVirtualBounds(rectangle2);
            this.adapters[1][0].setScreenBounds(rectangle2);
            this.adapters[0][1].setVirtualBounds(rectangle3);
            this.adapters[0][1].setScreenBounds(rectangle3);
            this.adapters[1][1].setVirtualBounds(rectangle4);
            this.adapters[1][1].setScreenBounds(rectangle4);
        }
        OSIScrollbar oSIScrollbar = new OSIScrollbar(0);
        oSIScrollbar.setLineIncrement(3);
        oSIScrollbar.setPageIncrement(50);
        this.setHorizontalScrollbars(2);
        this.setHorizontalScrollbar(0, null);
        this.setHorizontalScrollbar(1, oSIScrollbar);
        oSIScrollbar = new OSIScrollbar(1);
        oSIScrollbar.setLineIncrement(3);
        oSIScrollbar.setPageIncrement(50);
        this.setVerticalScrollbars(2);
        this.setVerticalScrollbar(0, null);
        this.setVerticalScrollbar(1, oSIScrollbar);
    }

    public final OSIBorderPolicy getBorderPolicy() {
        return this.getBorder();
    }

    public final OSIBorderPolicy getBorder() {
        return this.border;
    }

    public void setBorderPolicy(OSIBorderPolicy oSIBorderPolicy) {
        this.setBorder(oSIBorderPolicy);
    }

    public void setBorder(OSIBorderPolicy oSIBorderPolicy) {
        this.border = oSIBorderPolicy;
    }

    public final JKTableViewAdapter getTopLeftHeaderAdapter() {
        return this.adapters[0][0];
    }

    public final JKTableViewAdapter getColumnHeaderAdapter() {
        return this.adapters[1][0];
    }

    public final JKTableViewAdapter getRowHeaderAdapter() {
        return this.adapters[0][0];
    }

    public final JKTableViewAdapter getCellAdapter() {
        return this.adapters[1][1];
    }

    public final int getNumberOfAdapterRows() {
        return this.adapters[0].length;
    }

    public void setNumberOfAdapterRows(int n) {
        if (n == this.getNumberOfAdapterRows()) {
            return;
        }
        int n2 = 0;
        while (n2 < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n2];
            JKTableViewAdapter[] jKTableViewAdapterArray2 = new JKTableViewAdapter[n];
            int n3 = jKTableViewAdapterArray.length - 1;
            while (n3 >= n) {
                jKTableViewAdapterArray[n3].releaseDisplaySystem();
                --n3;
            }
            System.arraycopy(jKTableViewAdapterArray, 0, jKTableViewAdapterArray2, 0, jKTableViewAdapterArray.length < n ? jKTableViewAdapterArray.length : n);
            int n4 = jKTableViewAdapterArray.length;
            while (n4 < n) {
                Rectangle rectangle = jKTableViewAdapterArray2[n4 - 1].getVirtualBounds();
                Rectangle rectangle2 = jKTableViewAdapterArray2[n4 - 1].getScreenBounds();
                rectangle = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, 0);
                rectangle2 = new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height, rectangle2.width, 0);
                jKTableViewAdapterArray2[n4] = this.owner.newAdapter(n2, n4, rectangle, rectangle2);
                ++n4;
            }
            this.adapters[n2] = jKTableViewAdapterArray2;
            ++n2;
        }
        this.setVerticalScrollbars(n);
    }

    public final int getNumberOfAdapterColumns() {
        return this.adapters.length;
    }

    public void setNumberOfAdapterColumns(int n) {
        if (n == this.getNumberOfAdapterColumns()) {
            return;
        }
        JKTableViewAdapter[][] jKTableViewAdapterArray = new JKTableViewAdapter[n][];
        int n2 = this.adapters.length - 1;
        while (n2 >= n) {
            JKTableViewAdapter[] jKTableViewAdapterArray2 = this.adapters[n2];
            int n3 = 0;
            while (n3 < jKTableViewAdapterArray2.length) {
                jKTableViewAdapterArray2[n3].releaseDisplaySystem();
                ++n3;
            }
            --n2;
        }
        System.arraycopy(this.adapters, 0, jKTableViewAdapterArray, 0, this.adapters.length < n ? this.adapters.length : n);
        int n4 = this.adapters.length;
        while (n4 < n) {
            JKTableViewAdapter[] jKTableViewAdapterArray3 = this.adapters[n4 - 1];
            JKTableViewAdapter[] jKTableViewAdapterArray4 = new JKTableViewAdapter[jKTableViewAdapterArray3.length];
            int n5 = 0;
            while (n5 < jKTableViewAdapterArray3.length) {
                Rectangle rectangle = jKTableViewAdapterArray3[n5].getVirtualBounds();
                Rectangle rectangle2 = jKTableViewAdapterArray3[n5].getScreenBounds();
                rectangle = new Rectangle(rectangle.x + rectangle.width, rectangle.y, 0, rectangle.height);
                rectangle2 = new Rectangle(rectangle2.x + rectangle2.width, rectangle2.y, 0, rectangle2.height);
                jKTableViewAdapterArray4[n5] = this.owner.newAdapter(n4, n5, rectangle, rectangle2);
                ++n5;
            }
            jKTableViewAdapterArray[n4] = jKTableViewAdapterArray4;
            ++n4;
        }
        this.adapters = jKTableViewAdapterArray;
        this.setHorizontalScrollbars(n);
    }

    public final OSIEnumeration getAdapters() {
        return OSIEnumeration.newFor2DArray((Object[][])this.adapters);
    }

    public final JKTableViewAdapter getAdapter(int n, int n2) {
        return this.adapters[n][n2];
    }

    public final JKTableViewAdapter getAdapterForScreen(int n, int n2) {
        int n3 = 0;
        while (n3 < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n3];
            int n4 = 0;
            while (n4 < jKTableViewAdapterArray.length) {
                if (jKTableViewAdapterArray[n4].getScreenBounds().inside(n, n2)) {
                    return jKTableViewAdapterArray[n4];
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public final JKTableViewAdapter getAdapterForVirtual(int n, int n2) {
        int n3 = 0;
        while (n3 < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n3];
            int n4 = 0;
            while (n4 < jKTableViewAdapterArray.length) {
                if (jKTableViewAdapterArray[n4].getVirtualBounds().inside(n, n2)) {
                    return jKTableViewAdapterArray[n4];
                }
                ++n4;
            }
            ++n3;
        }
        return null;
    }

    public final JKTableViewAdapter getAdapterForCell(int n, int n2) {
        return this.getAdapterForVirtual(this.owner.getDimensions().getVirtualX(n, n2), this.owner.getDimensions().getVirtualY(n));
    }

    public final JKTableViewAdapter getAdapterForRow(int n) {
        int n2 = this.owner.getDimensions().getVirtualY(n);
        int n3 = 0;
        JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n3];
        int n4 = 0;
        while (n4 < jKTableViewAdapterArray.length) {
            JKTableViewAdapter jKTableViewAdapter = jKTableViewAdapterArray[n4];
            if (n2 >= jKTableViewAdapter.getVirtualBounds().y && n2 < jKTableViewAdapter.getVirtualBounds().y + jKTableViewAdapter.getVirtualBounds().height) {
                return jKTableViewAdapter;
            }
            ++n4;
        }
        return null;
    }

    public final JKTableViewAdapter getAdapterForColumn(int n) {
        return this.getAdapterForColumn("java.lang.Object", n);
    }

    public final JKTableViewAdapter getAdapterForColumn(int n, int n2) {
        return this.getAdapterForColumn(this.owner.getModel().getRowType(n), n2);
    }

    public final JKTableViewAdapter getAdapterForColumn(String string, int n) {
        int n2 = this.owner.getDimensions().getVirtualX(string, n);
        int n3 = 0;
        while (n3 < this.adapters.length) {
            JKTableViewAdapter jKTableViewAdapter = this.adapters[n3][0];
            if (n2 >= jKTableViewAdapter.getVirtualBounds().x && n2 < jKTableViewAdapter.getVirtualBounds().x + jKTableViewAdapter.getVirtualBounds().width) {
                return jKTableViewAdapter;
            }
            ++n3;
        }
        return null;
    }

    public Rectangle getVirtualBounds() {
        return new Rectangle(this.getVirtualX(), this.getVirtualY(), this.getVirtualWidth(), this.getVirtualHeight());
    }

    public int getFirstColumnNumber() {
        return this.getFirstColumnNumber("java.lang.Object");
    }

    public int getFirstColumnNumber(String string) {
        Rectangle rectangle = this.adapters[0][0].getVirtualBounds();
        return this.owner.getDimensions().getColumnNumber(string, rectangle.x);
    }

    public int getFirstColumnNumber(int n) {
        Rectangle rectangle = this.adapters[0][0].getVirtualBounds();
        return this.owner.getDimensions().getColumnNumber(n, rectangle.x);
    }

    public int getLastColumnNumber() {
        return this.getLastColumnNumber("java.lang.Object");
    }

    public int getLastColumnNumber(String string) {
        Rectangle rectangle = this.adapters[this.adapters.length - 1][0].getVirtualBounds();
        return this.owner.getDimensions().getColumnNumber(string, rectangle.x + rectangle.width) - 1;
    }

    public int getLastColumnNumber(int n) {
        Rectangle rectangle = this.adapters[this.adapters.length - 1][0].getVirtualBounds();
        return this.owner.getDimensions().getColumnNumber(n, rectangle.x + rectangle.width) - 1;
    }

    public int getNumberOfColumns() {
        return this.getNumberOfColumns("java.lang.Object");
    }

    public int getNumberOfColumns(String string) {
        return this.getLastColumnNumber(string) - this.getFirstColumnNumber(string) + 1;
    }

    public int getNumberOfColumns(int n) {
        return this.getLastColumnNumber(n) - this.getFirstColumnNumber(n) + 1;
    }

    public int getVirtualX() {
        return this.getVirtualX(0);
    }

    public int getVirtualX(int n) {
        return this.adapters[n][0].getVirtualBounds().x;
    }

    public int getVirtualWidth() {
        return this.getVirtualX(this.adapters.length - 1) + this.getVirtualWidth(this.adapters.length - 1) - this.getVirtualX();
    }

    public int getVirtualWidth(int n) {
        return this.adapters[n][0].getVirtualBounds().width;
    }

    public void setVirtualX(int n) {
        int n2 = n - this.getVirtualX();
        if (n2 != 0) {
            this.shiftVirtualWidth(0, n2);
        }
    }

    public void shiftVirtualWidth(int n, int n2) {
        JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
        int n3 = 0;
        while (n3 < jKTableViewAdapterArray.length) {
            jKTableViewAdapterArray[n3].shiftVirtualBounds(n2, 0);
            ++n3;
        }
        this.updateHorizontalScrollbar(n);
        if (n + 1 < this.adapters.length) {
            this.shiftVirtualWidth(n + 1, n2);
        }
    }

    public void insertVirtualWidth(int n, int n2, int n3) {
        JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
        int n4 = 0;
        while (n4 < jKTableViewAdapterArray.length) {
            jKTableViewAdapterArray[n4].insertVirtualWidth(n2, n3);
            ++n4;
        }
        this.updateHorizontalScrollbar(n);
        if (n + 1 < this.adapters.length) {
            this.shiftVirtualWidth(n + 1, n3);
        }
    }

    public void removeVirtualWidth(int n, int n2, int n3) {
        JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
        int n4 = 0;
        while (n4 < jKTableViewAdapterArray.length) {
            jKTableViewAdapterArray[n4].removeVirtualWidth(n2, n3);
            ++n4;
        }
        this.updateHorizontalScrollbar(n);
        if (n + 1 < this.adapters.length) {
            this.shiftVirtualWidth(n + 1, -n3);
        }
    }

    public void adjustVirtualWidth(int n, int n2, int n3) {
        if (n3 > 0) {
            this.insertVirtualWidth(n, n2, n3);
        }
        if (n3 < 0) {
            this.removeVirtualWidth(n, n2, -n3);
        }
    }

    public void moveVirtualWidth(int n, int n2) {
        if (n2 > 0) {
            this.insertVirtualWidth(n, this.getVirtualX(n + 1), n2);
            this.removeVirtualWidth(n + 1, this.getVirtualX(n + 1), n2);
        }
        if (n2 < 0) {
            this.removeVirtualWidth(n, this.getVirtualX(n + 1) + n2, -n2);
            this.insertVirtualWidth(n + 1, this.getVirtualX(n + 1), -n2);
        }
    }

    public int getFirstRowNumber() {
        Rectangle rectangle = this.adapters[0][0].getVirtualBounds();
        return this.owner.getDimensions().getRowNumber(rectangle.y);
    }

    public int getLastRowNumber() {
        Rectangle rectangle = this.adapters[0][this.adapters[0].length - 1].getVirtualBounds();
        return this.owner.getDimensions().getRowNumber(rectangle.y + rectangle.height) - 1;
    }

    public int getNumberOfRows() {
        return this.getLastRowNumber() - this.getFirstRowNumber() + 1;
    }

    public int getVirtualY() {
        return this.getVirtualY(0);
    }

    public int getVirtualY(int n) {
        return this.adapters[0][n].getVirtualBounds().y;
    }

    public int getVirtualHeight() {
        return this.getVirtualY(this.adapters[0].length - 1) + this.getVirtualHeight(this.adapters[0].length - 1) - this.getVirtualY();
    }

    public int getVirtualHeight(int n) {
        return this.adapters[0][n].getVirtualBounds().height;
    }

    public void setVirtualY(int n) {
        int n2 = n - this.getVirtualY();
        if (n2 != 0) {
            this.shiftVirtualHeight(0, n2);
        }
    }

    public void shiftVirtualHeight(int n, int n2) {
        int n3 = 0;
        while (n3 < this.adapters.length) {
            this.adapters[n3][n].shiftVirtualBounds(0, n2);
            ++n3;
        }
        this.updateVerticalScrollbar(n);
        if (n + 1 < this.adapters[0].length) {
            this.shiftVirtualHeight(n + 1, n2);
        }
    }

    public void insertVirtualHeight(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.adapters.length) {
            this.adapters[n4][n].insertVirtualHeight(n2, n3);
            ++n4;
        }
        this.updateVerticalScrollbar(n);
        if (n + 1 < this.adapters[0].length) {
            this.shiftVirtualHeight(n + 1, n3);
        }
    }

    public void removeVirtualHeight(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.adapters.length) {
            this.adapters[n4][n].removeVirtualHeight(n2, n3);
            ++n4;
        }
        this.updateVerticalScrollbar(n);
        if (n + 1 < this.adapters[0].length) {
            this.shiftVirtualHeight(n + 1, -n3);
        }
    }

    public void adjustVirtualHeight(int n, int n2, int n3) {
        if (n3 > 0) {
            this.insertVirtualHeight(n, n2, n3);
        }
        if (n3 < 0) {
            this.removeVirtualHeight(n, n2, -n3);
        }
    }

    public void moveVirtualHeight(int n, int n2) {
        if (n2 > 0) {
            this.insertVirtualHeight(n, this.getVirtualY(n + 1), n2);
            this.removeVirtualHeight(n + 1, this.getVirtualY(n + 1), n2);
        }
        if (n2 < 0) {
            this.removeVirtualHeight(n, this.getVirtualY(n + 1) + n2, -n2);
            this.insertVirtualHeight(n + 1, this.getVirtualY(n + 1), -n2);
        }
    }

    public final int getScreenX() {
        return this.adapters[0][0].getScreenBounds().x;
    }

    public void setScreenX(int n) {
        int n2 = n - this.getScreenX();
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n3];
            int n4 = 0;
            while (n4 < jKTableViewAdapterArray.length) {
                JKTableViewAdapter jKTableViewAdapter = jKTableViewAdapterArray[n4];
                Rectangle rectangle = jKTableViewAdapter.getScreenBounds();
                jKTableViewAdapter.setScreenBounds(rectangle.x + n2, rectangle.y, rectangle.width, rectangle.height);
                ++n4;
            }
            ++n3;
        }
    }

    public final int getScreenY() {
        return this.adapters[0][0].getScreenBounds().y;
    }

    public void setScreenY(int n) {
        int n2 = n - this.adapters[0][0].getScreenBounds().y;
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n3];
            int n4 = 0;
            while (n4 < jKTableViewAdapterArray.length) {
                JKTableViewAdapter jKTableViewAdapter = jKTableViewAdapterArray[n4];
                Rectangle rectangle = jKTableViewAdapter.getScreenBounds();
                jKTableViewAdapter.setScreenBounds(rectangle.x, rectangle.y + n2, rectangle.width, rectangle.height);
                ++n4;
            }
            ++n3;
        }
    }

    public int getScreenWidth(int n) {
        return this.adapters[n][0].getScreenBounds().width;
    }

    public void setScreenWidth(int n, int n2) {
        int n3 = (n2 > 0 ? n2 : 0) - this.getScreenWidth(n);
        if (n3 == 0) {
            return;
        }
        JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
        int n4 = 0;
        while (n4 < jKTableViewAdapterArray.length) {
            JKTableViewAdapter jKTableViewAdapter = jKTableViewAdapterArray[n4];
            Rectangle rectangle = jKTableViewAdapter.getScreenBounds();
            jKTableViewAdapter.setScreenBounds(rectangle.x, rectangle.y, n2, rectangle.height);
            ++n4;
        }
        int n5 = n + 1;
        while (n5 < this.adapters.length) {
            jKTableViewAdapterArray = this.adapters[n5];
            int n6 = 0;
            while (n6 < jKTableViewAdapterArray.length) {
                JKTableViewAdapter jKTableViewAdapter = jKTableViewAdapterArray[n6];
                Rectangle rectangle = jKTableViewAdapter.getScreenBounds();
                jKTableViewAdapter.setScreenBounds(rectangle.x + n3, rectangle.y, rectangle.width, rectangle.height);
                ++n6;
            }
            ++n5;
        }
        this.updateHorizontalScrollbar(n);
    }

    public void moveScreenWidth(int n, int n2) {
        Serializable serializable;
        if (n2 == 0) {
            return;
        }
        JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
        int n3 = 0;
        while (n3 < jKTableViewAdapterArray.length) {
            JKTableViewAdapter jKTableViewAdapter = jKTableViewAdapterArray[n3];
            serializable = jKTableViewAdapter.getScreenBounds();
            jKTableViewAdapter.setScreenBounds(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width + n2, ((Rectangle)serializable).height);
            ++n3;
        }
        jKTableViewAdapterArray = this.adapters[n + 1];
        int n4 = 0;
        while (n4 < jKTableViewAdapterArray.length) {
            serializable = jKTableViewAdapterArray[n4];
            Rectangle rectangle = ((JKTableViewAdapter)serializable).getScreenBounds();
            ((JKTableViewAdapter)serializable).setScreenBounds(rectangle.x + n2, rectangle.y, rectangle.width - n2, rectangle.height);
            ++n4;
        }
        this.updateHorizontalScrollbar(n);
        this.updateHorizontalScrollbar(n + 1);
    }

    public int getScreenHeight(int n) {
        return this.adapters[0][n].getScreenBounds().height;
    }

    public void setScreenHeight(int n, int n2) {
        JKTableViewAdapter[] jKTableViewAdapterArray;
        int n3 = n2 - this.getScreenHeight(n);
        if (n3 == 0) {
            return;
        }
        int n4 = 0;
        while (n4 < this.adapters.length) {
            JKTableViewAdapter jKTableViewAdapter = this.adapters[n4][n];
            jKTableViewAdapterArray = jKTableViewAdapter.getScreenBounds();
            jKTableViewAdapter.setScreenBounds(jKTableViewAdapterArray.x, jKTableViewAdapterArray.y, jKTableViewAdapterArray.width, n2);
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.adapters.length) {
            jKTableViewAdapterArray = this.adapters[n5];
            int n6 = n + 1;
            while (n6 < jKTableViewAdapterArray.length) {
                JKTableViewAdapter jKTableViewAdapter = jKTableViewAdapterArray[n6];
                Rectangle rectangle = jKTableViewAdapter.getScreenBounds();
                jKTableViewAdapter.setScreenBounds(rectangle.x, rectangle.y + n3, rectangle.width, rectangle.height);
                ++n6;
            }
            ++n5;
        }
        this.updateVerticalScrollbar(n);
    }

    public void moveScreenHeight(int n, int n2) {
        Serializable serializable;
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        while (n3 < this.adapters.length) {
            JKTableViewAdapter jKTableViewAdapter = this.adapters[n3][n];
            serializable = jKTableViewAdapter.getScreenBounds();
            jKTableViewAdapter.setScreenBounds(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height + n2);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.adapters.length) {
            serializable = this.adapters[n4][n + 1];
            Rectangle rectangle = ((JKTableViewAdapter)serializable).getScreenBounds();
            ((JKTableViewAdapter)serializable).setScreenBounds(rectangle.x, rectangle.y + n2, rectangle.width, rectangle.height - n2);
            ++n4;
        }
        this.updateVerticalScrollbar(n);
        this.updateVerticalScrollbar(n + 1);
    }

    public void damageAll() {
        int n = 0;
        while (n < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
            int n2 = 0;
            while (n2 < jKTableViewAdapterArray.length) {
                jKTableViewAdapterArray[n2].damageAll();
                ++n2;
            }
            ++n;
        }
    }

    public void damageVirtualRegion(Rectangle rectangle) {
        int n = 0;
        while (n < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
            int n2 = 0;
            while (n2 < jKTableViewAdapterArray.length) {
                jKTableViewAdapterArray[n2].damageVirtualRegion(rectangle);
                ++n2;
            }
            ++n;
        }
    }

    public void damageScreenRegion(Rectangle rectangle) {
        int n = 0;
        while (n < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
            int n2 = 0;
            while (n2 < jKTableViewAdapterArray.length) {
                jKTableViewAdapterArray[n2].damageScreenRegion(rectangle);
                ++n2;
            }
            ++n;
        }
    }

    public void disableRepair() {
        int n = 0;
        while (n < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
            int n2 = 0;
            while (n2 < jKTableViewAdapterArray.length) {
                jKTableViewAdapterArray[n2].disableRepair();
                ++n2;
            }
            ++n;
        }
    }

    public void enableRepair() {
        int n = 0;
        while (n < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
            int n2 = 0;
            while (n2 < jKTableViewAdapterArray.length) {
                jKTableViewAdapterArray[n2].enableRepair();
                ++n2;
            }
            ++n;
        }
    }

    public void repairDamage() {
        this.adapters[1][1].repairDamage();
        int n = 0;
        while (n < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
            int n2 = 0;
            while (n2 < jKTableViewAdapterArray.length) {
                if (n != 1 || n2 != 1) {
                    jKTableViewAdapterArray[n2].repairDamage();
                }
                ++n2;
            }
            ++n;
        }
    }

    public void repaintRows(int n, int n2) {
        if (n2 < 1) {
            return;
        }
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n3 = jKDimensionPolicy.getVirtualY(n);
        int n4 = jKDimensionPolicy.getTotalHeight(n, n2);
        this.repaintVirtual(this.owner.getCoordinator().getVirtualX(), n3, this.owner.getCoordinator().getVirtualWidth(), n4);
    }

    public void repaintColumns(int n, int n2) {
        this.repaintColumns("java.lang.Object", n, n2);
    }

    public void repaintColumns(String string, int n, int n2) {
        if (n2 < 1) {
            return;
        }
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n3 = jKDimensionPolicy.getVirtualX(string, n);
        int n4 = jKDimensionPolicy.getTotalWidth(string, n, n2);
        this.repaintVirtual(n3, this.owner.getCoordinator().getVirtualY(), n4, this.owner.getCoordinator().getVirtualHeight());
    }

    public void repaintColumns(int n, int n2, int n3) {
        if (n3 < 1) {
            return;
        }
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n4 = jKDimensionPolicy.getVirtualX(n, n2);
        int n5 = jKDimensionPolicy.getTotalWidth(n, n2, n3);
        this.repaintVirtual(n4, this.owner.getCoordinator().getVirtualY(), n5, this.owner.getCoordinator().getVirtualHeight());
    }

    public void repaintCells(int n, int n2, int n3, int n4) {
        if (n3 < 1 || n4 < 1) {
            return;
        }
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n5 = jKDimensionPolicy.getVirtualX(n, n2);
        int n6 = jKDimensionPolicy.getVirtualY(n);
        int n7 = jKDimensionPolicy.getTotalWidth(n, n2, n4);
        int n8 = jKDimensionPolicy.getTotalHeight(n, n3);
        this.repaintVirtual(n5, n6, n7, n8);
    }

    public void repaintVirtual(Rectangle rectangle) {
        this.repaintVirtual(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void repaintVirtual(int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < this.adapters.length) {
            JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n5];
            int n6 = 0;
            while (n6 < jKTableViewAdapterArray.length) {
                jKTableViewAdapterArray[n6].repaintVirtual(n, n2, n3, n4);
                ++n6;
            }
            ++n5;
        }
    }

    public void paint(Graphics graphics) {
        JKTableViewAdapter[] jKTableViewAdapterArray;
        Rectangle rectangle = this.owner.screenBounds();
        this.getBorder().display(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.adapters[1][1].paint(graphics);
        int n = 0;
        while (n < this.adapters.length) {
            jKTableViewAdapterArray = this.adapters[n];
            int n2 = 0;
            while (n2 < jKTableViewAdapterArray.length) {
                if (n != 1 || n2 != 1) {
                    jKTableViewAdapterArray[n2].paint(graphics);
                }
                ++n2;
            }
            ++n;
        }
        jKTableViewAdapterArray = this.horzScrollbars[1];
        OSIScrollbar oSIScrollbar = this.vertScrollbars[1];
        if (jKTableViewAdapterArray != null && jKTableViewAdapterArray.isVisible() && oSIScrollbar != null && oSIScrollbar.isVisible()) {
            graphics.setColor(jKTableViewAdapterArray.getBackground());
            int n3 = oSIScrollbar.bounds().width;
            int n4 = jKTableViewAdapterArray.bounds().height;
            graphics.fillRect(rectangle.x + rectangle.width - n3, rectangle.y + rectangle.height - n4, n3, n4);
        }
    }

    public boolean isCellVisible(int n, int n2) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForCell(n, n2);
        if (jKTableViewAdapter != null) {
            return jKTableViewAdapter.isCellVisible(n, n2);
        }
        return false;
    }

    public void keepCellVisible(int n, int n2) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForCell(n, n2);
        if (jKTableViewAdapter != null) {
            jKTableViewAdapter.keepCellVisible(n, n2);
        }
    }

    public Point getFirstVisibleCell(int n, int n2) {
        return new Point(this.getFirstVisibleColumn(n), this.getFirstVisibleRow(n2));
    }

    public void scrollToCell(int n, int n2, int n3, int n4) {
        this.setVirtualScroll(n, n2, this.owner.getDimensions().getVirtualX(n3, n4), this.owner.getDimensions().getVirtualY(n3));
    }

    public boolean isRowVisible(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForRow(n);
        if (jKTableViewAdapter != null) {
            return jKTableViewAdapter.isRowVisible(n);
        }
        return false;
    }

    public void keepRowVisible(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForRow(n);
        if (jKTableViewAdapter != null) {
            jKTableViewAdapter.keepRowVisible(n);
        }
    }

    public void keepRowsVisible(int n, int n2) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForRow(n);
        if (jKTableViewAdapter != null) {
            jKTableViewAdapter.keepRowsVisible(n, n2);
        }
    }

    public int getFirstVisibleRow(int n) {
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n2 = this.getVirtualYScroll(n);
        int n3 = jKDimensionPolicy.getRowNumber(n2);
        if (this.getScreenHeight(n) > 10) {
            int n4 = jKDimensionPolicy.getVirtualY(n3);
            int n5 = n4 + jKDimensionPolicy.getHeight(n3);
            if (n4 < n2 && n5 - 5 < n2) {
                ++n3;
            }
        }
        return n3;
    }

    public int getLastVisibleRow(int n) {
        int n2;
        int n3;
        int n4;
        if (this.getScreenHeight(n) <= 10) {
            return this.getFirstVisibleRow(n);
        }
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n5 = this.getVirtualYScroll(n) + this.getScreenHeight(n);
        if (n5 > this.getVirtualY(n) + this.getVirtualHeight(n)) {
            n5 = this.getVirtualY(n) + this.getVirtualHeight(n);
        }
        if ((n4 = (n3 = jKDimensionPolicy.getVirtualY(n2 = jKDimensionPolicy.getRowNumber(n5))) + jKDimensionPolicy.getHeight(n2)) > n5 && n3 + 5 > n5) {
            --n2;
        }
        return n2;
    }

    public int getNumberOfVisibleRows(int n) {
        if (this.getScreenHeight(n) < 1) {
            return 0;
        }
        return this.getLastVisibleRow(n) - this.getFirstVisibleRow(n) + 1;
    }

    public void scrollToRow(int n, int n2) {
        this.setVirtualScroll(0, n, this.getVirtualX(0), this.owner.getDimensions().getVirtualY(n2));
    }

    public boolean isColumnVisible(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForColumn(n);
        if (jKTableViewAdapter != null) {
            return jKTableViewAdapter.isColumnVisible(n);
        }
        return false;
    }

    public boolean isColumnVisible(int n, int n2) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForColumn(n, n2);
        if (jKTableViewAdapter != null) {
            return jKTableViewAdapter.isColumnVisible(n, n2);
        }
        return false;
    }

    public boolean isColumnVisible(String string, int n) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForColumn(string, n);
        if (jKTableViewAdapter != null) {
            return jKTableViewAdapter.isColumnVisible(string, n);
        }
        return false;
    }

    public void keepColumnVisible(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForColumn(n);
        if (jKTableViewAdapter != null) {
            jKTableViewAdapter.keepColumnVisible(n);
        }
    }

    public void keepColumnVisible(int n, int n2) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForColumn(n, n2);
        if (jKTableViewAdapter != null) {
            jKTableViewAdapter.keepColumnVisible(n, n2);
        }
    }

    public void keepColumnVisible(String string, int n) {
        JKTableViewAdapter jKTableViewAdapter = this.getAdapterForColumn(string, n);
        if (jKTableViewAdapter != null) {
            jKTableViewAdapter.keepColumnVisible(string, n);
        }
    }

    public int getFirstVisibleColumn(int n) {
        return this.getFirstVisibleColumn(n, "java.lang.Object");
    }

    public int getLastVisibleColumn(int n) {
        return this.getLastVisibleColumn(n, "java.lang.Object");
    }

    public int getNumberOfVisibleColumns(int n) {
        return this.getNumberOfVisibleColumns(n, "java.lang.Object");
    }

    public int getFirstVisibleColumn(int n, int n2) {
        return this.getFirstVisibleColumn(n, this.owner.getModel().getRowType(n2));
    }

    public int getLastVisibleColumn(int n, int n2) {
        return this.getLastVisibleColumn(n, this.owner.getModel().getRowType(n2));
    }

    public int getNumberOfVisibleColumns(int n, int n2) {
        return this.getNumberOfVisibleColumns(n, this.owner.getModel().getRowType(n2));
    }

    public int getFirstVisibleColumn(int n, String string) {
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n2 = this.getVirtualXScroll(n);
        int n3 = jKDimensionPolicy.getColumnNumber(string, n2);
        if (this.getScreenWidth(n) > 10) {
            int n4 = jKDimensionPolicy.getVirtualX(string, n3);
            int n5 = n4 + jKDimensionPolicy.getWidth(string, n3);
            if (n4 < n2 && n5 - 5 < n2) {
                ++n3;
            }
        }
        return n3;
    }

    public int getLastVisibleColumn(int n, String string) {
        int n2;
        int n3;
        int n4;
        if (this.getScreenWidth(n) <= 10) {
            return this.getFirstVisibleColumn(n);
        }
        JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
        int n5 = this.getVirtualXScroll(n) + this.getScreenWidth(n);
        if (n5 > this.getVirtualX(n) + this.getVirtualWidth(n)) {
            n5 = this.getVirtualX(n) + this.getVirtualWidth(n);
        }
        if ((n4 = (n3 = jKDimensionPolicy.getVirtualX(string, n2 = jKDimensionPolicy.getColumnNumber(string, n5))) + jKDimensionPolicy.getWidth(n2)) > n5 && n3 + 5 > n5) {
            --n2;
        }
        return n2;
    }

    public int getNumberOfVisibleColumns(int n, String string) {
        if (this.getScreenWidth(n) < 1) {
            return 0;
        }
        return this.getLastVisibleColumn(n, string) - this.getFirstVisibleColumn(n, string) + 1;
    }

    public void scrollToColumn(int n, String string, int n2) {
        this.setVirtualScroll(n, 0, this.owner.getDimensions().getVirtualX(string, n2), this.getVirtualY(0));
    }

    public void scrollToColumn(int n, int n2, int n3) {
        this.setVirtualScroll(n, 0, this.owner.getDimensions().getVirtualX(n2, n3), this.getVirtualY(0));
    }

    public void setVirtualScroll(int n, int n2, int n3, int n4) {
        int n5 = this.getVirtualXScroll(n);
        int n6 = this.getVirtualYScroll(n2);
        this.owner.aboutToScroll(n, n2, n3 - n5, n4 - n6);
        this.adapters[n][n2].setVirtualScroll(n3, n4);
        this.basicSetVirtualXScroll(n, n3);
        this.basicSetVirtualYScroll(n2, n4);
        this.owner.scrolled(n, n2, this.getVirtualXScroll(n) - n5, this.getVirtualYScroll(n2) - n6);
    }

    public int getVirtualXScroll(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.adapters[n][0];
        return jKTableViewAdapter.getVirtualScroll().x;
    }

    public void setVirtualXScroll(int n, int n2) {
        this.setVirtualXScroll(n, n2, OSIScrollbar.jdk102SBStyle);
    }

    public void setVirtualXScroll(int n, int n2, boolean bl) {
        int n3 = this.getVirtualXScroll(n);
        this.owner.aboutToScroll(n, 0, n2 - n3, 0);
        if (bl) {
            this.basicSetVirtualXScroll(n, n2);
        } else {
            this.adapterSetVirtualXScroll(n, n2);
        }
        this.owner.scrolled(n, 0, this.getVirtualXScroll(n) - n3, 0);
    }

    public void basicSetVirtualXScroll(int n, int n2) {
        this.adapterSetVirtualXScroll(n, n2);
        OSIScrollbar oSIScrollbar = this.horzScrollbars[n];
        if (oSIScrollbar != null) {
            int n3 = this.getVirtualXScroll(n);
            if (oSIScrollbar.getValue() != n3) {
                oSIScrollbar.setValue(n3);
            }
        }
    }

    public void adapterSetVirtualXScroll(int n, int n2) {
        JKTableViewAdapter[] jKTableViewAdapterArray = this.adapters[n];
        int n3 = 0;
        while (n3 < jKTableViewAdapterArray.length) {
            JKTableViewAdapter jKTableViewAdapter = jKTableViewAdapterArray[n3];
            jKTableViewAdapter.setVirtualScroll(n2, jKTableViewAdapter.getVirtualScroll().y);
            ++n3;
        }
    }

    public int getVirtualYScroll(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.adapters[0][n];
        return jKTableViewAdapter.getVirtualScroll().y;
    }

    public void setVirtualYScroll(int n, int n2) {
        this.setVirtualYScroll(n, n2, OSIScrollbar.jdk102SBStyle);
    }

    public void setVirtualYScroll(int n, int n2, boolean bl) {
        int n3 = this.getVirtualYScroll(n);
        this.owner.aboutToScroll(0, n, 0, n2 - n3);
        if (bl) {
            this.basicSetVirtualYScroll(n, n2);
        } else {
            this.adapterSetVirtualYScroll(n, n2);
        }
        this.owner.scrolled(0, n, 0, this.getVirtualYScroll(n) - n3);
    }

    public void basicSetVirtualYScroll(int n, int n2) {
        this.adapterSetVirtualYScroll(n, n2);
        OSIScrollbar oSIScrollbar = this.vertScrollbars[n];
        if (oSIScrollbar != null) {
            int n3 = this.getVirtualYScroll(n);
            if (oSIScrollbar.getValue() != n3) {
                oSIScrollbar.setValue(n3);
            }
        }
    }

    public void adapterSetVirtualYScroll(int n, int n2) {
        int n3 = 0;
        while (n3 < this.adapters.length) {
            JKTableViewAdapter jKTableViewAdapter = this.adapters[n3][n];
            jKTableViewAdapter.setVirtualScroll(jKTableViewAdapter.getVirtualScroll().x, n2);
            ++n3;
        }
    }

    public int getVirtualXScrollMin(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.adapters[n][0];
        return jKTableViewAdapter.getVirtualContentBounds().x;
    }

    public int getVirtualXScrollMax(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.adapters[n][0];
        Rectangle rectangle = jKTableViewAdapter.getVirtualContentBounds();
        Rectangle rectangle2 = jKTableViewAdapter.getScreenContentBounds();
        int n2 = rectangle.width - rectangle2.width;
        if (n2 < 0) {
            n2 = 0;
        }
        return rectangle.x + n2;
    }

    public int getVirtualXScrollVisible(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.adapters[n][0];
        int n2 = jKTableViewAdapter.getScreenContentBounds().width;
        if (n2 > jKTableViewAdapter.getVirtualContentBounds().width) {
            n2 = jKTableViewAdapter.getVirtualContentBounds().width;
        }
        return n2;
    }

    public OSIScrollbar getHorizontalScrollbar(int n) {
        return this.horzScrollbars[n];
    }

    public void setHorizontalScrollbars(int n) {
        if (this.horzScrollbars == null) {
            this.horzScrollbars = new OSIScrollbar[n];
            return;
        }
        if (n != this.horzScrollbars.length) {
            int n2 = n;
            while (n2 < this.horzScrollbars.length) {
                this.setHorizontalScrollbar(n2, null);
                ++n2;
            }
            OSIScrollbar[] oSIScrollbarArray = new OSIScrollbar[n];
            System.arraycopy(this.horzScrollbars, 0, oSIScrollbarArray, 0, n < this.horzScrollbars.length ? n : this.horzScrollbars.length);
            this.horzScrollbars = oSIScrollbarArray;
        }
    }

    public void setHorizontalScrollbar(int n, OSIScrollbar oSIScrollbar) {
        OSIScrollbar oSIScrollbar2 = this.horzScrollbars[n];
        if (oSIScrollbar2 == oSIScrollbar) {
            return;
        }
        if (oSIScrollbar2 != null) {
            OSIEventTable.removeAdjustmentListener((Scrollbar)oSIScrollbar2, (AdjustmentListener)this);
            ((Container)((Object)this.owner)).remove(oSIScrollbar2);
        }
        this.horzScrollbars[n] = oSIScrollbar;
        if (oSIScrollbar != null) {
            ((Container)((Object)this.owner)).add(oSIScrollbar);
            OSIEventTable.addAdjustmentListener((Scrollbar)oSIScrollbar, (AdjustmentListener)this);
        }
        this.updateHorizontalScrollbar(n);
    }

    public void updateHorizontalScrollbar(int n) {
        OSIScrollbar oSIScrollbar = this.horzScrollbars[n];
        if (oSIScrollbar == null) {
            return;
        }
        oSIScrollbar.setOSIValues(this.getVirtualXScroll(n), this.getVirtualXScrollVisible(n), this.getVirtualXScrollMin(n), this.getVirtualXScrollMax(n));
    }

    public int getVirtualYScrollMin(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.adapters[0][n];
        return jKTableViewAdapter.getVirtualContentBounds().y;
    }

    public int getVirtualYScrollMax(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.adapters[0][n];
        Rectangle rectangle = jKTableViewAdapter.getVirtualContentBounds();
        Rectangle rectangle2 = jKTableViewAdapter.getScreenContentBounds();
        int n2 = rectangle.height - rectangle2.height;
        if (n2 < 0) {
            n2 = 0;
        }
        return rectangle.y + n2;
    }

    public int getVirtualYScrollVisible(int n) {
        JKTableViewAdapter jKTableViewAdapter = this.adapters[0][n];
        int n2 = jKTableViewAdapter.getScreenContentBounds().height;
        if (n2 > jKTableViewAdapter.getVirtualContentBounds().height) {
            n2 = jKTableViewAdapter.getVirtualContentBounds().height;
        }
        return n2;
    }

    public OSIScrollbar getVerticalScrollbar(int n) {
        return this.vertScrollbars[n];
    }

    public void setVerticalScrollbars(int n) {
        if (this.vertScrollbars == null) {
            this.vertScrollbars = new OSIScrollbar[n];
            return;
        }
        if (n != this.vertScrollbars.length) {
            int n2 = n;
            while (n2 < this.vertScrollbars.length) {
                this.setVerticalScrollbar(n2, null);
                ++n2;
            }
            OSIScrollbar[] oSIScrollbarArray = new OSIScrollbar[n];
            System.arraycopy(this.vertScrollbars, 0, oSIScrollbarArray, 0, n < this.vertScrollbars.length ? n : this.vertScrollbars.length);
            this.vertScrollbars = oSIScrollbarArray;
        }
    }

    public void setVerticalScrollbar(int n, OSIScrollbar oSIScrollbar) {
        OSIScrollbar oSIScrollbar2 = this.vertScrollbars[n];
        if (oSIScrollbar2 == oSIScrollbar) {
            return;
        }
        if (oSIScrollbar2 != null) {
            OSIEventTable.removeAdjustmentListener((Scrollbar)oSIScrollbar2, (AdjustmentListener)this);
            ((Container)((Object)this.owner)).remove(oSIScrollbar2);
        }
        this.vertScrollbars[n] = oSIScrollbar;
        if (oSIScrollbar != null) {
            ((Container)((Object)this.owner)).add(oSIScrollbar);
            OSIEventTable.addAdjustmentListener((Scrollbar)oSIScrollbar, (AdjustmentListener)this);
        }
        this.updateVerticalScrollbar(n);
    }

    public void updateVerticalScrollbar(int n) {
        OSIScrollbar oSIScrollbar = this.vertScrollbars[n];
        if (oSIScrollbar == null) {
            return;
        }
        oSIScrollbar.setOSIValues(this.getVirtualYScroll(n), this.getVirtualYScrollVisible(n), this.getVirtualYScrollMin(n), this.getVirtualYScrollMax(n));
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        OSIScrollbar oSIScrollbar = (OSIScrollbar)adjustmentEvent.getSource();
        int n = 0;
        while (n < this.horzScrollbars.length) {
            if (oSIScrollbar == this.horzScrollbars[n]) {
                JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
                switch (adjustmentEvent.getAdjustmentType()) {
                    case 2: {
                        int n2 = this.getVirtualXScroll(n);
                        int n3 = oSIScrollbar.getLineIncrement();
                        if (n3 != 0) {
                            int n4 = n2 - n3;
                            this.setVirtualXScroll(n, n4);
                        } else {
                            int n5 = jKDimensionPolicy.getColumnNumber(n2 - 1);
                            int n6 = jKDimensionPolicy.getVirtualX(n5);
                            this.setVirtualXScroll(n, n6, true);
                        }
                        this.owner.getRepairPolicy().damaged();
                        return;
                    }
                    case 1: {
                        int n7 = this.getVirtualXScroll(n);
                        int n8 = oSIScrollbar.getLineIncrement();
                        if (n8 != 0) {
                            int n9 = n7 + n8;
                            this.setVirtualXScroll(n, n9);
                        } else {
                            int n10 = jKDimensionPolicy.getColumnNumber(n7);
                            int n11 = jKDimensionPolicy.getVirtualX(n10 + 1);
                            this.setVirtualXScroll(n, n11, true);
                        }
                        this.owner.getRepairPolicy().damaged();
                        return;
                    }
                    case 3: {
                        int n12 = this.getVirtualXScroll(n);
                        int n13 = oSIScrollbar.getPageIncrement();
                        if (n13 != 0) {
                            int n14 = n12 - n13;
                            this.setVirtualXScroll(n, n14);
                        } else {
                            int n15 = jKDimensionPolicy.getColumnNumber(n12);
                            int n16 = jKDimensionPolicy.getColumnNumber(n12 - this.getScreenWidth(n) * 4 / 5);
                            if (n16 == n15) {
                                --n16;
                            }
                            int n17 = jKDimensionPolicy.getVirtualX(n16);
                            this.setVirtualXScroll(n, n17, true);
                        }
                        this.owner.getRepairPolicy().damaged();
                        return;
                    }
                    case 4: {
                        int n18 = this.getVirtualXScroll(n);
                        int n19 = oSIScrollbar.getPageIncrement();
                        if (n19 != 0) {
                            int n20 = n18 + n19;
                            this.setVirtualXScroll(n, n20);
                        } else {
                            int n21 = jKDimensionPolicy.getColumnNumber(n18);
                            int n22 = jKDimensionPolicy.getColumnNumber(n18 + this.getScreenWidth(n) * 4 / 5);
                            if (n22 == n21) {
                                ++n22;
                            }
                            int n23 = jKDimensionPolicy.getVirtualX(n22);
                            this.setVirtualXScroll(n, n23, true);
                        }
                        this.owner.getRepairPolicy().damaged();
                        return;
                    }
                    case 5: {
                        this.setVirtualXScroll(n, adjustmentEvent.getValue(), false);
                        this.owner.getRepairPolicy().damaged();
                        return;
                    }
                }
                return;
            }
            ++n;
        }
        int n24 = 0;
        while (n24 < this.vertScrollbars.length) {
            if (oSIScrollbar == this.vertScrollbars[n24]) {
                JKDimensionPolicy jKDimensionPolicy = this.owner.getDimensions();
                switch (adjustmentEvent.getAdjustmentType()) {
                    case 2: {
                        int n25 = this.getVirtualYScroll(n24);
                        int n26 = oSIScrollbar.getLineIncrement();
                        if (n26 != 0) {
                            int n27 = n25 - n26;
                            this.setVirtualYScroll(n24, n27);
                        } else {
                            int n28 = jKDimensionPolicy.getRowNumber(n25 - 1);
                            int n29 = jKDimensionPolicy.getVirtualY(n28);
                            this.setVirtualYScroll(n24, n29, true);
                        }
                        this.owner.getRepairPolicy().damaged();
                        return;
                    }
                    case 1: {
                        int n30 = this.getVirtualYScroll(n24);
                        int n31 = oSIScrollbar.getLineIncrement();
                        if (n31 != 0) {
                            int n32 = n30 + n31;
                            this.setVirtualYScroll(n24, n32);
                        } else {
                            int n33 = jKDimensionPolicy.getRowNumber(n30);
                            int n34 = jKDimensionPolicy.getVirtualY(n33 + 1);
                            this.setVirtualYScroll(n24, n34, true);
                        }
                        this.owner.getRepairPolicy().damaged();
                        return;
                    }
                    case 3: {
                        int n35 = this.getVirtualYScroll(n24);
                        int n36 = oSIScrollbar.getPageIncrement();
                        if (n36 != 0) {
                            int n37 = n35 - n36;
                            this.setVirtualYScroll(n24, n37);
                        } else {
                            int n38 = jKDimensionPolicy.getRowNumber(n35);
                            int n39 = jKDimensionPolicy.getRowNumber(n35 - this.getScreenHeight(n24) * 4 / 5);
                            if (n39 == n38) {
                                --n39;
                            }
                            int n40 = jKDimensionPolicy.getVirtualY(n39);
                            this.setVirtualYScroll(n24, n40, true);
                        }
                        this.owner.getRepairPolicy().damaged();
                        return;
                    }
                    case 4: {
                        int n41 = this.getVirtualYScroll(n24);
                        int n42 = oSIScrollbar.getPageIncrement();
                        if (n42 != 0) {
                            int n43 = n41 + n42;
                            this.setVirtualYScroll(n24, n43);
                        } else {
                            int n44 = jKDimensionPolicy.getRowNumber(n41);
                            int n45 = jKDimensionPolicy.getRowNumber(n41 + this.getScreenHeight(n24) * 4 / 5);
                            if (n45 == n44) {
                                ++n45;
                            }
                            int n46 = jKDimensionPolicy.getVirtualY(n45);
                            this.setVirtualYScroll(n24, n46, true);
                        }
                        this.owner.getRepairPolicy().damaged();
                        return;
                    }
                    case 5: {
                        this.setVirtualYScroll(n24, adjustmentEvent.getValue(), false);
                        this.owner.getRepairPolicy().damaged();
                        return;
                    }
                }
                return;
            }
            ++n24;
        }
    }

    public int getHorizontalScrollbarLineIncrement(int n) {
        OSIScrollbar oSIScrollbar;
        if (n >= 0 && n < this.horzScrollbars.length && (oSIScrollbar = this.horzScrollbars[n]) != null) {
            return oSIScrollbar.getLineIncrement();
        }
        return -1;
    }

    public void setHorizontalScrollbarLineIncrement(int n, int n2) {
        OSIScrollbar oSIScrollbar;
        if (n >= 0 && n < this.horzScrollbars.length && (oSIScrollbar = this.horzScrollbars[n]) != null) {
            oSIScrollbar.setLineIncrement(n2);
        }
    }

    public int getHorizontalScrollbarPageIncrement(int n) {
        OSIScrollbar oSIScrollbar;
        if (n >= 0 && n < this.horzScrollbars.length && (oSIScrollbar = this.horzScrollbars[n]) != null) {
            return oSIScrollbar.getPageIncrement();
        }
        return -1;
    }

    public void setHorizontalScrollbarPageIncrement(int n, int n2) {
        OSIScrollbar oSIScrollbar;
        if (n >= 0 && n < this.horzScrollbars.length && (oSIScrollbar = this.horzScrollbars[n]) != null) {
            oSIScrollbar.setPageIncrement(n2);
        }
    }

    public int getVerticalScrollbarLineIncrement(int n) {
        OSIScrollbar oSIScrollbar;
        if (n >= 0 && n < this.vertScrollbars.length && (oSIScrollbar = this.vertScrollbars[n]) != null) {
            return oSIScrollbar.getLineIncrement();
        }
        return -1;
    }

    public void setVerticalScrollbarLineIncrement(int n, int n2) {
        OSIScrollbar oSIScrollbar;
        if (n >= 0 && n < this.vertScrollbars.length && (oSIScrollbar = this.vertScrollbars[n]) != null) {
            oSIScrollbar.setLineIncrement(n2);
        }
    }

    public int getVerticalScrollbarPageIncrement(int n) {
        OSIScrollbar oSIScrollbar;
        if (n >= 0 && n < this.vertScrollbars.length && (oSIScrollbar = this.vertScrollbars[n]) != null) {
            return oSIScrollbar.getPageIncrement();
        }
        return -1;
    }

    public void setVerticalScrollbarPageIncrement(int n, int n2) {
        OSIScrollbar oSIScrollbar;
        if (n >= 0 && n < this.vertScrollbars.length && (oSIScrollbar = this.vertScrollbars[n]) != null) {
            oSIScrollbar.setPageIncrement(n2);
        }
    }

    public void rowHeightChanged(int n, int n2, int n3) {
        int n4 = this.owner.getDimensions().getVirtualY(n);
        if (n4 >= this.getVirtualY() + this.getVirtualHeight()) {
            return;
        }
        int n5 = this.adapters[0].length - 1;
        while (n5 >= 0) {
            if (n4 >= this.getVirtualY(n5)) {
                this.adjustVirtualHeight(n5, n4, n3 - n2);
                return;
            }
            --n5;
        }
        if (n4 >= 0) {
            this.setVirtualY(this.getVirtualY() + (n3 - n2));
        }
    }

    public void rowHeightsChanged(OSIIntToIntHashtable oSIIntToIntHashtable, OSIIntToIntHashtable oSIIntToIntHashtable2) {
        int n;
        int n2;
        int n3;
        int n4 = this.adapters[0].length - 1;
        while (n4 >= 0) {
            n3 = this.getVirtualY(n4);
            n2 = this.getVirtualHeight(n4);
            n = oSIIntToIntHashtable.count(0, n3);
            int n5 = oSIIntToIntHashtable.count(0, n3 + n2) - n;
            int n6 = oSIIntToIntHashtable2.sum(n, n5);
            this.adjustVirtualHeight(n4, n3, n6 - n2);
            --n4;
        }
        n3 = this.getVirtualY();
        n2 = oSIIntToIntHashtable.count(0, n3);
        n = oSIIntToIntHashtable2.sum(0, n2);
        this.setVirtualY(n);
    }

    public void columnWidthChanged(String string, int n, int n2, int n3) {
        if (!"java.lang.Object".equals(string)) {
            return;
        }
        int n4 = this.owner.getDimensions().getVirtualX(n);
        if (n4 >= this.getVirtualX() + this.getVirtualWidth()) {
            return;
        }
        int n5 = this.adapters.length - 1;
        while (n5 >= 0) {
            if (n4 >= this.getVirtualX(n5)) {
                this.adjustVirtualWidth(n5, n4, n3 - n2);
                return;
            }
            --n5;
        }
        if (n4 >= 0) {
            this.setVirtualX(this.getVirtualX() + (n3 - n2));
        }
    }

    public void columnWidthsChanged(String string, OSIIntToIntHashtable oSIIntToIntHashtable, OSIIntToIntHashtable oSIIntToIntHashtable2) {
        int n;
        int n2;
        int n3;
        if (!"java.lang.Object".equals(string)) {
            return;
        }
        int n4 = this.adapters.length - 1;
        while (n4 >= 0) {
            n3 = this.getVirtualX(n4);
            n2 = this.getVirtualWidth(n4);
            n = oSIIntToIntHashtable.count(0, n3);
            int n5 = oSIIntToIntHashtable.count(0, n3 + n2) - n;
            int n6 = oSIIntToIntHashtable2.sum(n, n5);
            this.adjustVirtualWidth(n4, n3, n6 - n2);
            --n4;
        }
        n3 = this.getVirtualX();
        n2 = oSIIntToIntHashtable.count(0, n3);
        n = oSIIntToIntHashtable2.sum(0, n2);
        this.setVirtualX(n);
    }

    public void modelChanged(JKModelChangedEvent jKModelChangedEvent) {
    }

    public void modelRowsChanged(JKModelRowsChangedEvent jKModelRowsChangedEvent) {
    }

    public void modelRowsAdded(JKModelRowsAddedEvent jKModelRowsAddedEvent) {
        int n = 1;
        int n2 = this.owner.getDimensions().getVirtualY(jKModelRowsAddedEvent.getFirst());
        int n3 = this.owner.getDimensions().getTotalHeight(jKModelRowsAddedEvent.getFirst(), jKModelRowsAddedEvent.getSize());
        this.insertVirtualHeight(n, n2, n3);
    }

    public void modelRowsRemoved(JKModelRowsRemovedEvent jKModelRowsRemovedEvent) {
        int n = 1;
        int n2 = this.owner.getDimensions().getVirtualY(jKModelRowsRemovedEvent.getFirst());
        int n3 = this.owner.getDimensions().getTotalHeight(jKModelRowsRemovedEvent.getFirst(), jKModelRowsRemovedEvent.getSize());
        this.removeVirtualHeight(n, n2, n3);
    }

    public void modelRowsReordered(JKModelRowsReorderEvent jKModelRowsReorderEvent) {
    }

    public void modelColumnsChanged(JKModelColsChangedEvent jKModelColsChangedEvent) {
    }

    public void modelColumnsAdded(JKModelColsAddedEvent jKModelColsAddedEvent) {
        int n = 1;
        int n2 = this.owner.getDimensions().getVirtualX(jKModelColsAddedEvent.getFirst());
        int n3 = this.owner.getDimensions().getTotalWidth(jKModelColsAddedEvent.getFirst(), jKModelColsAddedEvent.getSize());
        this.insertVirtualWidth(n, n2, n3);
    }

    public void modelColumnsRemoved(JKModelColsRemovedEvent jKModelColsRemovedEvent) {
        int n = 1;
        int n2 = this.owner.getDimensions().getVirtualX(jKModelColsRemovedEvent.getFirst());
        int n3 = this.owner.getDimensions().getTotalWidth(jKModelColsRemovedEvent.getFirst(), jKModelColsRemovedEvent.getSize());
        this.removeVirtualWidth(n, n2, n3);
    }

    public void modelColumnsReordered(JKModelColsReorderEvent jKModelColsReorderEvent) {
    }
}

