/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.imstoc;

import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.imstoc.IMSAPPSeg;
import com.ibm.imstoc.IMSException;
import com.ibm.imstoc.IMSMCISeg;
import com.ibm.imstoc.IMSOTMAMsgProperties;
import com.ibm.imstoc.IMSSECSeg;
import com.ibm.imstoc.IMSTRNSeg;
import com.ibm.imstoc.IMSUSDSeg;
import java.io.IOException;

public class IMSOTMAMsg
implements IMSOTMAMsgProperties {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private IMSMCISeg aMCISeg;
    private IMSTRNSeg aTRNSeg;
    private IMSSECSeg aSECSeg;
    private IMSUSDSeg aUSDSeg;
    private IMSAPPSeg aAPPSeg;
    protected RuntimeContext _RuntimeContext = RuntimeContext.getCurrent();

    public IMSOTMAMsg(short currentSegment, byte[] segmentData, boolean hasLLZZ, boolean isInput) throws IOException, IMSException {
        if (isInput) {
            if (currentSegment == 1) {
                this.aMCISeg = new IMSMCISeg();
                this.aTRNSeg = new IMSTRNSeg();
                this.aSECSeg = new IMSSECSeg();
                this.aUSDSeg = new IMSUSDSeg();
                if (segmentData != null) {
                    this.aAPPSeg = new IMSAPPSeg(segmentData, hasLLZZ);
                    this.aMCISeg.setBitONPrefixFlag((byte)16);
                }
                this.aMCISeg.setSegSeqNumber(currentSegment);
                this.aMCISeg.setBitONPrefixFlag((byte)-128);
                this.aMCISeg.setBitONPrefixFlag((byte)64);
                this.aMCISeg.setBitONPrefixFlag((byte)32);
            } else {
                this.aMCISeg = new IMSMCISeg();
                if (segmentData != null) {
                    this.aAPPSeg = new IMSAPPSeg(segmentData, hasLLZZ);
                    this.aMCISeg.setBitONPrefixFlag((byte)16);
                }
                this.aMCISeg.setSegSeqNumber(currentSegment);
            }
        }
    }

    public byte[] export() throws IOException {
        byte[] MCIBuff = null;
        int MCIBuffLen = 0;
        byte[] TRNBuff = null;
        int TRNBuffLen = 0;
        byte[] SECBuff = null;
        int SECBuffLen = 0;
        byte[] USDBuff = null;
        int USDBuffLen = 0;
        byte[] APPBuff = null;
        int APPBuffLen = 0;
        byte[] OTMABuff = null;
        int OTMABuffLen = 0;
        int i = 0;
        int j = 0;
        int buffPos = 0;
        String methodName = String.valueOf(super.toString()) + ".export()";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aMCISeg != null) {
            MCIBuff = this.aMCISeg.export();
            MCIBuffLen = MCIBuff.length;
            OTMABuffLen += MCIBuffLen;
        }
        if (this.aTRNSeg != null) {
            TRNBuff = this.aTRNSeg.export();
            TRNBuffLen = TRNBuff.length;
            OTMABuffLen += TRNBuffLen;
        }
        if (this.aSECSeg != null) {
            SECBuff = this.aSECSeg.export();
            SECBuffLen = SECBuff.length;
            OTMABuffLen += SECBuffLen;
        }
        if (this.aUSDSeg != null) {
            USDBuff = this.aUSDSeg.export();
            USDBuffLen = USDBuff.length;
            OTMABuffLen += USDBuffLen;
        }
        if (this.aAPPSeg != null) {
            APPBuff = this.aAPPSeg.export();
            APPBuffLen = APPBuff.length;
            OTMABuffLen += APPBuffLen;
        }
        OTMABuff = new byte[OTMABuffLen];
        buffPos = 0;
        if (MCIBuffLen != 0) {
            j = 0;
            i = buffPos;
            while (i < MCIBuffLen) {
                OTMABuff[i] = MCIBuff[j];
                ++j;
                ++i;
            }
            buffPos += MCIBuffLen;
        }
        if (TRNBuffLen != 0) {
            j = 0;
            i = buffPos;
            while (i < buffPos + TRNBuffLen) {
                OTMABuff[i] = TRNBuff[j];
                ++j;
                ++i;
            }
            buffPos += TRNBuffLen;
        }
        if (SECBuffLen != 0) {
            j = 0;
            i = buffPos;
            while (i < buffPos + SECBuffLen) {
                OTMABuff[i] = SECBuff[j];
                ++j;
                ++i;
            }
            buffPos += SECBuffLen;
        }
        if (USDBuffLen != 0) {
            j = 0;
            i = buffPos;
            while (i < buffPos + USDBuffLen) {
                OTMABuff[i] = USDBuff[j];
                ++j;
                ++i;
            }
            buffPos += USDBuffLen;
        }
        if (APPBuffLen != 0) {
            j = 0;
            i = buffPos;
            while (i < buffPos + APPBuffLen) {
                OTMABuff[i] = APPBuff[j];
                ++j;
                ++i;
            }
            buffPos += APPBuffLen;
        }
        return OTMABuff;
    }

    public void setBitONCommitConfirm(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONCommitConfirm(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aMCISeg != null) {
            this.aMCISeg.setBitONCommitConfirm(bitValue);
        }
    }

    public void setBitONCommitMode(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONCommitMode(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aTRNSeg != null) {
            this.aTRNSeg.setBitONCommitMode(bitValue);
        }
    }

    public void setBitONIMSState(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitOnIMSState(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aTRNSeg != null) {
            this.aTRNSeg.setBitONIMSState(bitValue);
        }
    }

    public void setBitONMsgType(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONMsgType(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aMCISeg != null) {
            this.aMCISeg.setBitONMsgType(bitValue);
        }
    }

    public void setBitONResponseIndicator(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONResponseIndicator(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aMCISeg != null) {
            this.aMCISeg.setBitONResponseIndicator(bitValue);
        }
    }

    public void setBitONResumeTpipe(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONResumeTpipe(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aMCISeg != null) {
            this.aMCISeg.setBitONResumeTpipe(bitValue);
        }
    }

    public void setBitONSyncLevel(byte bitValue) {
        String methodName = String.valueOf(super.toString()) + ".setBitONSyncLevel(byte)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aTRNSeg != null) {
            this.aTRNSeg.setBitONSyncLevel(bitValue);
        }
    }

    public void setDestID(byte[] aDName) {
        String methodName = String.valueOf(super.toString()) + ".setDestID(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aUSDSeg != null) {
            this.aUSDSeg.setDestID(aDName);
        }
    }

    public void setFirst() {
        String methodName = String.valueOf(super.toString()) + ".setFirst()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aMCISeg != null) {
            this.aMCISeg.setBitONChainState((byte)-128);
        }
    }

    public void setGroupId(byte[] aGNM) {
        String methodName = String.valueOf(super.toString()) + ".setGroupId(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aSECSeg != null) {
            this.aSECSeg.setSecGroupId(aGNM);
        }
    }

    public void setLast() {
        String methodName = String.valueOf(super.toString()) + ".setLast()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aMCISeg != null) {
            this.aMCISeg.setBitOFFChainState((byte)64);
            this.aMCISeg.setBitONChainState((byte)32);
        }
    }

    public void setLTERMName(byte[] aLTName) {
        String methodName = String.valueOf(super.toString()) + ".setLTERMName(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aTRNSeg != null) {
            this.aTRNSeg.setLTERMName(aLTName);
        }
    }

    public void setMiddle() {
        String methodName = String.valueOf(super.toString()) + ".setMiddle()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aMCISeg != null) {
            this.aMCISeg.setBitONChainState((byte)64);
        }
    }

    public void setOriginalID(byte[] aOrigID) {
        String methodName = String.valueOf(super.toString()) + ".setOriginalID(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aUSDSeg != null) {
            this.aUSDSeg.setOriginalID(aOrigID);
        }
    }

    public void setPassword(byte[] aPwd) {
        String methodName = String.valueOf(super.toString()) + ".setPassword(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aUSDSeg != null) {
            this.aUSDSeg.setPassword(aPwd);
        }
    }

    public void setUserId(byte[] aUID) {
        String methodName = String.valueOf(super.toString()) + ".setUserId(byte[])";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aSECSeg != null) {
            this.aSECSeg.setSecUserId(aUID);
        }
    }

    public int sizeOfOTMAMsg() throws IMSException {
        short MCIBuffLen = 0;
        short TRNBuffLen = 0;
        short SECBuffLen = 0;
        short USDBuffLen = 0;
        short APPBuffLen = 0;
        int OTMABuffLen = 0;
        String methodName = String.valueOf(super.toString()) + ".sizeOfOTMAMsg()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        if (this.aMCISeg != null) {
            MCIBuffLen = this.aMCISeg.sizeOfMCISeg();
            OTMABuffLen += MCIBuffLen;
        }
        if (this.aTRNSeg != null) {
            TRNBuffLen = this.aTRNSeg.sizeOfTRNSeg();
            OTMABuffLen += TRNBuffLen;
        }
        if (this.aSECSeg != null) {
            SECBuffLen = this.aSECSeg.sizeOfSECSeg();
            OTMABuffLen += SECBuffLen;
        }
        if (this.aUSDSeg != null) {
            USDBuffLen = this.aUSDSeg.sizeOfUSDSeg();
            OTMABuffLen += USDBuffLen;
        }
        if (this.aAPPSeg != null) {
            APPBuffLen = this.aAPPSeg.sizeOfAPPSeg();
            OTMABuffLen += APPBuffLen;
        }
        return OTMABuffLen;
    }

    public String toString() {
        String retString = null;
        String methodName = String.valueOf(super.toString()) + ".toString()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("-> [" + methodName + "]");
        }
        retString = "\n   OTMAMsg:";
        if (this.aMCISeg != null) {
            retString = String.valueOf(retString) + "\n      MCISeg: " + this.aMCISeg.toString();
        }
        if (this.aTRNSeg != null) {
            retString = String.valueOf(retString) + "\n      TRNSeg: " + this.aTRNSeg.toString();
        }
        if (this.aSECSeg != null) {
            retString = String.valueOf(retString) + "\n      SECSeg: " + this.aSECSeg.toString();
        }
        if (this.aUSDSeg != null) {
            retString = String.valueOf(retString) + "\n      USDSeg: " + this.aUSDSeg.toString();
        }
        if (this.aAPPSeg != null) {
            retString = String.valueOf(retString) + "\n      APPSeg: " + this.aAPPSeg.toString();
        }
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<- [" + methodName + "]");
        }
        return retString;
    }
}

