/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.businessobject;

import com.ibm.ivj.eab.businessobject.BusinessObject;
import com.ibm.ivj.eab.businessobject.IBusinessObject;
import com.ibm.ivj.eab.businessobject.IBusinessObjectKey;
import com.ibm.ivj.eab.businessobject.IInstanceSpace;
import com.ibm.ivj.eab.businessobject.InstanceSpaceHolder;
import com.ibm.ivj.eab.businessobject.StructuredInstanceSpace;

public abstract class BusinessObjectKey
implements IBusinessObjectKey {
    static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Object[] keyValues1 = this.getPropertyValues();
        Object[] keyValues2 = ((BusinessObjectKey)object).getPropertyValues();
        if (keyValues1 == null || keyValues2 == null || keyValues1.length != keyValues2.length) {
            return keyValues1 == keyValues2;
        }
        int index = 0;
        while (index < keyValues1.length) {
            Object keyValue1 = keyValues1[index];
            Object keyValue2 = keyValues2[index];
            if (keyValue1 == null || keyValue2 == null ? keyValue1 != keyValue2 : !keyValue1.equals(keyValue2)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected String getPropertyString() {
        StringBuffer buffer = new StringBuffer();
        Object[] keyValues = this.getPropertyValues();
        if (keyValues != null) {
            int index = 0;
            while (index < keyValues.length) {
                Object keyValue = keyValues[index];
                if (keyValue == null) {
                    buffer.append("null");
                } else {
                    buffer.append(keyValue);
                }
                if (index < keyValues.length - 1) {
                    buffer.append(" ,");
                }
                ++index;
            }
        }
        return buffer.toString();
    }

    protected abstract Object[] getPropertyValues();

    public final synchronized IBusinessObject getTarget(boolean registerIfNotFound) {
        IInstanceSpace instanceSpace;
        IInstanceSpace iInstanceSpace = instanceSpace = InstanceSpaceHolder.GlobalInstanceSpace == null ? (InstanceSpaceHolder.GlobalInstanceSpace = new StructuredInstanceSpace()) : InstanceSpaceHolder.GlobalInstanceSpace;
        synchronized (iInstanceSpace) {
            try {
                BusinessObject searchObject = (BusinessObject)this.getTargetClass().newInstance();
                searchObject.setKey(this);
                BusinessObject foundObject = (BusinessObject)instanceSpace.getInstance(searchObject);
                if (foundObject == null && registerIfNotFound) {
                    searchObject.setKey((IBusinessObjectKey)this.clone());
                    instanceSpace.addInstance(searchObject);
                    return searchObject;
                }
                return foundObject;
            }
            catch (Throwable e) {
                System.err.println(e.toString());
                return null;
            }
        }
    }

    public final Class getTargetClass() throws ClassNotFoundException {
        try {
            String keyClassName = this.getClass().getName();
            String keyClassIdentifier = keyClassName.substring(keyClassName.length() - 3, keyClassName.length());
            if (keyClassIdentifier.equals("Key")) {
                String boClassName = keyClassName.substring(0, keyClassName.length() - 3);
                ClassLoader loader = this.getClass().getClassLoader();
                Class<?> boClass = null;
                if (loader != null) {
                    boClass = loader.loadClass(boClassName);
                }
                if (boClass == null) {
                    boClass = Class.forName(boClassName);
                }
                if (boClass == null) {
                    throw new ClassNotFoundException(boClassName);
                }
                return boClass;
            }
            throw new ClassNotFoundException();
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassNotFoundException(e.toString());
        }
    }

    public final int hashCode() {
        int result = 0;
        Object[] keyValues = this.getPropertyValues();
        if (keyValues != null) {
            int index = 0;
            while (index < keyValues.length) {
                Object keyValue = keyValues[index];
                if (keyValue != null) {
                    result ^= keyValue.hashCode();
                }
                ++index;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append(" [");
        buffer.append(this.getPropertyString());
        buffer.append("]");
        return buffer.toString();
    }
}

