/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.util;

import com.ibm.ivj.eab.util.SetEntry;
import com.ibm.ivj.eab.util.SetEnumerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;

public class Set
implements Cloneable,
Serializable {
    static final String copyright = "(c) Copyright IBM Corporation 1998.";
    static final long serialVersionUID = -6551844220036340951L;
    private transient SetEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public Set() {
        this(101);
    }

    public Set(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Set(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new SetEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public synchronized Object add(Object element) throws NullPointerException {
        if (element == null) {
            throw new NullPointerException();
        }
        int hash = element.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        SetEntry entry = this.table[index];
        while (entry != null) {
            if (entry.hash == hash && entry.element.equals(element)) {
                return entry.element;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.add(element);
        }
        entry = new SetEntry();
        entry.hash = hash;
        entry.element = element;
        entry.next = this.table[index];
        this.table[index] = entry;
        ++this.count;
        return element;
    }

    public synchronized void clear() {
        int index = this.table.length;
        while (--index >= 0) {
            this.table[index] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            Set result = (Set)super.clone();
            result.table = new SetEntry[this.table.length];
            int index = this.table.length;
            while (index-- > 0) {
                SetEntry setEntry = result.table[index] = this.table[index] != null ? (SetEntry)this.table[index].clone() : null;
            }
            return result;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized boolean contains(Object element) {
        int hash = element.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        SetEntry entry = this.table[index];
        while (entry != null) {
            if (entry.hash == hash && entry.element.equals(element)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        return new SetEnumerator(this.table);
    }

    public synchronized Object get(Object element) {
        int hash = element.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        SetEntry entry = this.table[index];
        while (entry != null) {
            if (entry.hash == hash && entry.element.equals(element)) {
                return entry.element;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int count = s.readInt();
        this.table = new SetEntry[s.readInt()];
        this.threshold = s.readInt();
        this.loadFactor = s.readFloat();
        int index = 0;
        while (index < count) {
            this.add(s.readObject());
            ++index;
        }
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        SetEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        SetEntry[] newTable = new SetEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            SetEntry old = oldTable[i];
            while (old != null) {
                SetEntry entry = old;
                old = old.next;
                int index = (entry.hash & Integer.MAX_VALUE) % newCapacity;
                entry.next = newTable[index];
                newTable[index] = entry;
            }
        }
    }

    public synchronized Object remove(Object element) {
        int hash = element.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        SetEntry entry = this.table[index];
        SetEntry prev = null;
        while (entry != null) {
            if (entry.hash == hash && entry.element.equals(element)) {
                if (prev != null) {
                    prev.next = entry.next;
                } else {
                    this.table[index] = entry.next;
                }
                --this.count;
                return entry.element;
            }
            prev = entry;
            entry = entry.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buffer = new StringBuffer();
        Enumeration elements = this.elements();
        buffer.append("{");
        int index = 0;
        while (index <= max) {
            buffer.append(elements.nextElement().toString());
            if (index < max) {
                buffer.append(", ");
            }
            ++index;
        }
        buffer.append("}");
        return buffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.count);
        s.writeInt(this.table.length);
        s.writeInt(this.threshold);
        s.writeFloat(this.loadFactor);
        Enumeration elements = this.elements();
        while (elements.hasMoreElements()) {
            s.writeObject(elements.nextElement());
        }
    }
}

