/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector.imstoc;

import com.ibm.connector.imstoc.IMSAPIStateResource;
import com.ibm.connector.imstoc.IMSInteractionSpec;
import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.connector.internal.BadInvOrderException;
import com.ibm.connector.internal.ResourceException;
import java.io.PrintWriter;

public class IMSAPIState {
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    public static final int CONNECT_STATE = 0;
    public static final int SEND_STATE = 1;
    public static final int RECEIVE_STATE = 2;
    public static final int CONFIRM_STATE = 3;
    public static final int CONVERSATION_STATE = 4;
    public static final int CONFIRM_CONVERSATION_STATE = 5;
    static final String[] _stateText = new String[]{"CONNECT_STATE", "SEND_STATE", "RECEIVE_STATE", "CONFIRM_STATE", "CONVERSATION_STATE", "CONFIRM_CONVERSATION_STATE"};
    static final int NUM_OF_STATES = 6;
    private int _state = 0;
    private int _inCommitMode = 1;
    private boolean _isInConversation = false;
    private boolean _isInResponse = false;
    private IMSAPIStateResource _res = new IMSAPIStateResource();

    public int getInCommitMode() {
        String methodName = String.valueOf(super.toString()) + ".getInCommitMode()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._inCommitMode;
    }

    public int getState() {
        String methodName = String.valueOf(super.toString()) + ".getState()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._state;
    }

    public String getStateAsText() {
        if (this._state < 0 || this._state >= 6) {
            return "INVALID_STATE: " + this._state;
        }
        return _stateText[this._state];
    }

    public boolean isInConversation() {
        String methodName = String.valueOf(super.toString()) + ".isInConversation()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._isInConversation;
    }

    public boolean isInResponse() {
        String methodName = String.valueOf(super.toString()) + ".isInResponse()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        return this._isInResponse;
    }

    public void resetState() {
        String methodName = String.valueOf(super.toString()) + ".resetState()";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        this._state = 0;
        if (rasService.getTraceLevel() >= 3) {
            rasService.logTraceInfo("IMSAPIState.resetState(): Reset state to CONNECT_STATE.");
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setInCommitMode(int commitMode) {
        String methodName = String.valueOf(super.toString()) + ".setInCommitMode(int)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        this._inCommitMode = commitMode;
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setIsInConversation(boolean conv) {
        String methodName = String.valueOf(super.toString()) + ".setIsInConversation(boolean)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        this._isInConversation = conv;
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setIsInResponse(boolean resp) {
        String methodName = String.valueOf(super.toString()) + ".setIsInResponse(boolean)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        this._isInResponse = resp;
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setState(int newState) {
        String methodName = String.valueOf(super.toString()) + ".setState(int)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        this._state = newState;
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public void setVerifyState(int mode) throws BadInvOrderException {
        String methodName = String.valueOf(super.toString()) + ".setVerifyState(int)";
        this.getStateAsText();
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("->  [" + methodName + "]");
        }
        switch (this._state) {
            case 0: {
                if (mode == 1) {
                    this._state = 1;
                    break;
                }
                String errMsg = this._res.getString("0001E", new Object[]{methodName, IMSInteractionSpec.getModeText(mode), this.getStateAsText()});
                BadInvOrderException e = new BadInvOrderException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
            case 1: {
                if (mode == 1) {
                    this._state = 2;
                    break;
                }
                if (mode == 3) {
                    this._state = 1;
                    break;
                }
                if (mode == 7) {
                    this._state = 2;
                    break;
                }
                String errMsg = this._res.getString("0001E", new Object[]{methodName, IMSInteractionSpec.getModeText(mode), this.getStateAsText()});
                BadInvOrderException e = new BadInvOrderException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
            case 2: {
                if (mode == 2) {
                    if (this._isInConversation && this._isInResponse) {
                        this._state = 5;
                        break;
                    }
                    if (this._isInConversation) {
                        this._state = 4;
                        break;
                    }
                    if (this._isInResponse) {
                        this._state = 3;
                        break;
                    }
                    if (this._inCommitMode == 0) {
                        this._state = 2;
                        break;
                    }
                    this._state = 1;
                    break;
                }
                String errMsg = this._res.getString("0001E", new Object[]{methodName, IMSInteractionSpec.getModeText(mode), this.getStateAsText()});
                BadInvOrderException e = new BadInvOrderException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
            case 3: {
                if (mode == 4 || mode == 5) {
                    this._state = 2;
                    break;
                }
                String errMsg = this._res.getString("0001E", new Object[]{methodName, IMSInteractionSpec.getModeText(mode), this.getStateAsText()});
                BadInvOrderException e = new BadInvOrderException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
            case 4: {
                if (mode == 1) {
                    this._state = 2;
                    break;
                }
                if (mode == 6) {
                    this._state = 1;
                    break;
                }
                String errMsg = this._res.getString("0001E", new Object[]{methodName, IMSInteractionSpec.getModeText(mode), this.getStateAsText()});
                BadInvOrderException e = new BadInvOrderException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
            case 5: {
                if (mode == 4) {
                    this._state = 4;
                    break;
                }
                if (mode == 5) {
                    this._state = 2;
                    break;
                }
                String errMsg = this._res.getString("0001E", new Object[]{methodName, IMSInteractionSpec.getModeText(mode), this.getStateAsText()});
                BadInvOrderException e = new BadInvOrderException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
            default: {
                String errMsg = this._res.getString("0002E", new Object[]{methodName, new Integer(this._state)});
                ResourceException e = new ResourceException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
        }
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-  [" + methodName + "]");
        }
    }

    public String toString() {
        return "\t[" + super.toString() + "]" + "\n\t\t\t\t\tstate: [" + this._state + "]" + "\n\t\t\t\t\tinConversation: [" + this._isInConversation + "]" + "\n\t\t\t\t\tinResponse: [" + this._isInResponse + "]" + "\n\t\t\t\t\tinCommitMode: [" + this._inCommitMode + "]";
    }

    public void validateMode(int mode) throws BadInvOrderException {
        String methodName = String.valueOf(super.toString()) + ".validateMode(int)";
        RASService rasService = RuntimeContext.getCurrent().getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<->  [" + methodName + "]");
        }
        switch (this._state) {
            case 0: {
                if (mode != 1) break;
                return;
            }
            case 1: {
                if (mode != 1 && mode != 0 && mode != 3 && mode != 7) break;
                return;
            }
            case 2: {
                if (mode != 2) break;
                return;
            }
            case 3: {
                if (mode != 4 && mode != 5) break;
                return;
            }
            case 4: {
                if (mode != 1 && mode != 0 && mode != 6) break;
                return;
            }
            case 5: {
                if (mode != 4 && mode != 5) break;
                return;
            }
            default: {
                String errMsg = this._res.getString("0002E", new Object[]{methodName, new Integer(this._state)});
                ResourceException e = new ResourceException(errMsg);
                if (rasService.getTraceLevel() >= 2) {
                    PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
                    rasService.logTraceInfo(e.toString());
                    e.printStackTrace(printTraceWriter);
                }
                PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                rasService.logError(e.toString());
                e.printStackTrace(printErrorWriter);
                throw e;
            }
        }
        String errMsg = this._res.getString("0001E", new Object[]{methodName, IMSInteractionSpec.getModeText(mode), this.getStateAsText()});
        BadInvOrderException e = new BadInvOrderException(errMsg);
        if (rasService.getTraceLevel() >= 2) {
            PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream());
            rasService.logTraceInfo(e.toString());
            e.printStackTrace(printTraceWriter);
        }
        PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
        rasService.logError(e.toString());
        e.printStackTrace(printErrorWriter);
        throw e;
    }
}

