/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.imstoc;

import com.ibm.connector.infrastructure.RASService;
import com.ibm.connector.infrastructure.RuntimeContext;
import com.ibm.imstoc.IMSConverterResource;
import com.ibm.imstoc.IMSException;
import com.ibm.imstoc.IMSLanguage;
import com.ibm.imstoc.IMSSupportedLanguages;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public class IMSConverter {
    public static final byte EBCDIC_SO = 14;
    public static final byte EBCDIC_SI = 15;
    private static String copyrights = "Licensed Material - Property of IBM IBM IMS TCP/IP OTMA Connection Connector for Java, Version 1, Release 1. (C) Copyright IBM Corp. 1998.  All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. ";
    private IMSLanguage _userDataLanguage;
    private IMSSupportedLanguages _languages;
    protected RuntimeContext _RuntimeContext = RuntimeContext.getCurrent();
    private IMSConverterResource _resBundle = new IMSConverterResource();

    public IMSConverter(String charEncode) {
        this._RuntimeContext = RuntimeContext.getCurrent();
        IMSLanguage aLangObj = null;
        this._userDataLanguage = null;
        if (charEncode != null) {
            this._languages = new IMSSupportedLanguages();
            Enumeration e = this._languages.elements();
            while (e.hasMoreElements()) {
                aLangObj = (IMSLanguage)e.nextElement();
                if (!charEncode.equalsIgnoreCase(aLangObj.getCharEncoding())) continue;
                this._userDataLanguage = new IMSLanguage(aLangObj.getCharEncoding(), aLangObj.getDescription(), aLangObj.getIsDBCSLanguage());
            }
        }
    }

    public byte[] getBytes(String aString, boolean isPureDBCS) throws UnsupportedEncodingException {
        byte[] byteArray = null;
        byte[] newByteArray = null;
        String charEncoding = null;
        boolean isDBCS = false;
        String methodName = String.valueOf(super.toString()) + ".getBytes(String, boolean)";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        charEncoding = this._userDataLanguage.getCharEncoding();
        isDBCS = this._userDataLanguage.getIsDBCSLanguage();
        if (isDBCS) {
            if (isPureDBCS) {
                byteArray = aString.getBytes(charEncoding);
                newByteArray = new byte[byteArray.length - 2];
                int i = 0;
                while (i < byteArray.length - 2) {
                    newByteArray[i] = byteArray[i + 1];
                    ++i;
                }
            } else {
                newByteArray = aString.getBytes(charEncoding);
            }
        } else {
            newByteArray = aString.getBytes(charEncoding);
        }
        return newByteArray;
    }

    public IMSLanguage getConverterLanguage() {
        String methodName = String.valueOf(super.toString()) + ".getConverterLanguage()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        return this._userDataLanguage;
    }

    public String getString(byte[] aByteArray, boolean isPureDBCS) throws IMSException, UnsupportedEncodingException {
        String newUnicodeString = null;
        byte[] newByteArray = null;
        String charEncoding = null;
        boolean isDBCS = false;
        int aLength = 0;
        String methodName = String.valueOf(super.toString()) + ".getString(byte[], boolean)";
        RASService rasService = this._RuntimeContext.getRASService();
        if (rasService.getTraceLevel() >= 2) {
            rasService.logTraceInfo("<-> [" + methodName + "]");
        }
        if (aByteArray != null) {
            charEncoding = this._userDataLanguage.getCharEncoding();
            isDBCS = this._userDataLanguage.getIsDBCSLanguage();
            if (isDBCS) {
                if (isPureDBCS) {
                    int i;
                    aLength = aByteArray.length;
                    if (aLength % 2 == 0) {
                        newByteArray = new byte[aLength + 2];
                        newByteArray[0] = 14;
                        i = 0;
                        while (i < aLength) {
                            newByteArray[i + 1] = aByteArray[i];
                            ++i;
                        }
                    } else {
                        String errMsg = this._resBundle.getString("0001E", new Object[]{methodName});
                        IMSException imsException = new IMSException(errMsg);
                        if (rasService.getTraceLevel() >= 2) {
                            PrintWriter printTraceWriter = new PrintWriter(rasService.getTraceStream(), true);
                            rasService.logTraceInfo(imsException.toString());
                            imsException.printStackTrace(printTraceWriter);
                        }
                        PrintWriter printErrorWriter = new PrintWriter(rasService.getErrorStream(), true);
                        rasService.logError(imsException.toString());
                        imsException.printStackTrace(printErrorWriter);
                        throw imsException;
                    }
                    newByteArray[aLength + 1] = 15;
                    newUnicodeString = new String(newByteArray, charEncoding);
                    newByteArray = new byte[aLength + 2];
                    newByteArray[0] = 14;
                    i = 0;
                    while (i < aLength) {
                        newByteArray[i + 1] = aByteArray[i];
                        ++i;
                    }
                    newByteArray[aLength + 1] = 15;
                    newUnicodeString = new String(newByteArray, charEncoding);
                } else {
                    newUnicodeString = new String(aByteArray, charEncoding);
                }
            } else {
                newUnicodeString = new String(aByteArray, charEncoding);
            }
        }
        return newUnicodeString;
    }

    public String toString() {
        String methodName = String.valueOf(super.toString()) + ".toString()";
        if (this._RuntimeContext.getRASService().getTraceLevel() >= 2) {
            this._RuntimeContext.getRASService().logTraceInfo("<-> [" + methodName + "]");
        }
        return "\nuserDataLanguage" + this._userDataLanguage + "\nSupported Languages" + this._languages + "  ";
    }
}

