package com.ibm.servlet.smalltalk.examples.atm;

/**
 * This type was created in VisualAge.
 */
 import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import rbi.rmi.samples.atm.*;
public class CardVerificationServlet extends javax.servlet.http.HttpServlet {
/**
 * CardVerificationServlet constructor comment.
 */
public CardVerificationServlet() {
	super();
}
/**
 * This method was created in VisualAge.
 * @param request HttpServletRequest
 * @param response HttpServletResponse
 */
public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	performTask(request, response);
}
/**
 * This method was created in VisualAge.
 * @param request HttpServletRequest
 * @param response HttpServletResponse
 */
public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	performTask(request, response);
}
/**
 * This method was created in VisualAge.
 * @param request javax.servlet.http.HttpServletRequest
 * @param parameterName java.lang.String
 * @param checkRequestParameters boolean
 * @param checkInitParameters boolean
 * @param isParameterRequired boolean
 * @param defaultValue java.lang.String
 */
public java.lang.String getParameter(javax.servlet.http.HttpServletRequest request, java.lang.String parameterName, boolean checkRequestParameters, boolean checkInitParameters, boolean isParameterRequired, java.lang.String defaultValue) throws  java.lang.Exception {
	java.lang.String[] parameterValues = null;
		java.lang.String paramValue = null;

		// Get the parameter from the request object if necessary.
		if (checkRequestParameters)
		{
			parameterValues = request.getParameterValues(parameterName);

			if (parameterValues != null)
				paramValue = parameterValues[0];
		}

		// Get the parameter from the servlet init parameters if
		// it was not in the request parameter.
		if ( (checkInitParameters) && (paramValue == null) )
			paramValue = getServletConfig().getInitParameter(parameterName);

		// Throw an exception if the parameter was not found and it was required.
		// The exception will be caught by error processing and can be
		// displayed in the error page.
		if ( (isParameterRequired) && (paramValue == null) )
			throw new Exception("Parameter" + parameterName + "was not specified.");

		// Set the return to the default value if the parameter was not found
		if (paramValue == null)
			paramValue = defaultValue;

		return paramValue;
}
/**
 * This method was created in VisualAge.
 * @param request javax.servlet.http.HttpServletRequest
 * @param response javax.servlet.http.HttpServletResponse
 */
public void performTask(HttpServletRequest request, HttpServletResponse response) {
	try {
		// If the user pushed the Cancel button, re-display the previous page
		if (getParameter(request, "CancelButton", true, true, false, null) != null) {
			((com.sun.server.http.HttpServiceResponse) response).callPage("/ATM/BeginAtm.jsp", request);
		} else {
			ATMCard atmCard = null;
			ATMServerIf atmServer = null;
			java.util.Vector accounts = null;

			// Get the session data
			javax.servlet.http.HttpSession session = request.getSession(true);
			atmCard = (rbi.rmi.samples.atm.ATMCard) session.getValue("ATMCard");
			if (atmCard == null) {

				//	Instantiate the ATMCard bean 
				atmCard =  new ATMCard();

				// Store the ATMCard bean in the session data
				session.putValue("ATMCard", atmCard);
			};

			// Initialize the CardNumber bean from the parameters
			atmCard.setCardNumber(getParameter(request, "CardNumberField", true, true, true, null));

			// Initialize the PIN bean from the parameters
			atmCard.setPin(getParameter(request, "PINField", true, true, true, null));

			// Get the remote reference to the Smalltalk ATMServer.  If its not defined, look up the ATMServer
			// in the RMI registry and store it in the session data. 
			atmServer = (rbi.rmi.samples.atm.ATMServerIf) session.getValue("ATMServer");
			if (atmServer == null) {
				atmServer = (rbi.rmi.samples.atm.ATMServerIf) java.rmi.Naming.lookup("/ATMServer");
				session.putValue("ATMServer", atmServer);
			}
			try {
				// Get the list of bank accounts accessible by the atmCard and store them in the session data.
				accounts = atmServer.verifyCardAndGetAccountNumbers(atmCard);
				session.putValue("Accounts", accounts);
				
				// Clear the Message bean.
			 	((com.sun.server.http.HttpServiceRequest) request).setAttribute("Message", "");

			 	// Display the account and transaction jsp.
				((com.sun.server.http.HttpServiceResponse) response).callPage("/ATM/Selection.jsp", request);
				
			} catch (CardValidationException cardException) {
				
				// Card validation failed. Store the error information in the Message bean and re-display the 
				// CardInput jsp. 
			 	((com.sun.server.http.HttpServiceRequest) request).setAttribute("Message", "Your card could not be validated - " + cardException.getMessage());
				((com.sun.server.http.HttpServiceResponse) response).callPage("/ATM/CardInput.jsp", request);
			}
		}
	} catch (Exception e) {
		System.out.println("Error message" + e);
	}
}
}