package com.ibm.servlet.smalltalk.examples.atm;

/**
 * This type was created in VisualAge.
 */
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import rbi.rmi.samples.atm.*;
public class ProcessSelectionServlet extends javax.servlet.http.HttpServlet {
/**
 * ProcessSelectionServlet constructor comment.
 */
public ProcessSelectionServlet() {
	super();
}
/**
 * This method was created in VisualAge.
 * @param request HttpServletRequest
 * @param response HttpServletResponse
 */
public void doGet(HttpServletRequest request, HttpServletResponse response)  throws ServletException, IOException {
	performTask(request, response);
}
/**
 * This method was created in VisualAge.
 * @param request javax.servlet.http.HttpServletRequest
 * @param response javax.servlet.http.HttpServletResponse
 */
public void doPost(HttpServletRequest request, HttpServletResponse response)  throws ServletException, IOException {
	performTask(request, response);
}
/**
 * This method was created in VisualAge.
 * @param request javax.servlet.http.HttpServletRequest
 * @param parameterName java.lang.String
 * @param checkRequestParameters boolean
 * @param checkInitParameters boolean
 * @param isParameterRequired boolean
 * @param defaultValue java.lang.String
 */
public java.lang.String getParameter(javax.servlet.http.HttpServletRequest request, java.lang.String parameterName, boolean checkRequestParameters, boolean checkInitParameters, boolean isParameterRequired, java.lang.String defaultValue) throws  java.lang.Exception {
	java.lang.String[] parameterValues = null;
		java.lang.String paramValue = null;

		// Get the parameter from the request object if necessary.
		if (checkRequestParameters)
		{
			parameterValues = request.getParameterValues(parameterName);

			if (parameterValues != null)
				paramValue = parameterValues[0];
		}

		// Get the parameter from the servlet init parameters if
		// it was not in the request parameter.
		if ( (checkInitParameters) && (paramValue == null) )
			paramValue = getServletConfig().getInitParameter(parameterName);

		// Throw an exception if the parameter was not found and it was required.
		// The exception will be caught by error processing and can be
		// displayed in the error page.
		if ( (isParameterRequired) && (paramValue == null) )
			throw new Exception("Parameter" + parameterName + "was not specified.");

		// Set the return to the default value if the parameter was not found
		if (paramValue == null)
			paramValue = defaultValue;

		return paramValue;
}
/**
 * This method was created in VisualAge.
 * @param request javax.servlet.http.HttpServletRequest
 * @param response javax.servlet.http.HttpServletResponse
 */
public void performTask(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	try {
		// If the user pushed the Cancel button, re-display the previous page
		if (getParameter(request, "CancelButton.x", true, true, false, null) != null) {
			// Set the Message bean.
		 	((com.sun.server.http.HttpServiceRequest) request).setAttribute("Message", "");
			((com.sun.server.http.HttpServiceResponse) response).callPage("/ATM/CardInput.jsp", request);
		} else {
			String accountNumber = this.getParameter(request, "AccountSelectionList", true, true, false, null);
			if (accountNumber != null) {
				// Get the session data
				javax.servlet.http.HttpSession session = request.getSession(true);

				// Get the remote reference to the Smalltalk ATMServer 
				ATMServerIf atmServer = (rbi.rmi.samples.atm.ATMServerIf) session.getValue("ATMServer");

				// Call the ATMServer to get the selected bank account.  This causes the ATMServer to export the
				// BankAccount object associated with the selected bank account.
				atmServer.getBankAccount(accountNumber);

				// Look up the BankAccount object in the RMI registry
				BankAccountIf bankAccount = (rbi.rmi.samples.atm.BankAccountIf) java.rmi.Naming.lookup(accountNumber);
				session.putValue(accountNumber, bankAccount);

				// Store the AccountNumber bean in the session data
				session.putValue("AccountNumber", accountNumber);

				// Store the remote reference to the BankAccount object in the session data.  Any called page (jsp)
				// that references the BankAccount bean will get the bean's properties from Smalltalk.
				session.putValue("BankAccount", bankAccount);

				// Display the WithdrawTransaction jsp.
				if (getParameter(request, "WithdrawButton.x", true, true, false, null) != null) {
					((com.sun.server.http.HttpServiceResponse) response).callPage("/ATM/WithdrawTransaction.jsp", request);
				}
			} else {

				// The user failed to select an account.  Set the Message bean and re-display the Selection jsp.
			 	((com.sun.server.http.HttpServiceRequest) request).setAttribute("Message", "You must select an account");
				((com.sun.server.http.HttpServiceResponse) response).callPage("/ATM/Selection.jsp", request);
			}
		}
	} catch (Exception e) {
		System.out.println("Error message" + e);
	}
}
}