package rbi.rmi.samples.atm;

import java.rmi.*;
import java.util.*;
/**
 * This type was created in VisualAge.
 */
public class ATMServerProxy {
	ATMServerIf atmServer = null;
	protected transient rbi.rmi.samples.atm.ValidCardListener aValidCardListener = null;
	protected transient java.beans.PropertyChangeSupport propertyChange;
	private Vector fieldAccountNumbers = new Vector(); 
	private String fieldLastError = new String();
	private BankAccountProxy fieldBankAccountProxy;
	protected transient rbi.rmi.samples.atm.AccountRegisteredListener aAccountRegisteredListener = null;
	private String fieldHostName = new String();
	private Hashtable registeredAccounts = new Hashtable();
	private String fieldNamingServicePort = new String();
/**
 * ATMServerProxy constructor comment.
 */
public ATMServerProxy() {
	super();
}
/**
 * 
 * @param newListener rbi.rmi.samples.atm.AccountRegisteredListener
 */
public void addAccountRegisteredListener(rbi.rmi.samples.atm.AccountRegisteredListener newListener) {
	aAccountRegisteredListener = rbi.rmi.samples.atm.AccountRegisteredEventMulticaster.add(aAccountRegisteredListener, newListener);
	return;
}
/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}
/**
 * 
 * @param newListener rbi.rmi.samples.atm.ValidCardListener
 */
public void addValidCardListener(rbi.rmi.samples.atm.ValidCardListener newListener) {
	aValidCardListener = rbi.rmi.samples.atm.ValidCardEventMulticaster.add(aValidCardListener, newListener);
	return;
}
/**
 * Method to support listener events.
 * @param event rbi.rmi.samples.atm.AccountRegisteredEvent
 */
protected void fireProcessAccountRegistered(rbi.rmi.samples.atm.AccountRegisteredEvent event) {
	if (aAccountRegisteredListener == null) {
		return;
	};
	aAccountRegisteredListener.processAccountRegistered(event);
}
/**
 * Method to support listener events.
 * @param event rbi.rmi.samples.atm.ValidCardEvent
 */
protected void fireProcessValidCard(rbi.rmi.samples.atm.ValidCardEvent event) {
	if (aValidCardListener == null) {
		return;
	};
	aValidCardListener.processValidCard(event);
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * Gets the accountNumbers property (java.util.Vector) value.
 * @return The accountNumbers property value.
 * @see #setAccountNumbers
 */
public Vector getAccountNumbers() {
	return fieldAccountNumbers;
}
/**
 * This method was created in VisualAge.
 * @return rbi.rmi.samples.atm.ATMServerIf
 */
public ATMServerIf getAtmServer() {
	if (atmServer == null) {
		try {
			atmServer = (ATMServerIf) Naming.lookup(getUrl() + "/ATMServer");
		} catch (Exception e) {
			setLastError("ATM Server unavailable " + e);
		}
	}
	return atmServer;
}
/**
 * Perform the getBankAccount method.
 * @param accountNumber java.lang.String
 */
public void getBankAccount(String accountNumber) {
	if (getRegisteredAccounts().containsKey(accountNumber)) {
		setBankAccountProxy((BankAccountProxy) getRegisteredAccounts().get(accountNumber));
		fireProcessAccountRegistered(new AccountRegisteredEvent(this));
	} else
		try {
		getAtmServer().getBankAccount(accountNumber);
		BankAccountProxy bp = new BankAccountProxy();
		bp.setAccountNumber(accountNumber);
		bp.setAtmServer(this);
		setBankAccountProxy(bp);
		getRegisteredAccounts().put(accountNumber, bp);
		fireProcessAccountRegistered(new AccountRegisteredEvent(this));
	} catch (RemoteException e) {
		setLastError("ATM Error Encountered " + e);
	}
	return;
}
/**
 * Gets the bankAccountProxy property (rbi.rmi.samples.atm.BankAccountProxy) value.
 * @return The bankAccountProxy property value.
 * @see #setBankAccountProxy
 */
public BankAccountProxy getBankAccountProxy() {
	return fieldBankAccountProxy;
}
/**
 * Gets the hostName property (java.lang.String) value.
 * @return The hostName property value.
 * @see #setHostName
 */
public String getHostName() {
	return fieldHostName;
}
/**
 * Gets the lastError property (java.lang.String) value.
 * @return The lastError property value.
 * @see #setLastError
 */
public String getLastError() {
	return fieldLastError;
}
/**
 * Gets the namingServicePort property (java.lang.String) value.
 * @return The namingServicePort property value.
 * @see #setNamingServicePort
 */
public String getNamingServicePort() {
	return fieldNamingServicePort;
}
/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}
/**
 * This method was created in VisualAge.
 * @return java.util.Hashtable
 */
public Hashtable getRegisteredAccounts() {
	return registeredAccounts;
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String getUrl() {
	String url = "//" + getHostName();
	if (getNamingServicePort().length() > 0)
		url = url + ":" + getNamingServicePort();
	return url;
}
/**
 * 
 * @param newListener rbi.rmi.samples.atm.AccountRegisteredListener
 */
public void removeAccountRegisteredListener(rbi.rmi.samples.atm.AccountRegisteredListener newListener) {
	aAccountRegisteredListener = rbi.rmi.samples.atm.AccountRegisteredEventMulticaster.remove(aAccountRegisteredListener, newListener);
	return;
}
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}
/**
 * 
 * @param newListener rbi.rmi.samples.atm.ValidCardListener
 */
public void removeValidCardListener(rbi.rmi.samples.atm.ValidCardListener newListener) {
	aValidCardListener = rbi.rmi.samples.atm.ValidCardEventMulticaster.remove(aValidCardListener, newListener);
	return;
}
/**
 * Perform the restartAtm method.
 */
public void restartAtm() {
	try {
		getAtmServer().restartAtm();
	} catch (RemoteException e) {
		setLastError("ATM Error Encountered " + e);
		return;
	}
}
/**
 * Sets the accountNumbers property (java.util.Vector) value.
 * @param accountNumbers The new value for the property.
 * @see #getAccountNumbers
 */
public void setAccountNumbers(Vector accountNumbers) {
	Vector oldValue = fieldAccountNumbers;
	fieldAccountNumbers = accountNumbers;
	firePropertyChange("accountNumbers", oldValue, accountNumbers);
}
/**
 * This method was created in VisualAge.
 * @param aSever rbi.rmi.samples.atm.ATMServerIf
 */
public void setAtmServer(ATMServerIf anATMServer) {
	atmServer = anATMServer;
}
/**
 * Sets the bankAccountProxy property (rbi.rmi.samples.atm.BankAccountProxy) value.
 * @param bankAccountProxy The new value for the property.
 * @see #getBankAccountProxy
 */
public void setBankAccountProxy(BankAccountProxy bankAccountProxy) {
	BankAccountProxy oldValue = fieldBankAccountProxy;
	fieldBankAccountProxy = bankAccountProxy;
	firePropertyChange("bankAccountProxy", oldValue, bankAccountProxy);
}
/**
 * Sets the hostName property (java.lang.String) value.
 * @param hostName The new value for the property.
 * @see #getHostName
 */
public void setHostName(String hostName) {
	String oldValue = fieldHostName;
	fieldHostName = hostName;
	firePropertyChange("hostName", oldValue, hostName);
}
/**
 * Sets the lastError property (java.lang.String) value.
 * @param lastError The new value for the property.
 * @see #getLastError
 */
public void setLastError(String lastError) {
	String oldValue = fieldLastError;
	fieldLastError = lastError;
	firePropertyChange("lastError", oldValue, lastError);
}
/**
 * Sets the namingServicePort property (java.lang.String) value.
 * @param namingServicePort The new value for the property.
 * @see #getNamingServicePort
 */
public void setNamingServicePort(String namingServicePort) {
	String oldValue = fieldNamingServicePort;
	fieldNamingServicePort = namingServicePort;
	firePropertyChange("namingServicePort", oldValue, namingServicePort);
}
/**
 * This method was created in VisualAge.
 * @param aHashtable java.util.Hashtable
 */
public void setRegisteredAccounts(Hashtable aHashtable) {
	registeredAccounts = aHashtable;
}
/**
 * Perform the unregisterAllBankAccounts method.
 */
public void unregisterAllBankAccounts() {
	if (!(getRegisteredAccounts().isEmpty())) {
		if (getAtmServer() != null) {
			try {
				getAtmServer().unregisterAllBankAccounts();
				getRegisteredAccounts().clear();
			} catch (RemoteException e) {
				setLastError("ATM Error Encountered " + e);
			}
		}
	}
	return;
}
/**
 * This method was created in VisualAge.
 * @param anATMCard rbi.rmi.samples.atm.ATMCard
 */
public void verifyCardAndGetAccountNumbers(ATMCard anATMCard) {
	if (getAtmServer() != null) {
		try {
			setLastError("");
			setAccountNumbers(getAtmServer().verifyCardAndGetAccountNumbers(anATMCard));
			fireProcessValidCard(new ValidCardEvent(this));
		} catch (CardValidationException e) {
			setLastError(e.getMessage());
		} catch (RemoteException e) {
			setLastError("ATM Error Encountered " + e);
		}
	}
	return;
}
}