/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ulc.HttpServer;

import com.ibm.ulc.HttpServer.HttpServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.StringTokenizer;

class HttpConnection
implements Runnable {
    static final String HTMLINESEP = "\r\n";
    static final String FILESEP = System.getProperty("file.separator");
    private static final String INDEXFILE = "start.html";
    private static final String[] fgParseSuffixes = new String[]{".uhtml", ".ulc"};
    private Socket fSocket;
    private String fWebHost;
    private boolean fDebug;

    HttpConnection(Socket socket, HttpServer httpServer) {
        this.fSocket = socket;
        this.fDebug = httpServer.fDebug;
        InetAddress inetAddress = this.fSocket.getLocalAddress();
        this.fWebHost = inetAddress.getHostAddress();
        if (this.fDebug) {
            System.out.println("HttpConnection. fWebHost=" + this.fWebHost);
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public boolean fileShouldBeParsed(String string) {
        int n = 0;
        while (n < fgParseSuffixes.length) {
            if (string.endsWith(fgParseSuffixes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    String getMsg(int n) {
        switch (n) {
            case 200: {
                return "OK";
            }
            case 204: {
                return "OK, No Content";
            }
            case 301: {
                return "OK, Redirect";
            }
            case 404: {
                return "File Not Found";
            }
            case 501: {
                return "Not Implemented";
            }
        }
        return "Unknown Error";
    }

    public String guessContentTypeFromName(String string) {
        if (string.endsWith(".html") || string.endsWith(".htm") || string.endsWith(".uhtml")) {
            return "text/html";
        }
        if (string.endsWith(".txt") || string.endsWith(".java")) {
            return "text/plain";
        }
        if (string.endsWith(".gif")) {
            return "image/gif";
        }
        if (string.endsWith(".class") || string.endsWith(".zip") || string.endsWith(".jar")) {
            return "application/octet-stream";
        }
        if (string.endsWith(".jpg") || string.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (string.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (string.endsWith(".ulc")) {
            return "application/x-ulc";
        }
        return "text/plain";
    }

    public void run() {
        block28: {
            boolean bl = false;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.fSocket.getInputStream()));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.fSocket.getOutputStream());
                PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
                String string = bufferedReader.readLine();
                if (this.fDebug) {
                    System.out.println("HttpServer. got line: " + string);
                }
                if (string == null) {
                    return;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("GET")) {
                    block27: {
                        boolean bl2 = false;
                        boolean bl3 = false;
                        String string3 = null;
                        String string4 = stringTokenizer.nextToken();
                        while (stringTokenizer.hasMoreElements() && !string4.startsWith("HTTP/")) {
                            string3 = string3 == null ? string4 : String.valueOf(string3) + " " + string4;
                            string4 = stringTokenizer.nextToken();
                        }
                        if (string4.startsWith("HTTP/")) {
                            bl = true;
                        } else {
                            string3 = String.valueOf(string3) + " " + string4;
                        }
                        if (string3.endsWith("/")) {
                            string3 = String.valueOf(string3) + INDEXFILE;
                        }
                        if (this.fileShouldBeParsed(string3)) {
                            bl3 = true;
                        }
                        String string5 = this.guessContentTypeFromName(string3);
                        while ((string = bufferedReader.readLine()) != null) {
                            if (string.trim().equals("")) break;
                        }
                        InputStream inputStream = null;
                        try {
                            inputStream = HttpServer.getStreamFor(string3.substring(1, string3.length()));
                            if (inputStream != null) {
                                if (bl) {
                                    this.sendMimeHeader(printWriter, 200, string5, 0, true);
                                }
                                if (bl3) {
                                    BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream));
                                    String string6 = "$WEBHOST";
                                    String string7 = bufferedReader2.readLine();
                                    while (string7 != null) {
                                        StringBuffer stringBuffer = new StringBuffer();
                                        boolean bl4 = false;
                                        int n = 0;
                                        int n2 = string7.indexOf("$WEBHOST");
                                        while (n2 >= 0) {
                                            bl4 = true;
                                            stringBuffer.append(string7.substring(n, n2));
                                            stringBuffer.append(this.fWebHost);
                                            n = n2 += "$WEBHOST".length();
                                            n2 = string7.indexOf("$WEBHOST", n2 + 1);
                                        }
                                        if (bl4) {
                                            stringBuffer.append(string7.substring(n));
                                            printWriter.println(new String(stringBuffer));
                                        } else {
                                            printWriter.println(string7);
                                        }
                                        string7 = bufferedReader2.readLine();
                                    }
                                } else {
                                    printWriter.flush();
                                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                                    int n = 1000;
                                    byte[] byArray = new byte[1000];
                                    int n3 = 0;
                                    while (n3 != -1) {
                                        n3 = bufferedInputStream.read(byArray, 0, 1000);
                                        if (n3 <= 0) continue;
                                        bufferedOutputStream.write(byArray, 0, n3);
                                    }
                                    bufferedInputStream.close();
                                }
                                inputStream.close();
                            } else {
                                if (this.fDebug) {
                                    System.out.println("HttpServer. cannot find resource: " + string3.substring(1, string3.length()));
                                }
                                this.sendError(bl, printWriter, 404);
                            }
                        }
                        catch (IOException iOException) {
                            if (this.fDebug) {
                                System.out.println("HttpServer. IOException for resource: " + string3.substring(1, string3.length()));
                            }
                            this.sendError(bl, printWriter, 404);
                            if (inputStream == null) break block27;
                            inputStream.close();
                        }
                    }
                    printWriter.close();
                    break block28;
                }
                this.sendError(bl, printWriter, 501);
                printWriter.close();
            }
            catch (IOException iOException) {}
        }
        try {
            this.fSocket.close();
        }
        catch (IOException iOException) {}
    }

    void sendError(boolean bl, PrintWriter printWriter, int n) {
        if (bl) {
            this.sendMimeHeader(printWriter, n, "text/html", -1, false);
        }
        String string = this.getMsg(n);
        printWriter.println("<HTML><HEAD><TITLE>" + string + "</TITLE></HEAD>");
        printWriter.println("<BODY><H1>HTTP Error " + n + ": " + string + "</H1></BODY></HTML>");
    }

    void sendMimeHeader(PrintWriter printWriter, int n, String string, int n2, boolean bl) {
        this.sendMimeHeader(printWriter, n, string, n2, bl, null);
    }

    void sendMimeHeader(PrintWriter printWriter, int n, String string, int n2, boolean bl, String string2) {
        String string3 = this.getMsg(n);
        printWriter.print("HTTP/1.0 " + n + " " + string3 + HTMLINESEP);
        Date date = new Date();
        printWriter.print("Date: " + date + HTMLINESEP);
        printWriter.print("Server: ULC HttpServer 1.0\r\n");
        printWriter.print("Content-type: " + string + HTMLINESEP);
        if (n2 > 0) {
            printWriter.print("Content-length: " + n2 + HTMLINESEP);
        }
        if (string2 != null) {
            printWriter.print("Location: " + string2 + HTMLINESEP);
        }
        if (!bl) {
            printWriter.print("Cache-Control: no-cache\r\n");
        }
        printWriter.print(HTMLINESEP);
    }
}

