package com.ibm.ulc.AppController;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 *
 * A ULC application to provide basic desktop functionality
 * to clients (launching and connecting to ULC applications).
 */

import java.util.*;
import java.io.*;
import java.net.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.util.Anything;
public class AppController extends ULCContext {
	ULCShell fShell = null;
	ULCShell fLaunchShell = null;
	ULCApplication fApp = null;
	ULCTable fTable = null;
	ULCTable fLaunchTable = null;
	ULCAlert fAlert = null;
	public ULCIcon fRed;
	public ULCIcon fGreen;
	public ULCIcon fYellow;
	Applications fApplications = null;
	ApplicationDetails fApplicationDetails = null;
	DetailDisplay fDetailDisplay = null;
	int fSelection = -1;
	int fLaunchSelection = -1;
	String fLocalHost = null;
	static Vector fgControllers = new Vector();
	static String fgDefaultUrlString = null;
	static String fgDefaultHost = null;
	static String fgDefaultPort = null;
	static long fgConnectionId = 0;
	static boolean fgEnableJIT = true;
	static boolean fgEnableLaunching = false;
	static boolean fgHostColumn = false;
	static boolean fgEnablePropertiesReload = false;
	static final String APPCONTROLLERHOST = "UlcAppControllerHost";
	static final String APPDELIMITERS = ", ";
	static final String FILESEP = System.getProperty("file.separator");
	public AppController() {
		fApplications = new Applications();
		fApplicationDetails = new ApplicationDetails();
	}
/**
 * The UI has notified us that a connection has been added.
 */
protected void addedUIConnection(String host, int port, String url, String connId) {
	int index= -1;
	if (port == -1)
		index= fApplications.getAppIndex(url);	// IIOP Connection
	else
		index= fApplications.getAppIndex(host, port, url);
	if (index == -1)
		return;
	Application app= fApplications.getApp(index);
	if (app != null) {
		app.fConnectionId = connId;
		if (fApplications.setConnected(index, Application.CONNECTED)) { // changed
			if (fApplicationDetails.getAppIndex() == index) {
				fApplicationDetails.notify(FORM_MODEL_CHANGED, null);
			}
		}
	}
}
	public void connectApp() {
		connectAppAt(fSelection);
	}
	public void connectAppAt(int index) {
		Application app = fApplications.getApp(index);
		if (app != null) {
			if (app.fConnected == Application.NOT_CONNECTED) {
				connectToApp(getRealUrl(app), getRealUrl(app));
			}
			// turn indication to yellow
			if (fApplications.setConnected(index,Application.CONNECTION_IN_PROGRESS)) {   // changed
				if (fApplicationDetails.getAppIndex() == index) {
					fApplicationDetails.notify(FORM_MODEL_CHANGED,null);
				}
			}
		}
	}
public void connectionEnded(IConnection connection, UlcTransportException ex) {
	fgControllers.removeElement(this);
	super.connectionEnded(connection,ex);
}
public void connectionStarted(IConnection connection, UlcTransportException ex) {
	super.connectionStarted(connection,ex);
	fgControllers.addElement(this);
}
public ULCBox createButtons() {
	ULCBox buttons = new ULCHBox(15 /*gap*/);
	ULCBox hboxConnect = new ULCHBox(10 /*gap*/);
	final ULCButton connectButton = new ULCButton("Connect");
	connectButton.setEnabled(false);
	connectButton.setEnabler(fTable);
	connectButton.setToolTipText("Connect to selected application");
	connectButton.addActionListener(new ConnectAction(this));
	hboxConnect.add(connectButton);
	final ULCButton disconnectButton = new ULCButton("Disconnect");
	disconnectButton.setEnabled(false);
	disconnectButton.setEnabler(fTable);
	disconnectButton.setToolTipText("Disconnect from selected application");
	disconnectButton.addActionListener(new DisconnectAction(this));
	hboxConnect.add(disconnectButton);
	buttons.add(hboxConnect);
	return buttons;
}
public ULCMenuBar createMenuBar() {
	ULCMenuBar mb = new ULCMenuBar();
	ULCMenu file = new ULCMenu("File");
	file.setMnemonic('F');
	if (fgEnableLaunching)
		file.add(new ULCMenuItem("LaunchPanel...", new LaunchPanelAction(this)));
	if (fgEnablePropertiesReload)
		file.add(new ULCMenuItem("Reload Properties", new PropertyAction(this)));
	file.add(new ULCMenuItem("Quit", new QuitAction(this)));
	mb.add(file);
	ULCMenu edit = new ULCMenu("Edit");
	edit.setMnemonic('E');
	ULCMenuItem details = new ULCMenuItem("Details", new DetailAction(this));
	edit.add(details);
	details.setEnabled(false);
	details.setEnabler(fTable);
	mb.add(edit);
	return mb;
}
private ULCTable createTable() {
	int iconColWidth = 24;
	int connIconColWidth = 20;
	int appColWidth = 130;
	int hostColWidth = 120;
	int tableWidth = iconColWidth + connIconColWidth + appColWidth + 80;
	if (fgHostColumn)
		tableWidth += (2 * hostColWidth);
	ULCTable table = new ULCTable(fApplications, tableWidth, fApplications.getRowCount());
	table.setAutoResize(TABLE_AUTO_RESIZE_LAST_COLUMN);
	table.setRowHeight(24);
	table.addColumn("Icon", "", false, iconColWidth);
	table.addColumn("ConnectIcon", "", connIconColWidth);
	table.addColumn("Label", "Application", false, appColWidth);
	if (fgHostColumn) {
		table.addColumn("Host", "Host", false, hostColWidth);
		table.addColumn("URL", "Url", false, hostColWidth);
	}
	table.addSelectionChangedListener(new SelectAction(this));
	return table;
}
	public void disconnectApp() {
		disconnectAppAt(fSelection);
	}
	public void disconnectAppAt(int index) {
		Application app = fApplications.getApp(index);
		if (app != null) {
			if (app.fConnected != Application.NOT_CONNECTED) {
				disconnectFromApp(getRealUrl(app), app.fConnectionId);
			}
			if (app.fConnected == Application.CONNECTION_IN_PROGRESS)
				// turn indication from yellow to red if necessary
				if (fApplications.setConnected(index,Application.NOT_CONNECTED)) {   // changed
					if (fApplicationDetails.getAppIndex() == index) {
						fApplicationDetails.notify(FORM_MODEL_CHANGED,null);
					}
				}
		}
	}
	public void displayDetails() {
		displayDetailsAt(fSelection);
	}
	public void displayDetailsAt(int index) {
		fApplicationDetails.setApp(fApplications,index);
		if (fDetailDisplay == null) {
			fDetailDisplay = new DetailDisplay(fApplicationDetails,this,fgEnableLaunching);
			fApp.add(fDetailDisplay.getShell());
		}
		fDetailDisplay.show();
	}
public void displayLaunchPanel() {
	if (fLaunchShell == null) {
		// shell
		fLaunchShell = new ULCShell("AppController (launching)", false); // no CloseBox events

		/* Content */
		ULCBox vbox = new ULCVBox(10 /*gap*/);
		fLaunchShell.add(vbox);
		// launch table
		fLaunchTable = new ULCTable(fApplications, 450, fApplications.getRowCount());
		fLaunchTable.setAutoResize(TABLE_AUTO_RESIZE_LAST_COLUMN);
		fLaunchTable.addColumn("RunIcon", "Server", 60);
		fLaunchTable.addColumn("Label", "Application Name", false, 150);
		fLaunchTable.addColumn("Host", "Host", false, 100);
		fLaunchTable.addSelectionChangedListener(new LaunchSelectAction(this));
		vbox.add("ee", fLaunchTable);
		// buttons
		ULCBox launchButtons = new ULCHBox(15 /*gap*/);
		ULCBox hboxLaunch = new ULCHBox(10 /*gap*/);
		final ULCButton launchButton = new ULCButton("Launch Server");
		launchButton.setEnabled(false);
		launchButton.setEnabler(fLaunchTable);
		launchButton.setToolTipText("Launch server of selected application");
		launchButton.addActionListener(new LaunchAction(this));
		hboxLaunch.add(launchButton);
		final ULCButton killButton = new ULCButton("Kill Server");
		killButton.setEnabled(false);
		killButton.setEnabler(fLaunchTable);
		killButton.setToolTipText("Kill server of selected application");
		killButton.addActionListener(new KillAction(this));
		hboxLaunch.add(killButton);
		
		final ULCButton launchAllButton = new ULCButton("Launch All");
		launchAllButton.setToolTipText("Launch all servers");
		DefaultActionListener al = new DefaultActionListener() {
			public void actionPerformed(ULCActionEvent e) {
				launchAllServers();
			}
		};
		launchAllButton.addActionListener(al);
		
		
		final ULCButton killAllButton = new ULCButton("Kill All");
		launchAllButton.setToolTipText("Kill all servers");
		al = new DefaultActionListener() {
			public void actionPerformed(ULCActionEvent e) {
				killAllServers();
			}
		};
		killAllButton.addActionListener(al);
		hboxLaunch.add(launchAllButton);
		hboxLaunch.add(killAllButton);
		launchButtons.add(hboxLaunch);
		vbox.add("et", launchButtons);
		fApp.add(fLaunchShell);
	}
	fLaunchShell.setVisible(true);
}
	/**
	 * @return java.io.InputStream
	 * @param resource java.lang.String
	 */
	public static InputStream getAbsoluteResourceStream(String resource) {
		return AppController.class.getResourceAsStream("/" + resource);
	}
String getLocalHost() {
	if (fLocalHost == null) {
//			getConnection().getSocket().getLocalAddress().getHostAddress();
		String url= getConnection().getLocalUrlString();
		if (url != null)
			fLocalHost= UlcConnection.getHostFromUrlString(url);
		else
			UlcConnection.getLocalHost();
	}
	return fLocalHost;	
}
String getRealUrl(Application app) {
	String result = app.fUrlString;
	int ind = result.indexOf(APPCONTROLLERHOST);
	if (ind != -1) {
		app.fRealHost = getLocalHost();
		result =
			result.substring(0,ind)
			+ app.fRealHost
			+ result.substring(ind + APPCONTROLLERHOST.length());
	}
	return result;
}
/**
 * The UI has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("init")) {
		super.handleRequest(conn, request, args);
		addUIConnectionListener();
		return;
	}
	super.handleRequest(conn, request, args);
}
public static void killAllServers() {
	PropertyManager manager = PropertyManager.getManager();
	for (int i = 0; i < manager.getAppCount(); i++)
		killServerFor(i);
}
	public void killAppServer() {
		killAppServerAt(fLaunchSelection);
	}
	public void killAppServerAt(int index) {
		AppController.killServerFor(index);
	}
	public synchronized
	void killedAppServer(int index) {
		if (fApplications.setRunning(index,false)) {   // changed
			if (fApplicationDetails.getAppIndex() == index) {
				fApplicationDetails.notify(FORM_MODEL_CHANGED,null);
			}
		}
	}
	public static synchronized
	void killServerFor(int index) {
		PropertyManager manager = PropertyManager.getManager();
		synchronized(manager) {
			if (index < 0 || index >= manager.getAppCount())
				return;
			Application app = manager.getApps()[index];
			if (app == null)
				return;
			if (app.fProcess == null)
				return;
			app.fProcess.destroy();
			app.fServerRunning = false;
			app.fProcess = null;
			app.fStartTime = 0;
		}
		// notify all AppController instances
		for (Enumeration controllers = fgControllers.elements();
				controllers.hasMoreElements(); ) {
			((AppController) controllers.nextElement()).killedAppServer(index);
		}	
	}
public static void launchAllServers() {
	PropertyManager manager = PropertyManager.getManager();
	for (int i = 0; i < manager.getAppCount(); i++)
		launchServerFor(i);
}
	public void launchAppServer() {
		launchAppServerAt(fLaunchSelection);
	}
	public void launchAppServerAt(int index) {
		AppController.launchServerFor(index);
	}
	public synchronized
	void launchedAppServer(int index) {
		if (fApplications.setRunning(index,true)) {   // changed
			if (fApplicationDetails.getAppIndex() == index) {
				fApplicationDetails.notify(FORM_MODEL_CHANGED,null);
			}
		}
	}
	public static synchronized
	void launchServerFor(int index) {
		PropertyManager manager = PropertyManager.getManager();
		synchronized(manager) {
			if (index < 0 || index >= manager.getAppCount())
				return;
			Application app = manager.getApps()[index];
			if (app == null)
				return;
				
			// check if application's host is local machine
			String host = app.getHost();
			String localHostName = "localhost";
			String localIpAddr = "127.0.0.1";
			try {
				InetAddress localAddr = InetAddress.getLocalHost();
				localHostName = localAddr.getHostName();
				localIpAddr = localAddr.getHostAddress();
			} catch (UnknownHostException uhe) {
			}		
			if (!(host.equals("localhost") ||
					 host.equals("127.0.0.1") ||
					 host.equals(APPCONTROLLERHOST) ||
					 host.equals(localHostName) ||
					 host.equals(localIpAddr)))
				return;   // cannot start processes on other machines!
				
			if (app.fProcess != null) {
				try {
					int ev = app.fProcess.exitValue();
				} catch(IllegalThreadStateException itse) {
					// application is running
					return;
				}
				app.fServerRunning = false;
				app.fProcess = null;
				app.fStartTime = 0;
			}
			Process proc = null;
			try {
				if (app.fLanguage.equals("java"))
					proc = startJavaApp(app);
				if (app.fLanguage.equals("smalltalk"))
					proc = startSmalltalkApp(app);
			} catch (IOException e) {
				System.out.println("AppController.launchServerFor(): IOException. " + e);
				proc = null;
			}
			if (proc == null) {
				app.fServerRunning = false;
				app.fProcess = null;
				app.fStartTime = 0;
				return;
			}
			long startTime = System.currentTimeMillis();
			app.fProcess = proc;
			app.fStartTime = startTime;
			app.fServerRunning = true;
		}
		
		// notify all AppController instances
		for (Enumeration controllers = fgControllers.elements();
				controllers.hasMoreElements(); ) {
			((AppController) controllers.nextElement()).launchedAppServer(index);
		}	
	}
	public static
	void main(String args[]) {
		for (int i = 0; i < args.length; i++) {
			if (args[i].startsWith("-")) {
				if (args[i].equals("-nojit") ) {
					fgEnableJIT = false;
					continue;
				}
				if (args[i].equals("-launch") ) {
					fgEnableLaunching = true;
					continue;
				}
				if (args[i].equals("-hostcol") ) {
					fgHostColumn = true;
					continue;
				}
				if (args[i].equals("-expert") ) {
					fgEnableLaunching = true;
					fgHostColumn = true;
					fgEnablePropertiesReload = true;
					continue;
				}
				if (args[i].equals("-ipaddr")) {
					UlcConnection.fgIPAddr= true;
					continue;
				}
			}
		}
		fgDefaultHost = UlcConnection.getLocalHost();
		fgDefaultPort = "9999";
		fgDefaultUrlString = "http://" + fgDefaultHost + ":" + fgDefaultPort;
		if (PropertyManager.getManager().loadProperties())
			ULC.run(args,AppController.class);
	}
	private String nextClientData() {
		fgConnectionId++;
		return Long.toString(fgConnectionId);
	}
	public void quit() {
		if (fAlert == null)
			fAlert = new ULCAlert(fShell,"Please Confirm",
					"Do you really want to quit?","Yes","No");
		if (fAlert.ask().equals("Yes"))
			fApp.terminate();
	}
	public synchronized void reloadProperties() {
		PropertyManager manager = PropertyManager.getManager();
		Application[] oldApps = manager.getApps();
		int oldAppCount = manager.getAppCount();
		manager.loadProperties();
		if (oldApps != null) {
			// copy old process state to new apps
			Application[] newApps = manager.getApps();
			for (int i = 0; i < manager.getAppCount(); i++) {
				for (int j = 0; j < oldAppCount; j++) {
					if (oldApps[j].fLabel.equals(newApps[i].fLabel)) {
						newApps[i].fProcess = oldApps[j].fProcess;
						oldApps[j].fProcess = null;
						newApps[i].fServerRunning = oldApps[j].fServerRunning;
						newApps[i].fStartTime = oldApps[j].fStartTime;
					}
				}
			}
			// destroy remaining processes
			for (int i = 0; i < oldAppCount; i++) {
				if (oldApps[i].fProcess != null)
					oldApps[i].fProcess.destroy();
			}
		}
		fApplications.sync();
		fApplications.notify(TABLE_MODEL_CONTENTS_CHANGED,null,0,fApplications.getRowCount()-1);
		fApplicationDetails.notify(FORM_MODEL_CHANGED,null);
	}
/**
 * The UI has notified us that a connection has been removed.
 */
protected void removedUIConnection(String host, int port) {
	int index = fApplications.getAppIndex(host, port);
	if (fApplications.setConnected(index, Application.NOT_CONNECTED)) { // changed
		if (fApplicationDetails.getAppIndex() == index) {
			fApplicationDetails.notify(FORM_MODEL_CHANGED, null);
		}
	}
}
	public void setLaunchSelectionNoNotify(int selection) {
		fLaunchSelection = selection;
	}
	public void setSelection(int s) {
		if (s != fSelection) {
			setSelectionNoNotify(s);
			if (fTable != null) {
				fTable.setSelectedIndex(fSelection);
				if (fSelection >= 0)
					fTable.ensureIndexIsVisible(fSelection);
			}
		}
	}
	public void setSelectionNoNotify(int selection) {
		fSelection = selection;
	}
public void start() {
	/* UI infrastructure */
	fApp = new ULCApplication(this);
	fGreen = new ULCIcon(getClass().getResource("green-ball.gif"));
	fRed = new ULCIcon(getClass().getResource("red-ball.gif"));
	fYellow = new ULCIcon(getClass().getResource("yellow-ball.gif"));
	add(fGreen);
	add(fRed);
	add(fYellow);
	// shell
	fShell = new ULCShell("AppController", true); // receive CloseBox events
	fShell.addWindowClosingListener(new WinCloseAction(this));
	fApp.add(fShell);


	/* Content */
	ULCBox vbox = new ULCVBox(10 /*gap*/);
	fShell.add(vbox);
	// header line
	ULCBox header = new ULCHBox(15);
	final ULCFont boldfont = new ULCFont("Dialog", ULCFont.BOLD, 18);
	header.add(new ULCLabel(boldfont, "ULC Application Controller"));
	vbox.add("ct", header);

	// table
	fTable = createTable();
	vbox.add("ee", fTable);

	// buttons
	vbox.add("et", createButtons());

	// menus
	fShell.setMenuBar(createMenuBar());
	fShell.setVisible(true);
	fShell.getMenuBar().setEnabled(false);
	fShell.getMenuBar().setEnabled(true);
}
static Process startJavaApp(Application app) throws IOException {
	if (app.fJavaMainClass == null)
		return null;
	String addClassPath = app.fJavaAppHome + FILESEP + app.fAppDir;
	String ulcJavaHome = app.fJavaAppHome + FILESEP + "..";
	String args[] = new String[2];
	args[0] = "-server";
	args[1] = (new Integer(app.getPort())).toString();
	if (System.getProperty("java.version").compareTo("1.2") < 0)
		return startJavaOnJDK11(ulcJavaHome, app.fJavaMainClass, addClassPath, args);
	else
		return startJavaOnJDK12(ulcJavaHome, app.fJavaMainClass, addClassPath, args);
}
public static Process startJavaOnJDK11(String ulcJavaHome, String mainClass, String addClassPath, String mainArgs[]) throws IOException {
	String javaHome = System.getProperty("java.home");
	String javaExe = "jre.exe";
	String classPath = "\"" + javaHome + FILESEP + "lib" + FILESEP + "rt.jar\";" + "\"" + javaHome + FILESEP + "lib" + FILESEP + "i18n.jar\"";
	String ulcJavaLib = ulcJavaHome + FILESEP + "lib";
	String cp = "\"" + ulcJavaLib + "\";\"" + ulcJavaLib + FILESEP + "ulc.jar\"";
	Runtime rt = Runtime.getRuntime();
	String args[] = new String[8 + mainArgs.length];
	args[0] = "\"" + javaHome + FILESEP + "bin" + FILESEP + javaExe + "\"";
	args[1] = "-Djava.home=" + "\"" + javaHome + "\"";
	args[2] = "-classpath";
	args[3] = classPath;
	args[4] = "-cp";
	args[5] = cp;
	if (addClassPath != null)
		args[5] = args[5] + ";\"" + addClassPath + "\"";
	if (fgEnableJIT)
		args[6] = "";
	else
		args[6] = "-nojit";
	args[7] = mainClass;
	for (int i = 0; i < mainArgs.length; i++)
		args[8 + i] = mainArgs[i];
	if (ULC.fgDebug) {
		System.out.println("Starting Java application:");
		for (int j = 0; j < args.length; j++)
			System.out.print(args[j] + " ");
		System.out.println();
	}
	return rt.exec(args);
}
public static Process startJavaOnJDK12(String ulcJavaHome, String mainClass, String addClassPath, String mainArgs[]) throws IOException {
	String javaHome = System.getProperty("java.home");
	String javaExe = "java.exe";
	String ulcJavaLib = ulcJavaHome + FILESEP + "lib";
	String cp = "\"" + ulcJavaLib + "\";\"" + ulcJavaLib + FILESEP + "ulc.jar\"";
	Runtime rt = Runtime.getRuntime();
	String args[] = new String[6 + mainArgs.length];
	args[0] = "\"" + javaHome + FILESEP + "bin" + FILESEP + javaExe + "\"";
	args[1] = "-Djava.home=" + "\"" + javaHome + "\"";
	args[2] = "-cp";
	args[3] = cp;
	if (addClassPath != null)
		args[3] = args[3] + ";\"" + addClassPath + "\"";
	if (fgEnableJIT)
		args[4] = "";
	else
		args[4] = "-nojit";
	args[5] = mainClass;
	for (int i = 0; i < mainArgs.length; i++)
		args[6 + i] = mainArgs[i];
	if (ULC.fgDebug) {
		System.out.println("Starting Java application:");
		for (int j = 0; j < args.length; j++)
			System.out.print(args[j] + " ");
		System.out.println();
	}
	return rt.exec(args);
}
	public static
	Process startSmalltalkApp(Application app) throws IOException {
		if (app.fSmalltalkExe == null)
			return null;
		Runtime rt = Runtime.getRuntime();
		String args[] = new String[3];
		args[0] = app.fSmalltalkAppHome + FILESEP
						+ app.fAppDir + FILESEP
						+ app.fSmalltalkExe;
		args[1] = "-server";
		args[2] = (new Integer(app.getPort())).toString();
		if (ULC.fgDebug) {
			System.out.println("Starting Smalltalk application:");
			System.out.println(args[0] + " " + args[1] + " " + args[2]);
		}
		
		return rt.exec(args);
	}
}
