package com.ibm.ulc.AppController;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */

import java.net.*;
import com.ibm.ulc.comm.UlcConnection;
import com.ibm.ulc.application.ULCIcon;


class Application implements Cloneable {
	
	// state set by properties file:
	String fLabel= "";
	ULCIcon fIcon= null;
	String fLanguage= "";
	String fUrlString= null;
	private String fHost= null;
	String fRealHost= null;
	private int fPort= UlcConnection.INVALIDPORT;
	private String fFile= null;
	String fAppDir= "";
	String fAbsAppDir= "";
	String fJavaMainClass= null;
	String fSmalltalkExe= null;

	String fJavaAppHome= "";
	String fSmalltalkAppHome= "";
	
	// state maintained by Applications instance:
	static final int NOT_CONNECTED = 0;
	static final int CONNECTED = 1;
	static final int CONNECTION_IN_PROGRESS = 2;
	int fConnected = NOT_CONNECTED;
	
	// state maintained by AppController class:
	public String fConnectionId= "*";
	boolean fServerRunning = false;
	public Process fProcess = null;
	public long fStartTime = 0;
	

	public Object clone() {
		Application copy = null;
		try {
			copy = (Application) super.clone();
		} catch(CloneNotSupportedException e) {
		}		
		return copy;
	}
public String getFile( ) {
	if (fFile == null)
		fFile= UlcConnection.getFileFromUrlString(fUrlString);

	return fFile;
}
public String getHost( ) {
	if (fHost == null)
		fHost= UlcConnection.getHostFromUrlString(fUrlString);
	return fHost;
}
public int getPort( ) {
	if (fPort == UlcConnection.INVALIDPORT)
		fPort= UlcConnection.getPortFromUrlString(fUrlString);
	return fPort;
}
}
