package com.ibm.ulc.AppController;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 *
 */

import com.ibm.ulc.util.Anything;
import com.ibm.ulc.application.*;


class DetailDisplay {
	private ULCShell fShell = null;
	private AppController fController = null;
	private ULCBox fDetailBox = null;


	DetailDisplay(ApplicationDetails details, AppController controller,
							boolean enableLaunching) {
		fController = controller;

		fDetailBox = new ULCBox(0,2);
		fDetailBox.add(new ULCLabel("Application:"));
		ULCField label = new ULCField(details,"Label",20);
		label.setEditable(false);
		fDetailBox.add("ec",label);
		fDetailBox.add(new ULCLabel("URL address:"));
		ULCField url = new ULCField(details,"URL",20);
		url.setEditable(false);
		fDetailBox.add("ec",url);
		fDetailBox.add(new ULCLabel("Host:"));
		ULCField host = new ULCField(details,"Host",20);
		host.setEditable(false);
		fDetailBox.add("ec",host);
		fDetailBox.add(new ULCLabel("Port:"));
		ULCField port = new ULCField(details,"Port",20);
		port.setEditable(false);
		fDetailBox.add("ec",port);
		fDetailBox.add(new ULCLabel("Internal name:"));
		ULCField name = new ULCField(details,"AppName",20);
		name.setEditable(false);
		fDetailBox.add("ec",name);
		fDetailBox.add(new ULCLabel("Language:"));
		ULCField lang = new ULCField(details,"Language",20);
		lang.setEditable(false);
		fDetailBox.add("ec",lang);
		fDetailBox.add(new ULCLabel("Connection:"));
		ULCField stat = new ULCField(details,"ConnectStatus",20);
		stat.setEditable(false);
		fDetailBox.add("ec",stat);
		if (enableLaunching) {
			fDetailBox.add(new ULCLabel("Server:"));
			ULCField serv = new ULCField(details,"RunStatus",20);
			serv.setEditable(false);
			fDetailBox.add("ec",serv);
		}
		if (ULC.fgDebug) {
			fDetailBox.add(new ULCLabel("Directory:"));
			ULCField dir = new ULCField(details,"AbsoluteAppDir",20);
			dir.setEditable(false);
			fDetailBox.add("ec",dir);
			fDetailBox.add(new ULCLabel("Java Main Class:"));
			ULCField cl = new ULCField(details,"JMainClass",20);
			cl.setEditable(false);
			fDetailBox.add("ec",cl);
			fDetailBox.add(new ULCLabel("Smalltalk Exec:"));
			ULCField exec = new ULCField(details,"StExec",20);
			exec.setEditable(false);
			fDetailBox.add("ec",exec);
			fDetailBox.add(new ULCLabel("Java App Home:"));
			ULCField japphome = new ULCField(details,"JAppHome",20);
			japphome.setEditable(false);
			fDetailBox.add("ec",japphome);
			fDetailBox.add(new ULCLabel("Smalltalk App Home:"));
			ULCField stapphome = new ULCField(details,"StAppHome",20);
			stapphome.setEditable(false);
			fDetailBox.add("ec",stapphome);
		}	
		// now make the overall layout
		fShell = new ULCShell("Details");
		ULCVBox vbox = new ULCVBox(10);
		vbox.add("ee",fDetailBox);
		fShell.add(vbox);
	}
	ULCShell getShell() {
		return fShell;
	}
	void hide() {
		fShell.setVisible(false);
	}
	void show() {
		fShell.setVisible(true);
	}
}
