package com.ibm.ulc.HttpServer;


/*
 * Copyright (c) 1998 Object Technology International Inc.
 */


import java.net.*;
import java.io.*;
import java.util.*;



class HttpConnection implements Runnable {
	static final String HTMLINESEP = "\r\n";
	static final String FILESEP =
		System.getProperty("file.separator");
	private static final String INDEXFILE= "start.html";
	private static final String[]  fgParseSuffixes= {".uhtml", ".ulc"};

	private Socket fSocket;
	private String fWebHost;
	private boolean fDebug;

	HttpConnection(Socket socket, HttpServer server) {
		fSocket= socket;
		fDebug = server.fDebug;
		InetAddress localAddr = fSocket.getLocalAddress();
		fWebHost = localAddr.getHostAddress();
		if (fDebug)
			System.out.println("HttpConnection. fWebHost=" + fWebHost);
		
		Thread t= new Thread(this);
		t.start();
	}
public boolean fileShouldBeParsed(String fileName) {
	for (int i = 0; i < fgParseSuffixes.length; i++) {
		if (fileName.endsWith(fgParseSuffixes[i]))
			return true;
	}
	return false;
}
	String getMsg(int code) {
		switch (code) {
		case 200:
			return "OK";
		case 204:
			return "OK, No Content";
		case 301:
			return "OK, Redirect";
		case 404:
			return "File Not Found";
		case 501:
			return "Not Implemented";
		}
		return "Unknown Error";
	}
public String guessContentTypeFromName(String name) {
	if (name.endsWith(".html") || name.endsWith(".htm") || name.endsWith(".uhtml"))
		return "text/html";
	if (name.endsWith(".txt") || name.endsWith(".java"))
		return "text/plain";
	if (name.endsWith(".gif"))
		return "image/gif";
	if (name.endsWith(".class") || name.endsWith(".zip") || name.endsWith(".jar"))
		return "application/octet-stream";
	if (name.endsWith(".jpg") || name.endsWith(".jpeg"))
		return "image/jpeg";
	if (name.endsWith(".pdf"))
		return "application/pdf";
	if (name.endsWith(".ulc"))
		return "application/x-ulc";
	return "text/plain";
}
public void run() {
	File theFile;
	boolean sendMimeHeader = false;
	try {
		BufferedReader is =
			new BufferedReader(new InputStreamReader(fSocket.getInputStream()));
		BufferedOutputStream obs=new BufferedOutputStream(fSocket.getOutputStream());
		PrintWriter os =
			new PrintWriter(obs);
		String line = is.readLine();
		if (fDebug)
			System.out.println("HttpServer. got line: " + line);
		if (line == null)
			return;
		StringTokenizer st = new StringTokenizer(line);
		String method = st.nextToken();
		if (method.equals("GET")) {
			boolean done = false;
			boolean parse = false;
			String file= null;
			String 	nt= st.nextToken();
			while (st.hasMoreElements() && (!nt.startsWith("HTTP/"))) {
				if (file == null)
					file= nt;
				else
					file += " " + nt;
				nt= st.nextToken();
			}
			if (nt.startsWith("HTTP/"))
				sendMimeHeader = true;
			else
				file += " " + nt;
			if (file.endsWith("/"))
				file += INDEXFILE;
			if (fileShouldBeParsed(file))
				parse = true;
			String ct = guessContentTypeFromName(file);

			// loop through the rest of the input lines 
			while ((line = is.readLine()) != null)
				if (line.trim().equals(""))
					break;
					
			// send content of a resource file		
			InputStream resStream = null;
			try {
				resStream =HttpServer.getStreamFor(file.substring(1,file.length()));
				if (resStream != null) {
					if (sendMimeHeader)
						sendMimeHeader(os,200,ct,0,true);
					if (parse) {
						// parse and replace certain macros
						BufferedReader reader =
							new BufferedReader(new InputStreamReader(resStream));

						final String WEBHOST = "$WEBHOST";
						for (String parseline = reader.readLine();
							 parseline != null;
							 parseline = reader.readLine()) {
							StringBuffer parsebuf = new StringBuffer();
							boolean changed = false;
							int lineind = 0;
							for (int i = parseline.indexOf(WEBHOST);
								 i >= 0;
								 i = parseline.indexOf(WEBHOST,i + 1)) {
								changed = true;
								parsebuf.append(parseline.substring(lineind,i));
								parsebuf.append(fWebHost);
								i += WEBHOST.length();
								lineind = i;
							}
							if (changed) {
								parsebuf.append(parseline.substring(lineind));
								os.println(new String(parsebuf));
							}
							else
								os.println(parseline);
						}
					}
					else {
						// just copy file to output stream
						os.flush();
						BufferedInputStream byteStream =new BufferedInputStream(resStream);

						final int bufsize = 1000;
						byte [] buf = new byte[bufsize];
						for (int n = 0; n != -1;) {
							n = byteStream.read(buf,0,bufsize);
							if (n > 0)
								obs.write(buf,0,n);
						}

						byteStream.close();
					}
					resStream.close();
				} else {
					if (fDebug)
						System.out.println("HttpServer. cannot find resource: " + file.substring(1, file.length()));
					sendError(sendMimeHeader, os, 404);
				}
			} catch (IOException e) { // can't find the file
				if (fDebug)
					System.out.println("HttpServer. IOException for resource: " + file.substring(1, file.length()));
				sendError(sendMimeHeader, os, 404);
				if (resStream != null)
					resStream.close();
			}
			os.close();
		} else { // method does not equal "GET"
			sendError(sendMimeHeader, os, 501);
			os.close();
		}
	} catch (IOException e) {
	}
	try {
		fSocket.close();
	} catch (IOException e) {
	}
}
	void sendError(boolean sendMimeHeader,PrintWriter os, int code) {
		if (sendMimeHeader)
			sendMimeHeader(os,code,"text/html",-1,false);
		String msg= getMsg(code);
		os.println("<HTML><HEAD><TITLE>" + msg + "</TITLE></HEAD>");
		os.println("<BODY><H1>HTTP Error " + code + ": " + msg + "</H1></BODY></HTML>");
	}
	void sendMimeHeader(
		PrintWriter os, int code, String type,
		int len, boolean persistent)
	{
		sendMimeHeader(os,code,type,len,persistent,null);
	}
	void sendMimeHeader(
		PrintWriter os, int code, String type,
		int len, boolean persistent, String location)
	{
		String msg= getMsg(code);
		os.print("HTTP/1.0 " + code + " " + msg + HTMLINESEP);
		Date now= new Date();
		os.print("Date: " + now + HTMLINESEP);
		os.print("Server: ULC HttpServer 1.0" + HTMLINESEP);
		os.print("Content-type: " + type + HTMLINESEP);
		if (len > 0)
			os.print("Content-length: " + len + HTMLINESEP);
		if (location != null)
			os.print("Location: " + location + HTMLINESEP);
		if (!persistent)
			os.print("Cache-Control: no-cache" + HTMLINESEP);
		os.print(HTMLINESEP);   // blank line (separates header from body)
	}
}
