package com.ibm.ulc.application;

/*
 * Copyright (c) 1999 Object Technology International Inc.
 */
import java.io.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.util.*;
class AFileOutputStream extends OutputStream {
	private ULCGenericProxy fFileOutputStreamProxy = null;
public AFileOutputStream(com.ibm.ulc.application.ULCContext context, String name, boolean append) throws IOException {
	fFileOutputStreamProxy = new ULCGenericProxy(context, "com.ibm.ulc.ui.io.UIFileOutputStream");
	Anything args = new Anything();
	args.put("name", name);
	args.put("append", append);
	Anything reply = fFileOutputStreamProxy.syncCall("construct", args);
	if (reply.isDefined("exception"))
		throw ((IOException) reply.get("exception").asSerializable(null));
}
public void close() throws IOException {
	Anything reply = fFileOutputStreamProxy.syncCall("close", null);
	super.close();
	if (reply.isDefined("exception"))
		throw ((FileNotFoundException) reply.get("exception").asSerializable(null));
}
public void write(byte b[]) throws IOException {
	Anything reply = fFileOutputStreamProxy.syncCall("writeBytes", new Anything(b));
	if (reply.isDefined("exception"))
		throw ((IOException) reply.get("exception").asSerializable(null));
}
public void write(byte b[], int off, int len) throws IOException {
	if ((b.length == len) && (off == 0))
		write(b);
	else {
		byte a[] = new byte[len];
		System.arraycopy(b, off, a, 0, len);
		write(a);
	}
}
public void write(int b) throws IOException {
	Anything reply = fFileOutputStreamProxy.syncCall("write", new Anything(b));
	if (reply.isDefined("exception"))
		throw ((IOException) reply.get("exception").asSerializable(null));
}
}
