package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.UlcHashtable;
/**
 * This interface tags item lists which have a hierarchical structure.
 */
public interface IHierarchicalItemList extends IItemList {
/**
 * This method is called when the specified rowIds should be reloaded with their complete subtrees.
 * In order to force a reload from the data source, the receiver's model needs to remove all traces of
 * the currently defined children of the specified nodes. The oids of all the known children are added
 * by all nodes concerned to the @oidsToRemove hashtable as keys, with their respective values null.
 *
 * @param oidsToRemove	The rowIds of all subtrees of the specified nodes.
 * @param rowIds The rowids of the changed nodes.
 * @param attributes The changed attributes
 */
void collectChildOids(UlcHashtable oidsToRemove, int[] rowIds, String[] attributes);
/**
 * Upload the given nodes, along with their complete paths,
 * to the UI. The path is calculated only upto the last
 * already-uploaded ancestor of the receiver.
 *
 * @param nodes		Vector		The nodes whose paths need to be
 *								sent up to the UI.
 */
void sendPaths(java.util.Vector nodes);
/**
 * Set the given object as the new root for the receiver
 *
 * @param 	object 	Object	The new root for the receiver's hierarchy
 */
void setRoot(Object object);
}
