package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
 
/**
 * This interface is used to define the interaction in 
 * an <code>ULCHtmlPane</code> when a link has been activated or an error occurs
 * The <code>linkActivated(ULCLinkActivatedEvent)</code> must be implemented to
 * react on the link value.
 * The <code>linkError(ULCLinkErrorEvent)</code> must be implemented to
 * react on link errors.
 *
 * @see	ULCHtmlPane
 */
public interface IHyperLinkListener extends IListener {
/**
 * Notification that a hyperlink has been activated in the UI.
 *
 * @param linkActivatedEvent ULCLinkActivatedEvent
 */
void linkActivated(ULCLinkActivatedEvent linkActivatedEvent);
/**
 * Notification that a hyperlink error has occurred in the UI.
 *
 * @param linkErrorEvent ULCLinkErrorEvent
 */
void linkError(ULCLinkErrorEvent linkErrorEvent);
}
