package com.ibm.ulc.application;

/**
 * This interface is used for tagging itemLists which access rows by index.
 */
public interface IIndexedItemList extends IItemList {
/**
 * Internal method for collecting Object identifiers for the selected rows.
 * If the row/oid identifiers do not exist they are allocated and inserted
 * into the mapping tables.
 *
 * @param	startRow 		int		The index of the first row whose oid is required
 * @param	numberOfRows 	int		The number or rows (starting at the startRow), 
 *									whose oids are required
 */
public int[] getObjectIdentifiers(int startRow, int numberOfRows);
}
