package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 *
 * This interface defines the API for maintaining a collection of elements 
 * within a specified order.
 */
public interface IItemList extends IProxy {
/**
 * Add an owner to the receiver.
 *
 * @param owner 	IItemListOwner	The owner to be added
 */
public void addOwner(IItemListOwner owner);
/**
 * Return the index for the rowId specified. Answer -1 if the oid was not found.
 *
 * @param oid	int	The rowId whose index is required.
 */
public int getIndexForOid(int oid);
/**
 * Answer the receiver's tableModel
 */
public ULCAbstractTableModel getModel();
/**
 * Return the row id for the index or <code>INVALID_OID</code> if not found
 *
 * @param index	int	The index for which the oid is required
 */
public int getOidForIndex(int index);
/**
 * Answer the array of attributeNames that the receiver's model needs to upload with every row.
 *
 * This array may cause unrequested attributes to be uploaded to the UI.
 */
public String[] getPreloadedAttributes();
/**
 * Answer the row at the specified index in the receiver
 *
 * @param index	The index of the row being accessed.
 */
public Object getRowAt(int index);
/**
 * Override this method to return the number of rows of this table.
 *
 * The number answered does not have to be the same as that of the receiver's tableModel.
 * ItemLists may display only excerpts from the tableModel
 */
public int getRowCount();
/**
 * Answer the array of row identifiers that should be uploaded when the receiver 
 * is uploaded for the first time.
 */
public int[] initialOids();
/**
 * The entire contents of the receiver's model has changed. 
 * Update the receiver and its UI proxy accordingly.
 */
public void notifyContentsChanged();
/**
 * The rows specified by rowIds have been added to the receiver's model. 
 * Update the receiver and its UI proxy accordingly.
 *
 * @param rowIds	int[]	The set of rowIds that have been added to my model
 */
public void notifyRowsAdded(int[] rowIds);
/**
 * The rows specified by rowIds have changed in the specified attributes.
 * No attribute specified indicates that the rows have completely changed.
 *
 * @param rowIds 			int[] 		The rowids of the changed nodes.
 * @param attributeNames 	String[] 	The changed attributes
 */
public void notifyRowsChanged(int[] rowIds, String[] attributeNames);
/**
 * The rows specified by rowIds have been removed from the receiver's model. 
 * Update the receiver, but do NOT update the UI, as this is done internally 
 * via the update of the UI ItemCache.
 *
 * @param rowIds		The row identifiers removed from my model
 */
public void notifyRowsRemoved(int[] rowIds);
/**
 * Remove the given owner from the receiver.
 *
 * @param owner 	IItemListOwner	The owner to remove
 */
public void removeOwner(IItemListOwner owner);
/**
 * Set the model which provides the data for the receiver.
 *
 * @param model 	ITableModel	The model for the receiver
 */
public void setModel(ITableModel model);
}
