package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * This interface is used in order to listen for changes in 
 * page changes in a pagebook
 * The <code>pageChanged(ULCPageChangedEvent)</code> will be
 * called when a page changes in the UI.
 *
 * @see ULCPagebook#addPageChangedListener(IPageChangedListener)
 * 		which registers this interface for the given table.
 * @see ULCPageChangedEvent
 *		The type of event which this listener lisens to.
 */
public interface IPageChangedListener extends IListener {
/**
 * Notification that a page has changed in the UI.
 * 
 * @param pageChangedEvent ULCPageChangedEvent
 */
void pageChanged(ULCPageChangedEvent pageChangedEvent);
}
