package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * This interface is used in order to listen for changes in 
 * the selected element (examples ULCTable, ULCForm, ULCComboBox).
 * The <code>selectionChanged(ULCSelectionChangedEvent)</code> will be
 * called when a selection changes in the UI.
 *
 * @see ULCTableList#addSelectionChangedListener(ISelectionChangedListener)
 * @see ULCSelectionChangedEvent
 *		
 */
public interface ISelectionChangedListener extends IListener {
/**
* Notification that a selection has changed in the UI.
* 
* @param selectionChangedEvent ULCSelectionChangedEvent
*/
void selectionChanged(ULCSelectionChangedEvent selectionChangedEvent);
}
