package com.ibm.ulc.application;

/**
 * Defines the interface for all Trigger objects.
 * Triggers can be activated in the UI based on selections and action events.
 *
 * @see ULCBlockInputTrigger
 */
public interface ITrigger {
/**
 * The trigger has been reset. Perform any action required to restore the state of the widgets.
 *
 * @see ULCBlockInputTrigger
 */
public void reset();
/**
 * The trigger has been activated. Perform any action required to mark the widgets as triggerred.
 *
 * @see ULCBlockInputTrigger
 */
public void trigger();
}
