package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;

/**
 * This class can be used to decorate any other ULC widget with a border.
 * The label and the font for the label can also be specified as part of the border.
 *
 * @see ULCBorder#add(ULCComponent)
 */
public class ULCBorder extends ULCComponent {
	/**
	 * The margin around the component I enclose and the border itself.
 	 * @serial
	 */
	protected int fMargin = 5;
	/**
	 * Specify the alignment attribute for the component
	 * <p>
	 * <pre>
	 * Format for alignment string:
	 * 	'horizontal specifier''vertical specifier'
	 *		'horizontal specifier':
	 * 			e expand
	 * 		 	l left
	 * 		 	c center
	 * 		 	r right
	 *		'vertical specifier':
	 * 		 	e expand
	 * 			t top
	 * 		 	c center
	 * 			b bottom
	 * </pre>
 	 * @serial
	 */
	protected String fAlign = "ee";
public ULCBorder() {
}
/**
 * Construct a border with a title and use the default alignment for the content.
 *
 * @param label The string that should be displayed as my label.
 */
public ULCBorder(String label) {
	super(label);
}
/**
 * Construct a border with a title in the specified font.
 * Use the default alignment for the content.
 *
 * @param label The string that should be displayed as my label.
 * @param font  The ULCFont that should be used to display my label.
 */
public ULCBorder(String label, ULCFont font) {
	super(label);
	fFont = font;
}
/**
 * Construct a border with a title and use the specified alignment for the content.
 *
 * @param label The string that should be displayed as my label.
 * @param align Use the alignment specified to align the component I enclose.
 * <p>
 * <pre>
 * Format for alignment string:
 * 	'horizontal specifier''vertical specifier'
 *		'horizontal specifier':
 * 			e expand
 * 		 	l left
 * 		 	c center
 * 		 	r right
 *		'vertical specifier':
 * 		 	e expand
 * 			t top
 * 		 	c center
 * 			b bottom
 * </pre>
 */
public ULCBorder(String label, String align) {
	super(label);
	fAlign = align;
}
/**
 * Add the content widget. 
 * If the ULCBorder already has a child adding more has no effect.
 *
 * @param comp	Widget decorated with a border.
 */
public void add(ULCComponent comp) {
	if (fList == null || fList.size() == 0)
		internalAdd(comp);
	else
		trouble("add(ULCComponent)", "component already assigned");
}
/**
 * Return the current alignment of the widget inside this border.
 *
 * @return align Use the alignment specified to align the component I enclose.
 * <p>
 * <pre>
 * Format for alignment string:
 * 	'horizontal specifier''vertical specifier'
 *		'horizontal specifier':
 * 			e expand
 * 		 	l left
 * 		 	c center
 * 		 	r right
 *		'vertical specifier':
 * 		 	e expand
 * 			t top
 * 		 	c center
 * 			b bottom
 * </pre>
 */
public String getAlignment() {
	return fAlign;
}
/**
 * Gets the border's label.
 *
 * @return The current label string 
 */
public String getLabel() {
	return fLabel;
}
/**
 * Gets the margin between the content and the border.
 *
 * @return	margin 
 *			The integer that specifies the margin between the content and the border.
 */
public int getMargin() {
	return fMargin;
}
/**
 * Remove the content widget. 
 *
 * @param comp	Widget decorated with a border.
 * @deprecated	As of ULC R3.1, use removeContents instead
 * @see #removeContents
 */
public void remove(ULCComponent comp) {
	removeContents();
}
/**
 * Remove decorated widget from this border
 *
 * @param comp	Widget decorated with this border.
 */
public void removeContents() {
	if (fList != null && fList.size() == 1)
		internalRemove((ULCComponent) fList.firstElement());
	else
		trouble("removeContents()", "there was no contents");
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fMargin != 0)
		a.put("m", fMargin);
	if (!fAlign.equals("ee"))
		a.put("a", fAlign);
}
/**
 * Set the current alignment of the widget inside this border.
 *
 * @param alignment Use the alignment specified to align the component I enclose.
 * <p>
 * <pre>
 * Format for alignment string:
 * 	'horizontal specifier''vertical specifier'
 *		'horizontal specifier':
 * 			e expand
 * 		 	l left
 * 		 	c center
 * 		 	r right
 *		'vertical specifier':
 * 		 	e expand
 * 			t top
 * 		 	c center
 * 			b bottom
 * </pre>
 */
public void setAlignment(String alignment) {
	fAlign = alignment;
}
/**
 * Sets the widgets's <code>String</code> label.
 *
 * @param label the label <code>String</code> of the widget.
 */
public void setLabel(String label) {
	internalSetLabel(label);
}
/**
 * Set the margin between the content and the border.
 *
 * @param	margin 
 *			The integer that specifies the margin between the content and the border.
 */
public void setMargin(int margin) {
	if (margin != fMargin) {
		fMargin = margin;
		sendUI("setMargin", new Anything(fMargin));
	}
}
}
