package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.base.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.util.*;
import java.net.*;

/**
 * This class is used to display a HTML page in an external web browser.
 * If the UI is being run as an Applet it causes the browser in which the
 * applet is running to display the requested page and the browserPath is ignored.
 * If not running as an applet an external web browser is launched.
 * <p>
 * <pre>
 * The rules for determining which external browser is launched is as follows:
 * 	1)	Use the browser path to launch the browser if specified.
 * 	2) 	Under Windows NT/95 and OS2 the system default HTML browser is launched if 
 *		browserPath is not specified.
 *	3) 	On other platforms if the browser path is not specified the default is to
 * 		attempt to get the system property <i>ULC.Browser</i>. If this property is not
 * 		defined then attempt to start the executable Netscape.exe which should be on 
 *		the system path.
 * </pre>
 * <p>
 * NOTE: the browser path if specified must be valid and accessible for the UI-Engine.
 */
public class ULCBrowserContext extends ULCProxy {
	/**
	 * The path on the UIEngine of the browser
	 * @serial
	 */
	protected String fBrowserPath = null;
	/**
	 * The URL to be displayed
	 * @serial
	 */
	protected URL fUrl = null;
/**
 * Constructor to create a ULCBrowserContext with a null ULCContext.
 *
 */
public ULCBrowserContext() {
}
/**
 * Constructor to create a ULCBrowserContext on a ULCContext.
 *
 * @param context The ULCContext on which I should be created.
 */
public ULCBrowserContext(ULCContext context) {
	super(context);
}
/**
 * Constructor to create a ULCBrowserContext on a ULCContext.
 *
 * @param 	context The ULCContext on which I should be created.
 * @param 	String browserPath
 * 			Note: The browserPath if specified must be a valid file path for
 *			the machine running the UIEngine.
 */
public ULCBrowserContext(ULCContext context, String browserPath) {
	super(context);
	fBrowserPath = browserPath;
}
/**
 * Return the browserPath.
 *
 */
public String getBrowserPath() {
	return fBrowserPath;
}
/**
 * Return the context.
 *
 */
public ULCContext getContext() {
	return fContext;
}
/**
 * Return the current URL.
 */
public URL getUrl() {
	return fUrl;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fBrowserPath != null)
		a.put("bp", fBrowserPath);
	if (fUrl != null)
		a.put("url", fUrl.toString());
}
/**
 * Set the browserPath.
 * Note: Calling this method after the widget has been uploaded has no effect.
 *
 */
public void setBrowserPath(String browserPath) {
	fBrowserPath= browserPath;
}
/**
 * Seturn the context.
 */
public void setContext(ULCContext context) {
	fContext = context;
}
/**
 * Set the current URL.
 */
public void setUrl(URL url) {
	showDocument(url);
}
/**
 * Show the document specified by the url string
 *
 * @param url The String that specifies the URL to be displayed.
 */
public void showDocument(String urlString) {
	URL u = null;
	try {
		u = new URL(urlString);
	} catch (Exception e) {
		System.out.println("Error forming URL");
	}
	if (u != null)
		showDocument(u);
}
/**
 * Show the document specified by the url string
 *
 * @param url 		The String that specifies the URL to be displayed.
 * @param target    a <code>String</code> indicating where to display
 *                  the page.
 */
public void showDocument(String urlString, String target) {
	URL u = null;
	try {
		u = new URL(urlString);
	} catch (Exception e) {
		System.out.println("Error forming URL");
	}
	if (u != null)
		showDocument(u, target);
}
/**
 * Show the document specified by the url
 *
 * @param url The URL that specifies the web page to be displayed.
 */
public void showDocument(URL url) {
	fUrl= url;
	Anything a = new Anything();
	a.put("url", url.toString());
	if (!isUploaded())
		upload(fContext);
	sendUI("showDoc", a);
}
/**
 * Requests that the browser or applet viewer show the Web page 
 * indicated by the <code>url</code> argument. The 
 * <code>target</code> argument indicates in which HTML frame the 
 * document is to be displayed. 
 * The target argument is interpreted as follows:
 * <p>
 * <center><table border="3"> 
 * <tr><td><code>"_self"</code>  <td>Show in the window and frame that 
 *                                   contain the applet.</tr>
 * <tr><td><code>"_parent"</code><td>Show in the applet's parent frame. If 
 *                                   the applet's frame has no parent frame, 
 *                                   acts the same as "_self".</tr>
 * <tr><td><code>"_top"</code>   <td>Show in the top-level frame of the applet's 
 *                                   window. If the applet's frame is the 
 *                                   top-level frame, acts the same as "_self".</tr>
 * <tr><td><code>"_blank"</code> <td>Show in a new, unnamed
 *                                   top-level window.</tr>
 * <tr><td><i>name</i><td>Show in the frame or window named <i>name</i>. If 
 *                        a target named <i>name</i> does not already exist, a 
 *                        new top-level window with the specified name is created, 
 *                        and the document is shown there.</tr>
 * </table> </center>
 * <p>
 * An applet viewer or browser is free to ignore <code>showDocument</code>. 
 * <p>
 * Note: If the ULC application is not running as an applet <code>target</code> is ignored.
 *
 * @param   url   	an absolute URL giving the location of the document.
 * @param   target  a <code>String</code> indicating where to display
 *                  the page.
 */
public void showDocument(URL url, String target) {
	fUrl = url;
	Anything a = new Anything();
	a.put("url", url.toString());
	a.put("parm", target);
	if (!isUploaded())
		upload(fContext);
	sendUI("showDoc", a);
}
}
