package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;

/**
 * Validates the date input in a date field.
 * The formatString specified must be a valid format for the Java
 * <code>SimpleDateFormat</code> class.
 * Dates are exchanged between the UI and the ULC in the GMT timezone.
 *
 * @see java.text.SimpleDateFormat
 */
public class ULCDateValidator extends ULCProxy implements IDataType {
	/**
	 * @serial
	 */
	public String fDateFormatString = "dd.MM.yy";
/**
 * Construct a ULCDateValidator.
 */
public ULCDateValidator() {
	super();
}
/**
 * Construct a ULCDateValidator with the specified date format.
 * The formatString specified must be a valid format for the Java
 * <code>SimpleDateFormat</code> class.
 * Dates are exchanged between the UI and the ULC in the GMT timezone.
 *
 * @see java.text.SimpleDateFormat
 */
public ULCDateValidator(String formatString) {
	this();
	fDateFormatString = formatString;
}
/**
 * Return the format string for this date validator.
 *
 * Format strings can contain multiple formats to allow partial input of dates as well:
 * The multiple formats are separated by the '|' character.
 * eg: 'dd.MM.yy|dd.MM|dd'
 * would allow the user to enter either the full dd.mm.yy format or the dd.MM format or just dd.
 * In all cases of incomplete specification of dates the current date is used as the base date.

 * @return formatString	String	
 */
public String getFormatString() {
	return fDateFormatString;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (!fDateFormatString.equals("dd.MM.yy"))
		a.put("fs", fDateFormatString);
}
/**
 * Set the format string for this date validator.
 * The formatString specified must be a valid format for the Java
 * <code>SimpleDateFormat</code> class.
 * Dates are exchanged between the UI and the ULC in the GMT timezone.
 *
 * Format strings can contain multiple formats to allow partial input of dates as well:
 * The multiple formats are separated by the '|' character.
 * eg: 'dd.MM.yy|dd.MM|dd'
 * would allow the user to enter either the full dd.mm.yy format or the dd.MM format or just dd.
 * In all cases of incomplete specification of dates the current date is used as the base date.
 *
 * @see java.text.SimpleDateFormat
 *
 * @param formatString	String	
 */
public void setFormatString(String formatString) {
	if (!fDateFormatString.equals(formatString)) {
		fDateFormatString = formatString;
		Anything a = new Anything(fDateFormatString);
		sendUI("setFormatString", a);
	}
}
}
