package com.ibm.ulc.application;

import com.ibm.ulc.util.*;
import java.util.*;
/**
 * A ULCDefaultTreeItemList is the default implementation of treeItemList for use with the
 * exclusively hierarchy-based ULCTreeTableModel hierarchy. This default itemList uses the
 * a ULCTreeTableModel for accessing the data.
 *
 * @see ULCTreeTableModel
 */
public class ULCDefaultTreeItemList extends ULCHierarchicalItemList {

/**
 * Construct a new ULCDefaultTreeItemList
 */
public ULCDefaultTreeItemList() {
	super();
}
/**
 * Answer the object that adapts the receiver's hierarchy
 *
 */
public IHierarchyAdapter getHierarchyAdapter() {
	return getTreeModel();
}
/**
 * Internal method to locate the key corresponding to the 
 * given object in the hashTable.
 *
 */
protected int getIdFor(Object userObject) {
	return getTreeModel().getRowIdFor(userObject);
}
/**
 * Answer the treeTableModel for the receiver.
 */
protected ULCTreeTableModel getTreeModel() {
	return (ULCTreeTableModel) getModel();
}
/**
 * Set the model which provides the data for the receiver.
 *
 * @param model 	ITableModel	The model for the receiver
 */
public void setModel(ITableModel model) {
	Assert.isTrue(model instanceof ULCTreeTableModel);
	super.setModel(model);
}
/**
 * The receiver's model has changed its contents. Always set the receiver's root to null.
 */
protected void setRootAfterContentsChanged() {
	fRoot = null;
}
}
