package com.ibm.ulc.application;

import com.ibm.ulc.util.*;
/**
 * Implement a class that can behave as an IEnabler
 */
public abstract class ULCEnabler extends ULCProxy implements IEnabler {
	/**
	 * The name of the boolean property setter method.
	 * If it is null, setEnabled will be used static
	 * otherwise the setter is called via reflection.
	 * @serial	 
	 */
	private String fSetter= null;
/**
 * Return the boolean property setter method name
 *
 * @return	The boolean property setter method name
 */
public String getSetter() {
	return fSetter;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fSetter != null)
		a.put("setter", fSetter);
}
/**
 * Set the boolean property setter method name.
 * If it is <code>null</code> (default), <code>setEnabled</code> will be called static
 * otherwise the setter is called via Java reflection API.
 *
 * If the setter is not <code>null</code> (or "setEnabled") this
 * enabler can no longer act as input for other enablers.
 * Therefore the setter property should only be set on terminal
 * enablers.
 *
 * @param setter	The boolean property setter method name
 */
public void setSetter(String setter) {
	if (fSetter != setter) {
		Anything arg= new Anything();
		fSetter= setter;
		if (fSetter != null)
			arg.put("setter", fSetter);
		sendUI("setSetter", arg);
	}
}
}
