package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;

/**
 * Assists in the building of a UI by providing the facility to
 * have white-spaces in the UI, hence enabling a nicer look-&-feel.
 */
public class ULCFiller extends ULCComponent {
	/**
	 * The width of the white space
	 * @serial	 
	 */
	protected int fWidth = 0;
	/**
	 * The height of the white space
	 * @serial	 
	 */
	protected int fHeight = 0;
/**
 * Constrcuts a new white space object.
 */
public ULCFiller() {
}
/**
 * Constrcuts a new white space object with the specified size.
 *
 * @param width 	The width of the white space
 * @param height 	The height of the white space
 */
public ULCFiller(int width, int height) {
	fWidth = width;
	fHeight = height;
}
/**
 * returns the height of this white space.
 *
 * @return height 	The height of the white space
 */
public int getHeight() {
	return fHeight;
}
/**
 * returns the width of this white space.
 *
 * @return width 	The width of the white space
 */
public int getWidth() {
	return fWidth;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fWidth != 0)
		a.put("w", fWidth);
	if (fHeight != 0)
		a.put("h", fHeight);
}
/**
 * Sets the height of this white space.
 * Setting this value after the widget has been uploaded has no effect.
 *
 * @param height 	The height of the white space
 */
public void setHeight(int height) {
	fHeight= height;
}
/**
 * Sets the width of this white space.
 * Setting this value after the widget has been uploaded has no effect.
 *
 * @param height 	The height of the white space
 */
public void setWidth(int width) {
	fWidth= width;
}
}
