package com.ibm.ulc.application;

/*
 * Copyright (c) 1997-1999 Object Technology International Inc.
 */

import com.ibm.ulc.comm.*;
import com.ibm.ulc.util.*;
/**
 * This class is a specialised version of the ULCBrowserContext. It specifies a root URL to be used
 * when a ULCComponent requests help. The help URL of the component is appended to the root URL
 * to form the complete URL to be displayed when the F1/Help key is pressed in the UI.
 * An instance of this class must be registered in the ULCContext by calling the
 * <code>ULCContext#setHelpContext</code> method.
 * <p>
 */
public class ULCHelpBrowserContext extends ULCBrowserContext {
	protected String fHelpUrl = null;
public ULCHelpBrowserContext() {
	super();
}
/**
 * Create a ULCHelpBrowserContext on the specified context.
 *
 * @param context com.ibm.ulc.application.ULCContext
 * @param browserPath java.lang.String
 * @param helpUrl java.lang.String The rootUrl for all Help requests.
 *
 * @see ULCComponent#getHelpUrl
 */
public ULCHelpBrowserContext(ULCContext context, String browserPath, String helpUrl) {
	super(context, browserPath);
	fHelpUrl = helpUrl;
}
/**
 * Return the Root Help URL as a string.
 */
public String getHelpUrl() {
	return fHelpUrl;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fHelpUrl != null)
		a.put("helpUrl", fHelpUrl);
}
/**
 * Set the Root Help URL as a String.
 */
public void setHelpUrl(String helpUrl) {
	fHelpUrl = helpUrl;
}
}
