package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * Implements the event that is sent when a hyperlink error occurs in an ULCHtmlPane.
 *
 * @see ULCHtmlPane
 * @see ULCHtmlPane#addLinkErrorListener
 */
public class ULCLinkErrorEvent extends ULCEvent {
	/**
	 * The URL of the link that was activated.
	 * @serial	 	 
	 */
	protected String fUrl = null;
	/**
	 * @serial	 	 
	 */
	protected String fErrorString = null;
/**
 * Contruct an ULCLinkErrorEvent with the specified source and URL and error string.
 *
 * @param source 		The <code>Object</code> that generated this event.
 * @param urlString		The URL as a <code>String</code> of the error link.
 * @param errorString	The <code>String</code> error that occurred on the url specified.
 */
ULCLinkErrorEvent(Object source, String urlString, String errorString) {
	super(source);
	fUrl = urlString;
	fErrorString = errorString;
}
/**
 * Dispatch this event to the specified object if it implements the IHyperLinkListener interface.
 *
 * @param listener	The object interested in my link activation events.
 */
public void dispatch(IListener listener) {
	if (listener instanceof IHyperLinkListener) {
		IHyperLinkListener l = (IHyperLinkListener) listener;
		l.linkError(this);
	}
}
/**
 * Return my Error string
 *
 * @return The error as a <code>String </code>.
 */
public String getErrorString() {
	return fErrorString;
}
/**
 * Return my URL string
 *
 * @return The URL as a <code>String </code>.
 */
public String getUrlString() {
	return fUrl;
}
}
