package com.ibm.ulc.application;

import java.util.Vector;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.UlcRange;
/**
 * The ULCLocalTableModel can act as the model for table and tree widgets simultaneously.
 */
public class ULCLocalTableModel extends ULCAbstractTableModel implements IIndexedTableModel {
	/**
	 * All the rows in the receiver
	 */
	Vector fRows = new Vector();

	/**
	 * The adapter used by the receiver for adapting it's rows
	 */
	IRowAdapter fRowAdapter;

	/**
	 * The default itemList for the receiver
	 */
	IIndexedItemList fIndexedItemList;

	/**
	 * Determines whether the receiver is going to listen for
	 * property change events
	 */
	boolean fListeningForPropertyChange = false;
/**
 * Construct a new ULCLocalTableModel
 */
public ULCLocalTableModel() {
	super();
}
/**
 * ULCSimpleTableModel constructor comment.
 *
 * @param prefetch 	int	determines how many rows of data are transmitted in a single request.
 */
public ULCLocalTableModel(int prefetch) {
	super(prefetch);
}
/**
 * Constructs a new ULCLocalTableModel with the specified number of prefetch rows 
 * and notification policy
 *
 * @param prefetch determines how many rows of data are transmitted in a single request.
 * @param policy	The notification policy
 * <pre>
 * Valid values are :
 *	TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE
 * 	TABLE_EDIT_UPDATE_ON_REQUEST
 *	TABLE_EDIT_UPDATE_ON_ROW_CHANGE
 * </pre>
 */
public ULCLocalTableModel(int prefetch, int policy) {
	super(prefetch, policy);
}
/**
 * Constructs a new ULCLocalTableModel with the specified number of prefetch rows and 
 * notification policy.
 * If veto is true then all updates are sent to the application for confirmation.
 *
 * @param prefetch 	determines how many rows of data are transmitted in a single request.
 * @param veto 		determines whether changes of a cell modify the UI Engine's cache
 *					directly or whether they are reported back to the application via the setValueAt calls.
 * @param policy	The notification policy
 * <pre>
 * Valid values are :
 *	TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE
 * 	TABLE_EDIT_UPDATE_ON_REQUEST
 *	TABLE_EDIT_UPDATE_ON_ROW_CHANGE
 * </pre>
 */
public ULCLocalTableModel(int prefetch, boolean veto, int policy) {
	super(prefetch, veto, policy);
}
/**
 * Construct a new ULCLocalTableModel
 * @param boolean veto ; Determines whether changes of a cell modify the UI Engine's 
 *							cache directly or whether they are reported back to the 
 *							application via the setValueAt calls.
 */
public ULCLocalTableModel(boolean veto) {
	super(veto);
}
/**
 * Constructs a new ULCLocalTableModel with the specified veto and notification policy.
 * If veto is true then all updates are sent to the application for confirmation.
 *
 * @param veto 		determines whether changes of a cell modify the UI Engine's cache
 *					directly or whether they are reported back to the application via the setValueAt calls.
 * @param policy	The notification policy
 * <pre>
 * Valid values are :
 *	TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE
 * 	TABLE_EDIT_UPDATE_ON_REQUEST
 *	TABLE_EDIT_UPDATE_ON_ROW_CHANGE
 * </pre>
 */
public ULCLocalTableModel(boolean veto, int policy) {
	super(veto, policy);
}
/**
 * Add a new itemList to be served by the receiver.
 *
 * The receiver informs all itemLists of any change in the receiver's data.
 *
 * @see ULCItemListAbstract
 */
public void addItemList(IItemList itemList) {
	if (fItemLists.length == 1)
		getAllRowIds();
	super.addItemList(itemList);
}
/**
 * Answer the default itemList for the receiver
 */
ULCDefaultItemList getDefaultItemList() {
	return (ULCDefaultItemList) fIndexedItemList;
}
/**
 * Answer the indexed itemList for the receiver
 */
public IIndexedItemList getIndexedItemList() {
	return fIndexedItemList;
}
/**
 * Answer the row aadapter for the receiver
 */
protected IRowAdapter getRowAdapter() {
	return fRowAdapter;
}
/**
 * Answer the object at the given index.
 *
 * @parm index		int the index of the interface
 *
 */
public Object getRowAtIndex(int index) {
	if (index < 0 || index >= getRowCount())
		return null;
	else
		return fRows.elementAt(index);
}
/**
 * Answer the size of the receiver's row collection.
 */
public int getRowCount() {
	return fRows.size();
}
/**
 * Answer the rows in the receiver
 */
public java.util.Vector getRows() {
	return fRows;
}
/**
 * Notification that the receiver's DefaultItemList has mapped index to an oid.
 * Inform my row cache accordingly.
 *
 * @param	index	int		The index which was mapped
 * @param	oid		int		The oid to which the index was mapped
 */
protected void indexWasMapped(int index, int oid) {
	getRowCache().setRowIdFor(oid, getRowAtIndex(index));
}
/**
 * Initialize the receiver
 *
 */
protected void initialize() {
	super.initialize();
	fRows = new Vector();
	resetDefaultItemList(null);
	fRowAdapter = new ULCRowAdapter();
	//	resetDefaultHierarchicalItemList(null);
}
/**
 * Answer boolean whether the receiver listens for property change events
 */
public boolean isListeningForPropertyChange() {
	return fListeningForPropertyChange;
}
/**
 * Notify UI TableModel that either contents or size of
 * ULC TableModel has changed.
 *
 * @param type 	The kind of change.
 * <pre>
 * type can be one of:
 *	TABLE_MODEL_CONTENTS_CHANGED;
 *	TABLE_MODEL_ROWS_ADDED;
 *	TABLE_MODEL_ROWS_REMOVED;
 *	TABLE_MODEL_ROWS_CHANGED;
 * </pre>
 * @param attributeNames An array of all attributes that have changed.
 * @param objects		An array of all objects that have changed
 */
public void notify(int type, String[] attributeNames, Object[] objects) {
	if (type == TABLE_MODEL_ROWS_ADDED) {
		Vector rowIds = new Vector();
		int rowCount = getRowCount();
		for (int i = 0; i < objects.length; i++) {
			fRows.addElement(objects[i]);
		}
		Vector ranges = new Vector();
		ranges.addElement(new UlcRange(rowCount, rowCount + objects.length - 1));
		getDefaultItemList().notify(type, null, ranges);
	}
	else {
		super.notify(type, attributeNames, objects);
	}
}
/**
 * Reset the receiver's default itemList.
 *
 * @param 	itemList	IIndexedItemList	The itemList to be reset
 */
protected void resetDefaultItemList(IIndexedItemList itemList) {
	if (itemList == null || itemList == getIndexedItemList()) {
		fIndexedItemList = new ULCDefaultItemList();
		fIndexedItemList.setModel(this);
		addItemList(fIndexedItemList);
	}
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveItemLists(Anything a) {
	a.put("iil", getIndexedItemList().getRef(fContext));
}
/**
 * Set the receiver to listening / not listening to property changes.
 * 
 * @param newListenForPropertyChange boolean	the new propertyListening state
 */
public void setListeningForPropertyChange(boolean listenForPropertyChange) {
	fListeningForPropertyChange = listenForPropertyChange;
}
/**
 * Set the row adapter for the receiver.
 *
 * @param rowAdapter IRowAdapter	The new row adapter
 */
public void setRowAdapter(IRowAdapter rowAdapter) {
	fRowAdapter = rowAdapter;
}
/**
 * Set the receiver's RowCache to an indexed one. The receiver implements the IndexedTableModel
 * interface locally.
 */
protected void setRowCache() {
	setRowCache(new ULCIndexedRowCache(this, this));
}
/**
 * Set the rows of the receiver, to the given rows.
 *
 * @param newRows Vector	the new set of rows
 */
public void setRows(java.util.Vector newRows) {
	fRows = (Vector) newRows.clone();
	getDefaultItemList().notify(TABLE_MODEL_CONTENTS_CHANGED, null, new Vector());
}
}
