package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import java.util.*;
import com.ibm.ulc.util.Assert;

/**
 * The <code>ULCMenuBar</code> in the menu of the application.
 * This is the object to which the various menus (ULCMenu) will
 * be added.
 *
 * @see ULCMenu
 */
public class ULCMenuBar extends ULCComponent {
public ULCMenuBar() {
}
/**
 * Appends another menu as a submenu to the end of this MenuBar.
 *
 * @param menu 	The <code>ULCMenu</code> to be added as a submenu.
 */
public void add(ULCMenu menu) {
	internalAdd(menu);
}
/**
 * Appends a collection of <code>ULCMenu's</code> to the end of this <code>ULCMenuBar</code>.
 *
 * @param menus	The collection of <code>ULCMenu</code> objects to be added.
 */
public void add(Vector menus) {
	internalAdd(menus);
}
/**
 * Gets the collection of <code>ULCMenu's</code> in this <code>ULCMenuBar</code>.
 *
 * @return The <code>Vector</code> containing <code>ULCMenu's</code>.
 */
public Vector getMenus() {
	Vector components = new Vector();
	Vector v = internalGetComponents();
	for (int i = 0; i < v.size(); i++) {
		Object next = v.elementAt(i);
		Assert.isTrue(next instanceof ULCMenu);
		components.addElement((ULCMenu) next);
	}
	return components;
}
/**
 * Remove the specified <code>ULCMenu</code> from my list of menus.
 *
 * @param menu  The <code>ULCMenu</code> to be removed.
 */
public void remove(ULCMenu menu) {
	internalRemove(menu);
}
/**
 * Remove all the specified <code>ULCMenu's</code> from my list of menus.
 *
 * @param menus  The <code>Vector</code> of <code>ULCMenu's</code> to be removed.
 */
public void remove(Vector ulcMenus) {
	internalRemove(ulcMenus);
}
/**
 * Sets the collection of <code>ULCMenu's</code> in this <code>ULCMenuBar</code>.
 *
 */
public void setMenus(Vector menus) {
	remove(getMenus());
	add(menus);
}
}
