package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;

/**
 * Used for ensuring that the value of a ULCField or ULCLabel is within a
 * pre-defined range. An invalid input (i.e. one outside the given range)
 * will be adjusted to lie within the range - for example if the range is 1 to 10, an input of 11
 * will be changed by the receiver to 10.
 */
public class ULCNumberValidator extends ULCProxy implements IDataType {
	/**
	 * The boolean when true converts the returned value to an integer. Default is false.
	 * @serial	 
	 */
	protected boolean fIntValue = false;
	/**
	 * The code of the formatting policy. 0 is java.lang. 1 is java.text. Default is 0.
	 * @serial	 
	 */
	protected int fFormattingPolicy = 0;
	/**
	 * The (Locale unaware) java.lang formatting policy
	 */
	public static final int JAVA_LANG_FORMATTING= 0;
	/**
	 * The (Locale aware) java.text formatting policy
	 */
	public static final int JAVA_TEXT_FORMATTING= 1;
	/**
	 * The minimum value allowed for this Validator. Default is none.
	 * @serial	 
	 */
	protected Object fMin = null;
	/**
	 * The maximum value allowed for this Validator. Default is none
	 * @serial	 
	 */
	protected Object fMax = null;
	/**
	 * Is grouping (thousandSeparator) to be used?. Default is false.
	 * @serial	 
	 */
	protected boolean fGroupingUsed = true;
	/**
	 * The minimum number of fraction digits to use in output. Default is 2.
	 * @serial	 
	 */
	protected int fMinFractionDigits = 2;
	/**
	 * The maximum number of fraction digits to use in output. Default is 2
	 * @serial	 
	 */
	protected int fMaxFractionDigits = 2;
/**
 * Default constructor.
 * Creation date: (08-30-99 4:14:04 PM)
 */
public ULCNumberValidator() {}
/**
 * Get the formatting policy (0: java.lang; 1: java.text NUMBERSTYLE).
 *
 * Creation date:  (21.02.00 12:37:30)
 * @return int
 */
public int getFormattingPolicy() {
	return fFormattingPolicy;
}
/**
 * get whether or not gouping should be used.
 *
 * Creation date:  (21.02.00 12:38:26)
 * @return boolean
 */
public boolean getGroupingUsed() {
	return fGroupingUsed;
}
/**
 * Get the max property.
 * Creation date:  (21.02.00 12:52:41)
 * @return Object
 */
public Object getMax() {
	return fMax;
}
/**
 * Get the maximum number of fraction digits.
 *
 * Creation date:  (21.02.00 12:53:38)
 * @return int
 */
public int getMaxFractionDigits() {
	return fMaxFractionDigits;
}
/**
 * Get the min property.
 * Creation date:  (21.02.00 12:52:26)
 * @return Object
 */
public Object getMin() {
	return fMin;
}
/**
 * Get the minimum number of fraction digits.
 *
 * Creation date:  (21.02.00 12:53:58)
 * @return int
 */
public int getMinFractionDigits() {
	return fMinFractionDigits;
}
/**
 * Answer the integer value property.
 * Creation date: (08-30-99 4:08:25 PM)
 * @return boolean
 */
public boolean isInteger() {
	return fIntValue;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	a.put("iv", fIntValue);
	a.put("style", fFormattingPolicy);
	if (fFormattingPolicy==1) {
		a.put("gru", fGroupingUsed);
		a.put("maxFD", fMaxFractionDigits);
		a.put("minFD", fMinFractionDigits);
	}
	if (fIntValue) { // Integer case
		if (fMin != null && fMin instanceof Integer) {
			Integer min = (Integer) fMin;
			a.put("min",min.intValue());
		}
		if (fMax != null && fMax instanceof Integer) {
			Integer max = (Integer) fMax;
			a.put("max",max.intValue());
		}
	} else { // Double case
		if (fMin != null && fMin instanceof Double) {
			Double min = (Double) fMin;
			a.put("min",min.doubleValue());
		}
		if (fMax != null && fMax instanceof Double) {
			Double max = (Double) fMax;
			a.put("max",max.doubleValue());
		}
	}
}
/**
 * Set the formatting policy (0: java.lang; 1: java.text NUMBERSTYLE).
 *
 * Creation date: (08-30-99 4:08:25 PM)
 */
public void setFormattingPolicy(int policy) {
	fFormattingPolicy = policy;
}
/**
 * Set whether or not gouping should be used.
 *
 * Creation date: (08-30-99 4:08:25 PM)
 */
public void setGroupingUsed(boolean useGroups) {
	fGroupingUsed = useGroups;
}
/**
 * Set the integer value property.
 * Creation date: (08-30-99 4:08:25 PM)
 * @return boolean
 */
public void setInteger(boolean newIntValue) {
	fIntValue = newIntValue;
}
/**
 * Set the max property to the given double (convenience).
 * Creation date: (08-30-99 4:08:25 PM)
 * @return boolean
 */
public void setMax(double newMax) {
	fMax = new Double(newMax);
}
/**
 * Set the max property to the given int (convenience).
 * Creation date: (08-30-99 4:08:25 PM)
 * @return boolean
 */
public void setMax(int newMax) {
	fMax = new Integer(newMax);
}
/**
 * Set the max property.
 * Creation date:   (21.02.00 12:57:05)
 */
public void setMax(Object newMax) {
	fMax = newMax;
}
/**
 * Set the maximum number of fraction digits.
 *
 * Creation date: (08-30-99 4:08:25 PM)
 */
public void setMaxFractionDigits(int maxDigits) {
	fMaxFractionDigits = maxDigits;
}
/**
 * Set the min property to the given double (convenience).
 * Creation date: (08-30-99 4:08:25 PM)
 */
public void setMin(double newMin) {
	fMin = new Double(newMin);
}
/**
 * Set the min property to the given int (convenience).
 * Creation date: (08-30-99 4:08:25 PM)
 */
public void setMin(int newMin) {
	fMin = new Integer(newMin);
}
/**
 * Set the min property.
 * Creation date:  (21.02.00 12:57:28)
 */
public void setMin(Object newMin) {
	fMin = newMin;
}
/**
 * Set the minimum number of fraction digits.
 *
 * Creation date: (08-30-99 4:08:25 PM)
 */
public void setMinFractionDigits(int minDigits) {
	fMinFractionDigits = minDigits;
}
}
