package com.ibm.ulc.application;

/**
 * Implement an enabler that can take many sources and enables its target if 
 * any one of its source components is enabled.
 */
public class ULCOrEnabler extends ULCEnabler {
public ULCOrEnabler() {
	super();
}
/**
 * Add a ULCComponent to the list of components that must be enabled 
 * before my target component is enabled.
 *
 * @param c The component to be added.
 */
public void add(IEnabler c) {
	internalAdd(c);
}
/**
 * Remove a ULCComponent to the list of components that must be enabled before my 
 * target component is enabled.
 *
 * @param c The component to be added.
 */
public void remove(IEnabler c) {
	internalRemove(c);
}
/**
 * Convenience method for the Visual Composition editor to ensure it shows up as a property
 */
public void setOr(IEnabler c) {
	add(c);
}
}
