package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;

/**
 * This widget is used for showing the progress of any task;
 * the application needs to set the values for the receiver
 * as the task progresses, and the receiver then displays the
 * 'progress' between a minimum and a maximum value.
 * @see #setValue(int) 
 */
public class ULCProgressBar extends ULCComponent {
	/**
	 * @serial
	 */
	private int fValue = 0;
	/**
	 * @serial
	 */
	private int fMinValue = 0;
	/**
	 * @serial
	 */
	private int fMaxValue = 100;
/**
 * Creates a progress bar for the range from 0 to 100 and the initial value of 0.
 */
public ULCProgressBar() {
}
/**
 * Creates a progress bar for the specified range and the initial value of 0.
 *
 * @param minimumValue The <code>int</code> minimum value for this ProgressBar.
 * @param maximumValue The <code>int</code> maximum value for this ProgressBar.
 */
public ULCProgressBar(int minimumValue, int maximumValue) {
	fValue = minimumValue;
	fMinValue = minimumValue;
	fMaxValue = maximumValue;
}
/**
 * Creates a progress bar for the specified range and initial value.
 *
 * @param value			The <code>int</code> initial value for this ProgressBar.
 * @param minimumValue 	The <code>int</code> minimum value for this ProgressBar.
 * @param maximumValue 	The <code>int</code> maximum value for this ProgressBar.
 */
public ULCProgressBar(int value, int minimumValue, int maximumValue) {
	fValue = value;
	fMinValue = minimumValue;
	fMaxValue = maximumValue;
}
/**
 * Returns the maximum value for this ProgressBar.
 *
 * @return The maximum <code>int</code> value 
 */
public int getMaximumValue() {
	return fMaxValue;
}
/**
 * Returns the minimum value for this ProgressBar.
 *
 * @return The minimum <code>int</code> value 
 */
public int getMinimumValue() {
	return fMinValue;
}
/**
 * Gets the current <code>int</code> value. It is adjusted to lie within the current range of the <code>ULCProgressBar</code>.
 *
 * @return  The <code>int</code> current value for this ProgressBar.
 */
public int getValue() {
	return fValue;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fValue != 0)
		a.put("value", fValue);
	if (fMinValue != 0)
		a.put("minValue", fMinValue);
	if (fMaxValue != 100)
		a.put("maxValue", fMaxValue);
}
/**
 * Sets the maximum <code>int</code> value. 
 * Setting this value after the widget has been uploaded has no effect.
 *
 * @param value The <code>int</code> maximum value for this ProgressBar.
 */
public void setMaximumValue(int value) {
	fMaxValue = value;
}
/**
 * Sets the minimum <code>int</code> value.
 * Setting this value after the widget has been uploaded has no effect.
 *
 * @param value The <code>int</code> minimum value for this ProgressBar.
 */
public void setMinimumValue(int value) {
	fMinValue = value;
}
/**
 * Sets the current <code>int</code> value. It is adjusted to lie within the current range of the <code>ULCProgressBar</code>.
 *
 * @param value The <code>int</code> current value for this ProgressBar.
 */
public void setValue(int value) {
	if (value != fValue) {
		fValue = value;
		sendUI("setValue", new Anything(fValue));
	}
}
}
