package com.ibm.ulc.application;

import java.util.Vector;
public abstract class ULCSharedProxy extends ULCProxy implements ISharedProxy {
	protected Vector fOwners = new Vector();
/**
 * ULCSharedProxy constructor comment.
 */
public ULCSharedProxy() {
	super();
}
/**
 * ULCSharedProxy constructor comment.
 * @param context com.ibm.ulc.application.ULCContext
 */
public ULCSharedProxy(ULCContext context) {
	super(context);
}
/**
 * Add the proxy as a owner.
 */
public void addOwner(IProxy proxy) {
	if (!getOwners().contains(proxy))
		getOwners().addElement(proxy);
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	super.free();
	getOwners().removeAllElements();
}
/**
 * Return the list of objects that refer to me.
 */
public Vector getOwners() {
	if (fOwners == null)
		fOwners = new Vector();
	return fOwners;
}
/**
 * Release all the resources of the receiver's including
 * the resources on the UI side
 *
 * WARNING: This method should only be called on instances
 *          that are no longer used by any other component
 */
public void release() {
	if (getOwners().size() > 0)
		System.out.println("Warning: Releasing a model that is currently being used. Widgets can now be inconsistant");
	super.release();
}
/**
 * Remove the proxy as a owner.
 */
public void removeOwner(IProxy proxy) {
	getOwners().removeElement(proxy);
}
}
