package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;

/**
 * Example implementation for a String formatter.
 * Used for formatting the string input in a text field, to some
 * pre-defined format. For example, it can convert all the characters
 * to uppercase, or to lowercase and optionally to limit the length.
 */
public class ULCStringFormatter extends ULCProxy implements IDataType {
	/**
	 * Constant that indicates the no change mode of the formatter.
	 * @serial	 
	 */
	public static final int IDENTITY = 0;
	/**
	 * Constant that indicates that all input should be converted to uppercase.
	 * @serial	 
	 */
	public static final int ALL_UPPER_CASE = 1;
	/**
	 * Constant that indicates that all input should be converted to lowercase.
	 * @serial	 
	 */
	public static final int ALL_LOWER_CASE = 2;
	/**
	 * Current mode of the formatter.
	 * @serial	 
	 */
	protected int fMode = IDENTITY;
	/**
	 * Maximum length of input allowed. Default = -1 indicating no limit.
	 * @serial	 
	 */
	protected int fMaxLength = -1;
/**
 * Default Constructor for a <code>ULCStringFormatter</code>.
 */
public ULCStringFormatter() {
}
/**
 * Construct an <code>ULCStringFormatter</code> with maximum string length as specified.
 *
 * @param maxLength	The maximum length in characters for the input
 */
public ULCStringFormatter(int maxLength) {
	fMaxLength = maxLength;
}
/**
 * Construct an <code>ULCStringFormatter</code> with maximum string length as specified and <code>mode</code>.
 * <pre>
 * <code>mode</code> can be one of:
 * 		IDENTITY = 0;
 *		ALL_UPPER_CASE = 1;
 *		ALL_LOWER_CASE = 2;
 * </pre>
 * @param maxLength	The maximum length in characters for the input
 */
public ULCStringFormatter(int maxLength, int mode) {
	fMaxLength = maxLength;
	fMode = mode;
}
/**
 * Answer the max length property.
 * @return int
 */
public int getMaxLength() {
	return fMaxLength;
}
/**
 * Answer the mode property.
 * 
 * @return int
 */
public int getMode() {
	return fMode;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fMaxLength != -1)
		a.put("maxLength", fMaxLength);
	if (fMode != IDENTITY)
		a.put("mode", fMode);
}
/**
 * Set the max length property.
 * 
 * @return int
 */
public void setMaxLength(int newMaxLength) {
	fMaxLength = newMaxLength;
}
/**
 * Set the mode property.
 * 
 * @return int
 */
public void setMode(int newMode) {
	fMode = newMode;
}
}
