package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import java.util.*;
/**
 * An event that characterized actions occuring on a tree widget.
 *
 * @see ITreeListener The object that listens for this event.
 */
public class ULCTreeEvent extends ULCActionEvent {
	/** 
	 * The currently selected nodes
	 * @serial	 	 
	 */
	protected Vector fSelectedNodes;
/**
 * Construct a ULCTreeEvent for the specified selection node.
 *
 * @param source 			The source of this event.
 * @param cmd 				The command associated with this event.
 * @param selectedNode	 	Selected node.
 */
public ULCTreeEvent(Object source, String cmd, Object selectedNode) {
	super(source, cmd);
	Vector nodes = new Vector(1);
	nodes.addElement(selectedNode);
	fSelectedNodes = nodes;
}
/**
 * Construct a ULCTreeEvent for the specified selection nodes.
 *
 * @param source 			The source of this event.
 * @param cmd 				The command associated with this event.
 * @param selectedNodes 	Vector of selected nodes.
 */
public ULCTreeEvent(Object source, String cmd, Vector selectedNodes) {
	super(source, cmd);
	fSelectedNodes = selectedNodes;
}
/**
 * Dispatch this event to the specified object if it implements 
 * the ITreeListener interface.
 *
 * @param listener the <code>IListener</code> that is interested in this event. 
 */
public void dispatch(IListener listener) {
	if (listener instanceof ITreeListener) {
		ITreeListener treeListener = (ITreeListener) listener;
		if (fCmd.equals("nodeCollapsed")) {
			treeListener.treeCollapsed(this);
			return;
		}
		if (fCmd.equals("nodeExpanded")) {
			treeListener.treeExpanded(this);
			return;
		}
		if (fCmd.equals("defaultAction")) {
			treeListener.treeActionPerformed(this);
			return;
		}
		if (fCmd.equals("selectionChanged")) {
			treeListener.treeSelected(this);
			return;
		}
	}
}
/**
 * Returns the first node of the selection range or null if none are selected.
 */
public Object getSelectedNode() {
	if ((fSelectedNodes != null) && (fSelectedNodes.size() != 0))
		return fSelectedNodes.firstElement();
	else
		return null;
}
/**
 * Returns all the nodes of the selection.
 *
 * @return  Vector of selected nodes.
 */
public Vector getSelectedNodes() {
	return fSelectedNodes;
}
}
