package com.ibm.ulc.application;

/**
 * A ULCTreeItemList uses an adapter to manage the ordering of the
 * hierarchy.
 */
public class ULCTreeItemList extends ULCHierarchicalItemList {
	/**
	 * The hierarchy adapter specified for managing the receiver's
	 * node ordering.
	 */
	protected IHierarchyAdapter fHierarchyAdapter;
	
	/**
	 * Internal state indicating whether the receiver's root has been
	 * explicitly set to null by the application.
	 */
	protected boolean fExplicitNullRoot = false;
/**
 * Construct a new ULCTreeItemList
 */
public ULCTreeItemList() {
	super();
}
/**
 * Answer the adapter that implements the needed API to manage the receiver's
 * nodes.
 */
public IHierarchyAdapter getHierarchyAdapter() {
	return fHierarchyAdapter;
}
/**
 * Answer the root object for the receiver's hierarchy
 */
public java.lang.Object getRoot() {
	if (fRoot == null && fExplicitNullRoot)
		return null;
	else
		return super.getRoot();
}
/**
 * Set the adapter that implements the needed API to manage the receiver's
 * nodes.
 *
 * @param hierarchyAdapter		IHierarchyAdapter	The new adapter
 */
public void setHierarchyAdapter(IHierarchyAdapter hierarchyAdapter) {
	fHierarchyAdapter = hierarchyAdapter;
}
/**
 * Set the given object as the new root for the receiver. 
 * Flag the receiver is the root was set to null.
 *
 * @param 	newRoot 	Object	The new root for the receiver's hierarchy
 */
public void setRoot(Object newRoot) {
	fExplicitNullRoot = (newRoot == null);
	super.setRoot(newRoot);
}
}
