package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * This is the event that gets triggered when the value changes,
 * say in a field (ULCField), slider (ULCSlider) etc.
 */
public class ULCValueChangedEvent extends ULCEvent {
	/**
	 * The new value that caused this event
	 * @serial
	 */
	protected Object fValue = null;
/**
 * Construct a ULCValueChangedEvent from a given source and new value.
 *
 * @param source 	The source.
 * @param value 	The new value.
 */
public ULCValueChangedEvent(Object source, Object value) {
	super(source);
	fValue= value;
}
/**
 * Dispatch this event to the specified object if it implements the IValueChangeListener interface.
 *
 * @param listener	The listener interested in the event
 */
public void dispatch(IListener listener) {
	if (listener instanceof IValueChangedListener) {
		IValueChangedListener vl = (IValueChangedListener) listener;
		vl.valueChanged(this);
	}
}
/**
 * Returns the object (value) associated with this event.
 *
 * @return <code>Object</code> value or null if none.
 */
public Object getValue() {
	return fValue;
}
}
